/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp;

import de.jreality.io.JrScene;
import de.jreality.jogl.ViewerAwt;
import de.jreality.reader.ReaderJRS;
import de.jreality.reader.Readers;
import de.jreality.scene.Appearance;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Viewer;
import de.jreality.toolsystem.ToolSystem;
import de.jreality.toolsystem.config.ToolSystemConfiguration;
import de.jreality.ui.viewerapp.AbstractViewerApp;
import de.jreality.ui.viewerapp.BeanShell;
import de.jreality.ui.viewerapp.Navigator;
import de.jreality.ui.viewerapp.SelectionManagerImpl;
import de.jreality.ui.viewerapp.UIFactory;
import de.jreality.ui.viewerapp.ViewerAppMenu;
import de.jreality.ui.viewerapp.ViewerSwitch;
import de.jreality.util.CameraUtility;
import de.jreality.util.Input;
import de.jreality.util.LoggingSystem;
import de.jreality.util.Secure;
import de.jreality.util.SystemProperties;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.Beans;
import java.beans.Expression;
import java.beans.Statement;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

public class ViewerApp
extends AbstractViewerApp {
    private JFrame frame;
    private UIFactory uiFactory = new UIFactory();
    private JFrame externalBeanShellFrame;
    private boolean externalNavigator = false;
    private JFrame externalNavigatorFrame;
    private LinkedList<Component> accessory = new LinkedList();
    private Component showFirstAccessory;
    private HashMap<Component, String> accessoryTitles = new HashMap();
    private HashMap<Component, JScrollPane> accessoryScrolls = new HashMap();
    private JTabbedPane navigatorTabs;
    private boolean showMenu = true;
    private boolean createMenu = true;
    private ViewerAppMenu menu;

    public ViewerApp(SceneGraphNode node) {
        super(node);
    }

    public ViewerApp(JrScene scene) {
        super(scene);
    }

    public ViewerApp(Viewer[] vs) {
        super(vs);
    }

    public ViewerApp(SceneGraphNode node, boolean onlySoftware) {
        super(node, onlySoftware);
    }

    public ViewerApp(SceneGraphNode contentNode, SceneGraphComponent root, SceneGraphPath cameraPath, SceneGraphPath emptyPick, SceneGraphPath avatar) {
        super(contentNode, root, cameraPath, emptyPick, avatar);
    }

    protected void init(SceneGraphNode contentNode, SceneGraphComponent root, SceneGraphPath cameraPath, SceneGraphPath emptyPick, SceneGraphPath avatar) {
        super.init(contentNode, root, cameraPath, emptyPick, avatar);
        this.frame = new JFrame();
    }

    public static void main(String[] args) throws IOException {
        ViewerApp va;
        boolean navigator = true;
        boolean beanshell = false;
        boolean external = true;
        boolean callEncompass = false;
        if (args.length != 0) {
            LinkedList<String> params = new LinkedList<String>();
            for (String p : args) {
                params.add(p);
            }
            if (params.contains("-h") || params.contains("--help")) {
                System.out.println("Usage:  ViewerApp [-options] [file list]");
                System.out.println("\t -s \t the (single) file given is a .jrs file containing a whole scene\n\t\t (otherwise all specified files are loaded into the default scene)");
                System.out.println("\t -n \t show navigator");
                System.out.println("\t -b \t show beanshell");
                System.out.println("\t -i \t show navigator and/or beanshell in the main frame\n\t\t (otherwise they are opened in separate frames)");
                System.exit(0);
            }
            boolean scene = params.remove("-s");
            navigator = params.remove("-n");
            beanshell = params.remove("-b");
            boolean bl = external = !params.remove("-i");
            if (scene) {
                if (params.size() != 1) {
                    throw new IllegalArgumentException("exactly one scene file allowed");
                }
                ReaderJRS r = new ReaderJRS();
                r.setInput(Input.getInput((String)params.getLast()));
                va = new ViewerApp(r.getScene());
            } else {
                SceneGraphComponent cmp = new SceneGraphComponent("content");
                for (String file : params) {
                    try {
                        cmp.addChild(Readers.read(Input.getInput(file)));
                        callEncompass = true;
                    }
                    catch (IOException e) {
                        System.out.println(e.getMessage());
                    }
                }
                va = new ViewerApp(cmp);
            }
        } else {
            va = new ViewerApp(null, null, null, null, null);
        }
        va.setAttachNavigator(navigator);
        va.setExternalNavigator(external);
        va.setAttachBeanShell(beanshell);
        va.setExternalBeanShell(external);
        va.update();
        if (callEncompass) {
            CameraUtility.encompass(va.getToolSystem().getAvatarPath(), va.getToolSystem().getEmptyPickPath(), va.getViewer().getCameraPath(), 1.75, 0);
        }
        va.display();
    }

    public void display() {
        try {
            String os = Secure.getProperty("os.name");
            boolean macOS = os.equalsIgnoreCase("Mac OS X");
            if (!macOS) {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        this.frame.setLocationByPlatform(true);
        if (this.getSceneRoot().getAppearance() != null && this.getSceneRoot().getAppearance().getAttribute("backgroundColors") == Appearance.INHERITED && this.getSceneRoot().getAppearance().getAttribute("backgroundColor") == Appearance.INHERITED) {
            this.setBackgroundColor(defaultBackgroundColor);
        }
        this.frame.setTitle("jReality Viewer");
        if (!Beans.isDesignTime()) {
            this.frame.setDefaultCloseOperation(3);
        }
        this.frame.validate();
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public static ViewerApp display(SceneGraphNode node) {
        ViewerApp va = new ViewerApp(node);
        va.setAttachNavigator(false);
        va.setExternalNavigator(false);
        va.setAttachBeanShell(false);
        va.setExternalBeanShell(false);
        va.update();
        va.display();
        return va;
    }

    public static ViewerApp display(SceneGraphComponent root, SceneGraphPath cameraPath, SceneGraphPath emptyPick, SceneGraphPath avatar) {
        ViewerApp va = new ViewerApp(null, root, cameraPath, emptyPick, avatar);
        va.setAttachNavigator(false);
        va.setExternalNavigator(false);
        va.setAttachBeanShell(false);
        va.setExternalBeanShell(false);
        va.update();
        va.display();
        return va;
    }

    public void update() {
        this.showExternalBeanShell(this.attachBeanShell && this.externalBeanShell);
        this.showExternalNavigator(this.attachNavigator && this.externalNavigator);
        if (this.createMenu) {
            if (this.menu == null) {
                this.menu = new ViewerAppMenu(this);
            }
            if (this.frame.getJMenuBar() == null) {
                JMenuBar menuBar = this.menu.getMenuBar();
                menuBar.setBorder(BorderFactory.createEmptyBorder());
                this.frame.setJMenuBar(menuBar);
            }
            this.menu.update();
        } else {
            this.frame.setJMenuBar(null);
        }
        this.frame.getContentPane().removeAll();
        this.frame.getContentPane().add(this.getContent());
        this.frame.validate();
    }

    protected ToolSystem createToolSystem() throws IOException {
        String config = Secure.getProperty("de.jreality.scene.tool.Config", "default");
        boolean remotePortal = config.equals("portal-remote");
        if (this.viewers == null) {
            String viewer;
            if (remotePortal) {
                viewer = Secure.getProperty(SystemProperties.VIEWER, "de.jreality.jogl.ViewerAwt");
                try {
                    this.viewers = new Viewer[]{this.createViewer(viewer)};
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            } else {
                viewer = Secure.getProperty(SystemProperties.VIEWER, "de.jreality.jogl.ViewerAwt de.jreality.softviewer.SoftViewer");
                if (this.onlyBuildsoftware) {
                    viewer = Secure.getProperty(SystemProperties.VIEWER, "de.jreality.softviewer.SoftViewer");
                }
                String[] vrs = viewer.split(" ");
                LinkedList<Viewer> viewerList = new LinkedList<Viewer>();
                for (int i = 0; i < vrs.length; ++i) {
                    String viewerClassName = vrs[i];
                    try {
                        Viewer v = this.createViewer(viewerClassName);
                        viewerList.add(v);
                        continue;
                    }
                    catch (Exception e) {
                        LoggingSystem.getLogger(this).info("could not create viewer instance of [" + viewerClassName + "]");
                        continue;
                    }
                    catch (NoClassDefFoundError ndfe) {
                        continue;
                    }
                    catch (UnsatisfiedLinkError le) {
                        // empty catch block
                    }
                }
                this.viewers = viewerList.toArray(new Viewer[viewerList.size()]);
            }
        }
        if (this.viewerSwitch == null) {
            this.viewerSwitch = new ViewerSwitch(this.viewers);
        }
        LoggingSystem.getLogger(this).fine("current viewer of viewer switch is " + this.viewerSwitch.getCurrentViewer());
        ToolSystemConfiguration cfg = this.loadToolSystemConfiguration(config);
        if (!remotePortal) {
            if (this.toolSystem == null) {
                this.toolSystem = new ToolSystem(this.viewerSwitch, cfg, this.synchRender ? this.renderTrigger : null);
            }
        } else {
            try {
                Class<?> portalToolSystem = Class.forName("de.jreality.toolsystem.PortalToolSystemImpl");
                Constructor<?> cc = portalToolSystem.getConstructor(ViewerAwt.class, ToolSystemConfiguration.class);
                ViewerAwt cv = (ViewerAwt)this.getCurrentViewer();
                this.toolSystem = (ToolSystem)cc.newInstance(cv, cfg);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.viewerSwitch.setToolSystem(this.toolSystem);
        return this.toolSystem;
    }

    protected void setupBeanShell() {
        this.beanShell = new BeanShell(this.selectionManager);
        this.beanShell.eval("import de.jreality.geometry.*;");
        this.beanShell.eval("import de.jreality.math.*;");
        this.beanShell.eval("import de.jreality.scene.*;");
        this.beanShell.eval("import de.jreality.scene.data.*;");
        this.beanShell.eval("import de.jreality.scene.tool.*;");
        this.beanShell.eval("import de.jreality.shader.*;");
        this.beanShell.eval("import de.jreality.tools.*;");
        this.beanShell.eval("import de.jreality.util.*;");
        try {
            Object bshEval = new Expression(this.beanShell, "getBshEval", null).getValue();
            Object interpreter = new Expression(bshEval, "getInterpreter", null).getValue();
            new Statement(interpreter, "set", new Object[]{"_viewer", this.viewerSwitch}).execute();
            new Statement(interpreter, "set", new Object[]{"_toolSystem", this.toolSystem}).execute();
            new Statement(interpreter, "set", new Object[]{"_viewerApp", this}).execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Component beanShell = this.beanShell.getComponent();
        beanShell.setPreferredSize(new Dimension(0, 100));
        beanShell.setMinimumSize(new Dimension(10, 100));
    }

    protected void setupNavigator() {
        this.navigator = new Navigator(this.getViewerSwitch(), this.frame);
        this.navigator.setPropagateSelections(this.propagateSelection);
        Component navigator = this.navigator.getComponent();
        navigator.setPreferredSize(new Dimension(200, 0));
        navigator.setMinimumSize(new Dimension(200, 10));
        try {
            ((JSplitPane)navigator).setDividerLocation(350);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void showExternalNavigator(boolean show) {
        if (this.externalNavigatorFrame == null) {
            if (!show) {
                return;
            }
            this.externalNavigatorFrame = new JFrame("jReality Navigator");
            this.externalNavigatorFrame.setSize(new Dimension(300, 800));
            this.externalNavigatorFrame.addComponentListener(new ComponentAdapter(){

                public void componentHidden(ComponentEvent e) {
                    if (ViewerApp.this.externalNavigator) {
                        ViewerApp.this.setAttachNavigator(false);
                        if (ViewerApp.this.createMenu) {
                            ViewerApp.this.menu.update();
                        }
                    }
                }
            });
        }
        if (show == this.externalNavigatorFrame.isVisible()) {
            return;
        }
        if (show) {
            this.externalNavigatorFrame.remove(this.externalNavigatorFrame.getContentPane());
            this.externalNavigatorFrame.getContentPane().add(this.getNavigatorWithAccessories());
            this.externalNavigatorFrame.setVisible(true);
        } else {
            this.externalNavigatorFrame.setVisible(false);
        }
    }

    public void showExternalBeanShell(boolean show) {
        if (this.externalBeanShellFrame == null) {
            if (!show) {
                return;
            }
            this.externalBeanShellFrame = new JFrame("jReality BeanShell");
            this.externalBeanShellFrame.setSize(new Dimension(800, 150));
            this.externalBeanShellFrame.addComponentListener(new ComponentAdapter(){

                public void componentHidden(ComponentEvent e) {
                    if (ViewerApp.this.externalBeanShell) {
                        ViewerApp.this.setAttachBeanShell(false);
                        if (ViewerApp.this.createMenu) {
                            ViewerApp.this.menu.update();
                        }
                    }
                }
            });
        }
        if (show == this.externalBeanShellFrame.isVisible()) {
            return;
        }
        if (show) {
            this.externalBeanShellFrame.remove(this.externalBeanShellFrame.getContentPane());
            this.externalBeanShellFrame.getContentPane().add(this.getBeanShell());
            this.externalBeanShellFrame.setVisible(true);
        } else {
            this.externalBeanShellFrame.setVisible(false);
        }
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public Component getComponent() {
        return this.getContent();
    }

    public Component getContent() {
        Component cmp;
        this.uiFactory.setViewer(this.getViewingComponent());
        boolean includeNavigator = this.attachNavigator && !this.externalNavigator;
        this.uiFactory.setAttachNavigator(includeNavigator);
        if (includeNavigator) {
            this.uiFactory.setNavigator(this.getNavigatorWithAccessories());
        }
        boolean includeBeanShell = this.attachBeanShell && !this.externalBeanShell;
        this.uiFactory.setAttachBeanShell(includeBeanShell);
        if (includeBeanShell) {
            this.uiFactory.setBeanShell(this.getBeanShell());
        }
        try {
            cmp = this.uiFactory.getDefaultUI();
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedOperationException("No viewer instantiated, call update()");
        }
        return cmp;
    }

    public Component getNavigator() {
        if (this.navigator == null) {
            this.setupNavigator();
        }
        return this.navigator.getComponent();
    }

    public void setPropagateSelection(boolean b) {
        this.propagateSelection = b;
        if (this.navigator != null) {
            this.navigator.setPropagateSelections(b);
        }
    }

    public Component getBeanShell() {
        if (this.beanShell == null) {
            this.setupBeanShell();
        }
        return this.beanShell.getComponent();
    }

    public Component getNavigatorWithAccessories() {
        if (this.navigatorTabs == null) {
            this.navigatorTabs = new JTabbedPane(1, 1);
        }
        this.navigatorTabs.removeAll();
        this.navigatorTabs.add("Scene graph", this.getNavigator());
        for (Component c : this.accessory) {
            if (this.accessoryScrolls.get(c) != null) {
                this.navigatorTabs.addTab(this.accessoryTitles.get(c), this.accessoryScrolls.get(c));
                continue;
            }
            this.navigatorTabs.addTab(this.accessoryTitles.get(c), c);
        }
        if (this.showFirstAccessory != null) {
            JScrollPane jsp = this.accessoryScrolls.get(this.showFirstAccessory);
            if (jsp != null) {
                this.navigatorTabs.setSelectedComponent(jsp);
            } else if (this.navigatorTabs.isAncestorOf(this.showFirstAccessory)) {
                this.navigatorTabs.setSelectedComponent(this.showFirstAccessory);
            }
        }
        return this.navigatorTabs;
    }

    public Component getViewingComponent() {
        return this.getViewerSwitch().getViewingComponent();
    }

    public ViewerAppMenu getMenu() {
        if (this.createMenu) {
            if (this.menu == null) {
                this.menu = new ViewerAppMenu(this);
            }
        } else {
            throw new IllegalStateException("You chose to not create the menu.");
        }
        return this.menu;
    }

    public void addAccessory(Component c) {
        this.addAccessory(c, c.getName());
    }

    public void addAccessory(Component c, String title) {
        this.addAccessory(c, c.getName(), true);
    }

    public void addAccessory(Component c, String title, boolean scrolling) {
        this.accessory.add(c);
        this.accessoryTitles.put(c, title);
        if (scrolling) {
            JScrollPane scroll = new JScrollPane(c);
            scroll.setBorder(BorderFactory.createEmptyBorder());
            this.accessoryScrolls.put(c, scroll);
        }
    }

    public void setFirstAccessory(Component c) {
        this.showFirstAccessory = c;
    }

    public void removeAccessory(Component c) {
        this.accessory.remove(c);
    }

    public void dispose() {
        if (this.autoRender) {
            this.renderTrigger.removeSceneGraphComponent(this.sceneRoot);
            this.renderTrigger.removeViewer(this.viewerSwitch);
        }
        this.viewerSwitch.dispose();
        if (this.toolSystem != null) {
            this.toolSystem.dispose();
        }
        SelectionManagerImpl.disposeForViewer(this.viewerSwitch);
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.frame.getContentPane().removeAll();
        this.frame.dispose();
        if (this.externalNavigatorFrame != null) {
            this.externalNavigatorFrame.dispose();
        }
        if (this.externalBeanShellFrame != null) {
            this.externalBeanShellFrame.dispose();
        }
        for (Viewer v : this.viewers) {
            v.setSceneRoot(null);
            v.setCameraPath(null);
            v.setAuxiliaryRoot(null);
        }
        this.viewers = null;
    }
}

