/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.treeview;

import de.jreality.scene.Appearance;
import de.jreality.scene.Camera;
import de.jreality.scene.Geometry;
import de.jreality.scene.Light;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.Transformation;
import java.awt.Component;
import java.net.URL;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JList;

public class JListRenderer
extends DefaultListCellRenderer {
    static final ImageIcon trafoIcon = JListRenderer.createImageIcon("icons/TrafoIcon.jpg");
    static final ImageIcon camIcon = JListRenderer.createImageIcon("icons/CamIcon.jpg");
    static final ImageIcon geomIcon = JListRenderer.createImageIcon("icons/GeometryIcon.jpg");
    static final ImageIcon sgcIcon = JListRenderer.createImageIcon("icons/SceneGraphComponentIcon.jpg");
    static final ImageIcon appIcon = JListRenderer.createImageIcon("icons/AppearanceIcon.jpg");
    static final ImageIcon lightIcon = JListRenderer.createImageIcon("icons/LightIcon.jpg");
    final SceneGraphVisitor iconSelector = new SceneGraphVisitor(){

        public void visit(Appearance a) {
            JListRenderer.this.setIcon(appIcon);
        }

        public void visit(Geometry g) {
            JListRenderer.this.setIcon(geomIcon);
        }

        public void visit(SceneGraphComponent c) {
            JListRenderer.this.setIcon(sgcIcon);
        }

        public void visit(Transformation t) {
            JListRenderer.this.setIcon(trafoIcon);
        }

        public void visit(Camera c) {
            JListRenderer.this.setIcon(camIcon);
        }

        public void visit(Light l) {
            JListRenderer.this.setIcon(lightIcon);
        }
    };
    final StringBuffer buffer = new StringBuffer(30);

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL = JListRenderer.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean focus) {
        SceneGraphNode m = (SceneGraphNode)value;
        this.buffer.append(m.getName());
        Component c = super.getListCellRendererComponent((JList<?>)list, this.buffer.toString(), index, selected, focus);
        this.buffer.setLength(0);
        m.accept(this.iconSelector);
        return c;
    }
}

