/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem.virtual;

import de.jreality.scene.tool.AxisState;
import de.jreality.scene.tool.InputSlot;
import de.jreality.toolsystem.DeviceManager;
import de.jreality.toolsystem.MissingSlotException;
import de.jreality.toolsystem.ToolEvent;
import de.jreality.toolsystem.VirtualDevice;
import de.jreality.toolsystem.VirtualDeviceContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualTimestepEvolution
implements VirtualDevice {
    InputSlot inSlot;
    InputSlot timer;
    InputSlot outSlot;
    double gain = 1.0;
    boolean released = false;

    @Override
    public ToolEvent process(VirtualDeviceContext context) throws MissingSlotException {
        double dt;
        if (context.getEvent().getSource().getClass() == DeviceManager.class) {
            return new ToolEvent(context.getEvent().getSource(), context.getEvent().getTimeStamp(), this.outSlot, AxisState.ORIGIN);
        }
        double axisValue = context.getAxisState(this.inSlot).doubleValue();
        double val = axisValue * (dt = this.gain * (double)context.getAxisState(this.timer).intValue() * 0.001);
        if (val == 0.0) {
            if (this.released) {
                return null;
            }
            this.released = true;
        } else {
            this.released = false;
        }
        return new ToolEvent(context.getEvent().getSource(), context.getEvent().getTimeStamp(), this.outSlot, new AxisState(val)){
            private static final long serialVersionUID = 1349929946764175018L;

            protected void replaceWith(ToolEvent replacement) {
                this.axis = new AxisState(this.axis.intValue() + replacement.getAxisState().intValue());
            }
        };
    }

    @Override
    public void initialize(List<InputSlot> inputSlots, InputSlot result, Map<String, Object> configuration) {
        this.inSlot = inputSlots.get(0);
        this.timer = inputSlots.get(1);
        this.outSlot = result;
        try {
            this.gain = (Double)configuration.get("gain");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public String getName() {
        return "TimestepEvolution";
    }
}

