/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem.virtual;

import de.jreality.math.Matrix;
import de.jreality.math.P3;
import de.jreality.math.Rn;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.tool.InputSlot;
import de.jreality.toolsystem.MissingSlotException;
import de.jreality.toolsystem.ToolEvent;
import de.jreality.toolsystem.VirtualDevice;
import de.jreality.toolsystem.VirtualDeviceContext;
import java.util.List;
import java.util.Map;

public class VirtualRotation
implements VirtualDevice {
    InputSlot pointerNDC;
    InputSlot cameraToWorld;
    InputSlot out;
    private double gain = 4.0;
    private Matrix result = new Matrix();
    private DoubleArray da = new DoubleArray(this.result.getArray());
    private double oldX = 2.147483647E9;
    private double oldY;
    private double[] mouseCoords = new double[3];
    private double[] mouseCoordsOld = new double[3];

    public ToolEvent process(VirtualDeviceContext context) throws MissingSlotException {
        double y;
        if (context.getEvent().getInputSlot() == this.cameraToWorld) {
            return null;
        }
        DoubleArray pointer = context.getTransformationMatrix(this.pointerNDC);
        if (pointer == null) {
            throw new MissingSlotException(this.pointerNDC);
        }
        if (this.oldX == 2.147483647E9) {
            this.oldX = pointer.getValueAt(3);
            this.oldY = pointer.getValueAt(7);
            return null;
        }
        double x = pointer.getValueAt(3);
        double dist = x * x + (y = pointer.getValueAt(7)) * y;
        double z = 2.0 > dist ? Math.sqrt(2.0 - dist) : 0.0;
        Rn.setToValue(this.mouseCoords, x, y, z);
        this.mouseCoords = Rn.normalize(this.mouseCoords, this.mouseCoords);
        double[] cross = Rn.crossProduct(null, this.mouseCoordsOld, this.mouseCoords);
        double angle = this.gain * Math.asin(Rn.euclideanNorm(cross));
        double[] cross4 = new double[]{cross[0], cross[1], cross[2], 0.0};
        cross = new Matrix(context.getTransformationMatrix(this.cameraToWorld)).multiplyVector(cross4);
        this.result.assignFrom(P3.makeRotationMatrix(null, cross, angle));
        Rn.setToValue(this.mouseCoordsOld, x, y, z);
        return new ToolEvent((Object)this, context.getEvent().getTimeStamp(), this.out, this.da);
    }

    public void initialize(List inputSlots, InputSlot result, Map configuration) {
        this.pointerNDC = (InputSlot)inputSlots.get(0);
        this.cameraToWorld = (InputSlot)inputSlots.get(1);
        this.out = result;
        if (configuration != null) {
            try {
                this.gain = (Double)configuration.get("gain");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void dispose() {
    }

    public String getName() {
        return "Virtual: Rotation";
    }
}

