/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem.virtual;

import de.jreality.scene.tool.AxisState;
import de.jreality.scene.tool.InputSlot;
import de.jreality.toolsystem.MissingSlotException;
import de.jreality.toolsystem.ToolEvent;
import de.jreality.toolsystem.VirtualDevice;
import de.jreality.toolsystem.VirtualDeviceContext;
import java.util.List;
import java.util.Map;

public class VirtualExtractPositive
implements VirtualDevice {
    InputSlot inAxis;
    InputSlot outSlot;
    AxisState state = null;
    double min = 0.1;

    public ToolEvent process(VirtualDeviceContext context) throws MissingSlotException {
        if (this.state == null) {
            this.state = AxisState.ORIGIN;
            return new ToolEvent((Object)this, this.outSlot, this.state);
        }
        double val = context.getAxisState(this.inAxis).doubleValue();
        if (this.updateState(val)) {
            return new ToolEvent(context.getEvent().getSource(), context.getEvent().getTimeStamp(), this.outSlot, this.state);
        }
        return null;
    }

    protected boolean updateState(double val) {
        if (this.state == AxisState.ORIGIN && val > this.min) {
            this.state = AxisState.PRESSED;
            return true;
        }
        if (this.state == AxisState.PRESSED && val <= this.min) {
            this.state = AxisState.ORIGIN;
            return true;
        }
        return false;
    }

    public void initialize(List inputSlots, InputSlot result, Map configuration) {
        this.inAxis = (InputSlot)inputSlots.get(0);
        this.outSlot = result;
        try {
            this.min = (Double)configuration.get("threshold");
        }
        catch (NullPointerException npe) {
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }

    public void dispose() {
    }

    public String getName() {
        return "ExtractPositive";
    }

    public String toString() {
        return "Virtual Device: " + this.getName();
    }
}

