/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem.virtual;

import de.jreality.scene.tool.AxisState;
import de.jreality.scene.tool.InputSlot;
import de.jreality.toolsystem.MissingSlotException;
import de.jreality.toolsystem.ToolEvent;
import de.jreality.toolsystem.VirtualDevice;
import de.jreality.toolsystem.VirtualDeviceContext;
import java.util.List;
import java.util.Map;

public class VirtualDoubleClick
implements VirtualDevice {
    InputSlot inSlot;
    InputSlot outSlot;
    private double maxDelay = 300.0;
    private boolean releaseOnNextRelease;
    private long lastClickTime = -1L;
    private boolean init = true;

    public ToolEvent process(VirtualDeviceContext context) throws MissingSlotException {
        if (this.init) {
            this.init = false;
            return new ToolEvent(context.getEvent().getSource(), context.getEvent().getTimeStamp(), this.outSlot, AxisState.ORIGIN);
        }
        if (this.releaseOnNextRelease) {
            assert (context.getAxisState(this.inSlot).isReleased());
            this.lastClickTime = -1L;
            this.releaseOnNextRelease = false;
            return new ToolEvent(context.getEvent().getSource(), context.getEvent().getTimeStamp(), this.outSlot, AxisState.ORIGIN);
        }
        if (context.getAxisState(this.inSlot).isReleased()) {
            return null;
        }
        if (this.lastClickTime == -1L || (double)(context.getEvent().getTimeStamp() - this.lastClickTime) > this.maxDelay) {
            this.lastClickTime = context.getEvent().getTimeStamp();
            return null;
        }
        this.releaseOnNextRelease = true;
        return new ToolEvent(context.getEvent().getSource(), context.getEvent().getTimeStamp(), this.outSlot, AxisState.PRESSED);
    }

    public void initialize(List inputSlots, InputSlot result, Map configuration) {
        this.inSlot = (InputSlot)inputSlots.get(0);
        this.outSlot = result;
        try {
            this.maxDelay = (Double)configuration.get("maxDelay");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void dispose() {
    }

    public String getName() {
        return "DoubleClick";
    }
}

