/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem.raw;

import de.jreality.math.Matrix;
import de.jreality.scene.Viewer;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.tool.AxisState;
import de.jreality.scene.tool.InputSlot;
import de.jreality.toolsystem.ToolEvent;
import de.jreality.toolsystem.ToolEventQueue;
import de.jreality.toolsystem.raw.RawDevice;
import de.jreality.toolsystem.util.OSCPool;
import de.sciss.net.OSCListener;
import de.sciss.net.OSCMessage;
import de.sciss.net.OSCServer;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WiiMoteOSC
implements RawDevice,
OSCListener {
    private static final String BATTERY = "/wii/batterylevel";
    private static final String ORIENTATION = "/wii/orientation";
    private static final String POINTER = "pointer";
    private static final String EVOLUTION = "evolution";
    private static final double THRESHOLD = 0.001;
    private OSCServer osc;
    private Map<String, InputSlot> buttonSlots = new HashMap<String, InputSlot>();
    private InputSlot pointerSlot = null;
    private InputSlot evolutionSlot = null;
    private ToolEventQueue queue = null;
    private Matrix pointerMatrix = new Matrix();
    private Matrix evolutionMatrix = new Matrix();
    private DoubleArray pointerArray = new DoubleArray(this.pointerMatrix.getArray());
    private DoubleArray evolutionArray = new DoubleArray(this.evolutionMatrix.getArray());
    private float x;
    private float y;
    private float z;
    private static final float RAD2DEG = 57.295776f;
    private Map<String, Integer> buttonStates = new HashMap<String, Integer>();
    private double x0 = 0.0;
    private double y0 = 0.0;

    @Override
    public void dispose() {
        this.osc.removeOSCListener((OSCListener)this);
        this.osc = null;
    }

    @Override
    public String getName() {
        return "WiiMoteOSC";
    }

    @Override
    public void initialize(Viewer viewer, Map<String, Object> config) {
        try {
            Object co;
            int port = 5600;
            if (config.containsKey("port") && (co = config.get("port")) instanceof Integer) {
                port = (Integer)co;
            }
            this.osc = OSCPool.getUDPServer(port);
            this.osc.addOSCListener((OSCListener)this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public ToolEvent mapRawDevice(String rawDeviceName, InputSlot inputDevice) {
        if (EVOLUTION.equals(rawDeviceName)) {
            this.evolutionSlot = inputDevice;
            Matrix m0 = new Matrix();
            m0.setEntry(2, 3, -1.0);
            return new ToolEvent((Object)this, System.currentTimeMillis(), inputDevice, new DoubleArray(m0.getArray()));
        }
        if (POINTER.equals(rawDeviceName)) {
            this.pointerSlot = inputDevice;
            return new ToolEvent((Object)this, System.currentTimeMillis(), inputDevice, new DoubleArray(new Matrix().getArray()));
        }
        this.buttonSlots.put(rawDeviceName, inputDevice);
        return new ToolEvent((Object)this, System.currentTimeMillis(), inputDevice, AxisState.ORIGIN);
    }

    @Override
    public void setEventQueue(ToolEventQueue queue) {
        this.queue = queue;
    }

    public void messageReceived(OSCMessage msg, SocketAddress sender, long time) {
        if (this.queue == null) {
            return;
        }
        String name = msg.getName();
        if (!name.startsWith("/wii/")) {
            return;
        }
        if (ORIENTATION.equals(name)) {
            if (this.pointerSlot != null || this.evolutionSlot != null) {
                Object arg = msg.getArg(0);
                float roll = arg instanceof Float ? ((Float)arg).floatValue() : (float)((Integer)arg).intValue();
                arg = msg.getArg(1);
                float pitch = arg instanceof Float ? ((Float)arg).floatValue() : (float)((Integer)arg).intValue();
                this.orientationEvent(roll, pitch);
            }
        } else if (BATTERY.equals(name)) {
            this.showBattery(((Float)msg.getArg(0)).floatValue());
        } else {
            InputSlot slot = this.buttonSlots.get(name);
            if (slot != null) {
                this.buttonEvent(slot, (Integer)msg.getArg(0));
            } else if (!name.equals("/wii/acc")) {
                this.handleLinuxEvent(msg);
            }
        }
    }

    private void handleLinuxEvent(OSCMessage msg) {
        try {
            int id = (Integer)msg.getArg(0);
            if (id != 0) {
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        String name = msg.getName();
        if (name.startsWith("/wii/keys/")) {
            String key = name.substring(10);
            Integer state = (Integer)msg.getArg(1);
            if (!state.equals(this.buttonStates.get(key))) {
                this.buttonStates.put(key, state);
                InputSlot slot = this.buttonSlots.get("/wii/button/" + key);
                if (slot != null) {
                    this.buttonEvent(slot, state);
                }
            }
        } else if (name.equals("/wii/acc/x")) {
            this.x = 10.0f * ((Float)msg.getArg(1)).floatValue() - 5.0f;
        } else if (name.equals("/wii/acc/y")) {
            this.y = 10.0f * ((Float)msg.getArg(1)).floatValue() - 5.0f;
        } else if (name.equals("/wii/acc/z")) {
            this.z = 10.0f * ((Float)msg.getArg(1)).floatValue() - 5.0f;
            float pitch = (float)Math.atan2(this.y, this.z) * 57.295776f;
            float roll = (float)Math.atan2(this.x, this.z) * 57.295776f;
            this.orientationEvent(roll, pitch);
        } else if (name.equals("/wii/battery")) {
            this.showBattery(((Float)msg.getArg(1)).floatValue());
        }
    }

    private void showBattery(float level) {
        System.err.println("WiiMote battery level: " + level);
    }

    private void buttonEvent(InputSlot slot, int status) {
        ToolEvent ev = new ToolEvent((Object)this, System.currentTimeMillis(), slot, status == 0 ? AxisState.ORIGIN : AxisState.PRESSED);
        this.queue.addEvent(ev);
    }

    private void orientationEvent(float roll, float pitch) {
        this.x0 += ((double)(roll / 75.0f) - this.x0) * 0.08;
        this.y0 += ((double)(-pitch / 75.0f) - this.y0) * 0.08;
        double d = this.x0 < -1.0 ? -1.0 : (this.x0 = this.x0 > 1.0 ? 1.0 : this.x0);
        double d2 = this.y0 < -1.0 ? -1.0 : (this.y0 = this.y0 > 1.0 ? 1.0 : this.y0);
        if (this.evolutionSlot != null) {
            this.evolutionEvent(this.x0, this.y0);
        }
        if (this.pointerSlot != null) {
            this.matrixEvent(this.x0, this.y0);
        }
    }

    private void matrixEvent(double x, double y) {
        this.pointerMatrix.setEntry(0, 3, x);
        this.pointerMatrix.setEntry(1, 3, y);
        this.pointerMatrix.setEntry(2, 3, -1.0);
        this.queue.addEvent(new ToolEvent(this, System.currentTimeMillis(), this.pointerSlot, this.pointerArray){

            protected boolean compareTransformation(DoubleArray trafo1, DoubleArray trafo2) {
                return true;
            }
        });
    }

    private void evolutionEvent(double x, double y) {
        double dx = Math.pow(x, 3.0) * 0.1;
        double dy = Math.pow(y, 3.0) * 0.1;
        if (Math.abs(dx) < 0.001 && Math.abs(dy) < 0.001) {
            return;
        }
        this.evolutionMatrix.setEntry(0, 3, dx);
        this.evolutionMatrix.setEntry(1, 3, dy);
        this.evolutionMatrix.setEntry(2, 3, -1.0);
        ToolEvent evolutionEvent = new ToolEvent(this, System.currentTimeMillis(), this.evolutionSlot, this.evolutionArray){

            protected boolean compareTransformation(DoubleArray trafo1, DoubleArray trafo2) {
                return true;
            }

            protected void replaceWith(ToolEvent replacement) {
                Matrix m = new Matrix(replacement.getTransformation());
                m.multiplyOnRight(this.getTransformation().toDoubleArray(null));
                this.trafo = new DoubleArray(m.getArray());
                this.time = replacement.getTimeStamp();
            }
        };
        this.queue.addEvent(evolutionEvent);
    }
}

