/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem.raw;

import de.jreality.jogl.ViewerSwt;
import de.jreality.math.Matrix;
import de.jreality.scene.Viewer;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.tool.AxisState;
import de.jreality.scene.tool.InputSlot;
import de.jreality.toolsystem.ToolEvent;
import de.jreality.toolsystem.ToolEventQueue;
import de.jreality.toolsystem.raw.AbstractDeviceMouse;
import de.jreality.toolsystem.raw.RawDevice;
import java.util.Map;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceMouseSWT
extends AbstractDeviceMouse
implements RawDevice,
MouseListener,
MouseMoveListener,
MouseWheelListener,
Listener {
    private Canvas component;

    public void mouseDown(MouseEvent e) {
        InputSlot button = this.findButton(e);
        ToolEvent toolEvent = new ToolEvent((Object)this, button, AxisState.PRESSED);
        if (button != null) {
            this.queue.addEvent(toolEvent);
        }
    }

    public void mouseUp(MouseEvent e) {
        InputSlot button = this.findButton(e);
        if (button != null) {
            this.queue.addEvent(new ToolEvent((Object)this, button, AxisState.ORIGIN));
        }
    }

    public void mouseMove(MouseEvent e) {
        this.mouseMoved(e.x, e.y);
    }

    public void mouseScrolled(MouseEvent e) {
        int direction;
        int n = direction = e.count > 0 ? 1 : -1;
        if (direction > 0) {
            InputSlot slot = (InputSlot)this.usedSources.get("wheel_down");
            if (slot == null) {
                return;
            }
            for (int i = 0; i < e.count; ++i) {
                this.queue.addEvent(new ToolEvent((Object)this, System.currentTimeMillis(), slot, AxisState.PRESSED));
                this.queue.addEvent(new ToolEvent((Object)this, System.currentTimeMillis(), slot, AxisState.ORIGIN));
            }
        } else {
            InputSlot slot = (InputSlot)this.usedSources.get("wheel_up");
            if (slot == null) {
                return;
            }
            for (int i = 0; i < Math.abs(e.count); ++i) {
                this.queue.addEvent(new ToolEvent((Object)this, System.currentTimeMillis(), slot, AxisState.PRESSED));
                this.queue.addEvent(new ToolEvent((Object)this, System.currentTimeMillis(), slot, AxisState.ORIGIN));
            }
        }
    }

    private InputSlot findButton(MouseEvent e) {
        if (e.button == 1) {
            return (InputSlot)this.usedSources.get("left");
        }
        if (e.button == 3) {
            return (InputSlot)this.usedSources.get("right");
        }
        if (e.button == 2) {
            return (InputSlot)this.usedSources.get("center");
        }
        return null;
    }

    public void setComponent(final Canvas component) {
        this.component = component;
        Runnable r = new Runnable(){

            public void run() {
                component.addMouseListener((MouseListener)DeviceMouseSWT.this);
                component.addMouseMoveListener((MouseMoveListener)DeviceMouseSWT.this);
                component.addMouseWheelListener((MouseWheelListener)DeviceMouseSWT.this);
            }
        };
        component.getDisplay().asyncExec(r);
    }

    @Override
    public ToolEvent mapRawDevice(String rawDeviceName, InputSlot inputDevice) {
        if (!knownSources.contains(rawDeviceName)) {
            throw new IllegalArgumentException("no such raw device");
        }
        this.usedSources.put(rawDeviceName, inputDevice);
        if (rawDeviceName.equals("axes")) {
            return new ToolEvent((Object)this, inputDevice, new DoubleArray(new Matrix().getArray()));
        }
        return new ToolEvent((Object)this, inputDevice, AxisState.ORIGIN);
    }

    @Override
    public void setEventQueue(ToolEventQueue queue) {
        this.queue = queue;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void initialize(Viewer viewer, Map<String, Object> config) {
        if (!(viewer instanceof ViewerSwt)) {
            throw new RuntimeException("only for SWT viewer!");
        }
        this.setComponent((Canvas)((ViewerSwt)viewer).getGLCanvas());
    }

    @Override
    public String getName() {
        return "Mouse";
    }

    public String toString() {
        return "RawDevice: Mouse SWT";
    }

    public void mouseDoubleClick(MouseEvent arg0) {
    }

    public void handleEvent(Event arg0) {
        System.out.println(arg0);
    }

    @Override
    protected void uninstallGrabs() {
    }

    @Override
    protected void installGrabs() {
    }

    @Override
    protected int getWidth() {
        return this.component.getSize().x;
    }

    @Override
    protected int getHeight() {
        return this.component.getSize().y;
    }

    @Override
    protected void calculateCenter() {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

