/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem.raw;

import de.jreality.math.Matrix;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.tool.InputSlot;
import de.jreality.toolsystem.ToolEvent;
import de.jreality.toolsystem.ToolEventQueue;
import de.jreality.util.LoggingSystem;
import java.awt.Robot;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;

public abstract class AbstractDeviceMouse {
    protected ToolEventQueue queue;
    private boolean center;
    private boolean sentCenter;
    protected static Robot robot;
    private int lastX = -1;
    private int lastY = -1;
    protected int winCenterX;
    protected int winCenterY;
    protected HashMap usedSources = new HashMap();
    protected static HashSet<String> knownSources;
    private Matrix axesMatrix = new Matrix();
    private Matrix axesEvolutionMatrix = new Matrix();
    private DoubleArray da = new DoubleArray(this.axesMatrix.getArray());
    private DoubleArray daEvolution = new DoubleArray(this.axesEvolutionMatrix.getArray());

    protected synchronized void mouseMoved(int ex, int ey) {
        InputSlot slot = (InputSlot)this.usedSources.get("axes");
        if (slot != null) {
            if (!this.isCenter()) {
                double xndc = -1.0 + 2.0 * (double)ex / (double)this.getWidth();
                double yndc = 1.0 - 2.0 * (double)ey / (double)this.getHeight();
                this.axesMatrix.setEntry(0, 3, xndc);
                this.axesMatrix.setEntry(1, 3, yndc);
                this.axesMatrix.setEntry(2, 3, -1.0);
                this.queue.addEvent(new ToolEvent(this, System.currentTimeMillis(), slot, this.da){

                    protected boolean compareTransformation(DoubleArray trafo1, DoubleArray trafo2) {
                        return true;
                    }
                });
            } else if (!this.sentCenter) {
                this.axesMatrix.setEntry(0, 3, 0.0);
                this.axesMatrix.setEntry(1, 3, 0.0);
                this.axesMatrix.setEntry(2, 3, -1.0);
                this.queue.addEvent(new ToolEvent((Object)this, System.currentTimeMillis(), slot, this.da));
                this.sentCenter = true;
                this.lastX = ex;
                this.lastY = ey;
            }
        }
        if ((slot = (InputSlot)this.usedSources.get("axesEvolution")) != null) {
            if (this.lastX == -1) {
                this.lastX = ex;
                this.lastY = ey;
                return;
            }
            int dx = ex - this.lastX;
            int dy = ey - this.lastY;
            if (dx == 0 && dy == 0) {
                return;
            }
            double dxndc = 2.0 * (double)dx / (double)this.getWidth();
            double dyndc = -(2.0 * (double)dy) / (double)this.getHeight();
            this.axesEvolutionMatrix.setEntry(0, 3, dxndc);
            this.axesEvolutionMatrix.setEntry(1, 3, dyndc);
            this.axesEvolutionMatrix.setEntry(2, 3, -1.0);
            ToolEvent evolutionEvent = new ToolEvent(this, System.currentTimeMillis(), slot, this.daEvolution){

                protected boolean compareTransformation(DoubleArray trafo1, DoubleArray trafo2) {
                    return true;
                }

                protected void replaceWith(ToolEvent replacement) {
                    Matrix m = new Matrix(replacement.getTransformation());
                    m.multiplyOnRight(this.getTransformation().toDoubleArray(null));
                    this.trafo = new DoubleArray(m.getArray());
                    this.time = replacement.getTimeStamp();
                }
            };
            this.queue.addEvent(evolutionEvent);
            if (this.isCenter()) {
                try {
                    robot.mouseMove(this.winCenterX, this.winCenterY);
                }
                catch (Exception exc) {
                    LoggingSystem.getLogger(this).log(Level.CONFIG, "cannot use robot: ", exc);
                }
            } else {
                this.lastX = ex;
                this.lastY = ey;
            }
        }
    }

    public void setEventQueue(ToolEventQueue queue) {
        this.queue = queue;
    }

    public boolean isCenter() {
        return this.center;
    }

    public synchronized void setCenter(boolean center) {
        if (this.center != center) {
            this.sentCenter = false;
        }
        this.center = center;
        if (center) {
            this.calculateCenter();
            robot.mouseMove(this.winCenterX, this.winCenterY);
            this.installGrabs();
        } else {
            this.uninstallGrabs();
        }
    }

    protected abstract void calculateCenter();

    protected abstract void uninstallGrabs();

    protected abstract void installGrabs();

    protected abstract int getWidth();

    protected abstract int getHeight();

    static {
        knownSources = new HashSet();
        try {
            robot = new Robot();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        knownSources.add("left");
        knownSources.add("center");
        knownSources.add("right");
        knownSources.add("axes");
        knownSources.add("axesEvolution");
        knownSources.add("wheel_up");
        knownSources.add("wheel_down");
    }
}

