/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.tools;

import de.jreality.tools.AnimatorTask;
import de.jreality.tools.AnimatorTool;
import de.jreality.tools.Timer;

class TimerQueue
implements AnimatorTask {
    Timer headTimer;
    long currentTime;
    double nextRun = -1.0;

    public TimerQueue(AnimatorTool at) {
        at.schedule(this, this);
    }

    synchronized void addTimer(Timer timer, long expTime) {
        if (timer.isRunning()) {
            return;
        }
        Timer prev = null;
        Timer next = this.headTimer;
        while (next != null && next.expireTime <= expTime) {
            prev = next;
            next = next.next;
        }
        if (prev == null) {
            this.headTimer = timer;
        } else {
            prev.next = timer;
        }
        timer.expireTime = expTime;
        timer.next = next;
        timer.running = true;
    }

    synchronized void removeTimer(Timer timer) {
        if (!timer.running) {
            return;
        }
        Timer previousTimer = null;
        Timer nextTimer = this.headTimer;
        boolean found = false;
        while (nextTimer != null) {
            if (nextTimer == timer) {
                found = true;
                break;
            }
            previousTimer = nextTimer;
            nextTimer = nextTimer.next;
        }
        if (!found) {
            return;
        }
        if (previousTimer == null) {
            this.headTimer = timer.next;
        } else {
            previousTimer.next = timer.next;
        }
        timer.expireTime = 0L;
        timer.next = null;
        timer.running = false;
    }

    synchronized boolean containsTimer(Timer timer) {
        return timer.running;
    }

    synchronized long processCurrentTimers() {
        long timeToWait;
        Timer myFirstTimer = null;
        do {
            Timer timer;
            if ((timer = this.headTimer) == null) {
                return 0L;
            }
            if (myFirstTimer == null) {
                myFirstTimer = timer;
            } else if (myFirstTimer == timer) {
                return timer.expireTime - this.currentTime;
            }
            timeToWait = timer.expireTime - this.currentTime;
            if (timeToWait > 0L) continue;
            timer.perform(this.currentTime);
            this.removeTimer(timer);
            if (!timer.isRepeats()) continue;
            this.addTimer(timer, this.currentTime + (long)timer.getDelay());
        } while (timeToWait <= 0L);
        return timeToWait;
    }

    public boolean run(double time, double dt) {
        if (this.nextRun != -1.0 && time < this.nextRun) {
            return true;
        }
        this.currentTime = (long)time;
        long timeToWait = this.processCurrentTimers();
        this.nextRun = time + (double)timeToWait;
        return true;
    }

    public void addTimer(Timer timer) {
        this.addTimer(timer, this.currentTime + (long)timer.getInitialDelay());
    }
}

