/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.tools;

import de.jreality.geometry.BoundingBoxUtility;
import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.math.Rn;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Transformation;
import de.jreality.scene.pick.PickResult;
import de.jreality.scene.tool.ToolContext;
import de.jreality.tools.DragEventTool;
import de.jreality.tools.FaceDragEvent;
import de.jreality.tools.FaceDragListener;
import de.jreality.tools.LineDragEvent;
import de.jreality.tools.LineDragListener;
import de.jreality.tools.PointDragEvent;
import de.jreality.tools.PointDragListener;
import de.jreality.tools.PrimitiveDragEvent;
import de.jreality.tools.PrimitiveDragListener;

public class ScaleTool
extends DragEventTool {
    double[] translation;
    boolean active;
    double[] pickPoint;
    double[] objCenter;
    SceneGraphComponent pickedSGC;
    Transformation oldSGCTrafo;

    public ScaleTool(String activationSlotName) {
        super(activationSlotName);
        this.addPrimitiveDragListener(new PrimitiveDragListener(){

            public void primitiveDragEnd(PrimitiveDragEvent e) {
            }

            public void primitiveDragStart(PrimitiveDragEvent e) {
            }

            public void primitiveDragged(PrimitiveDragEvent e) {
                ScaleTool.this.translation = Rn.subtract(null, e.getPosition(), ScaleTool.this.pickPoint);
            }
        });
        this.addPointDragListener(new PointDragListener(){

            public void pointDragStart(PointDragEvent e) {
            }

            public void pointDragged(PointDragEvent e) {
                ScaleTool.this.translation = Rn.subtract(null, e.getPosition(), ScaleTool.this.pickPoint);
            }

            public void pointDragEnd(PointDragEvent e) {
            }
        });
        this.addLineDragListener(new LineDragListener(){

            public void lineDragStart(LineDragEvent e) {
            }

            public void lineDragged(LineDragEvent e) {
                ScaleTool.this.translation = e.getTranslation();
            }

            public void lineDragEnd(LineDragEvent e) {
            }
        });
        this.addFaceDragListener(new FaceDragListener(){

            public void faceDragStart(FaceDragEvent e) {
            }

            public void faceDragged(FaceDragEvent e) {
                ScaleTool.this.translation = e.getTranslation();
            }

            public void faceDragEnd(FaceDragEvent e) {
            }
        });
    }

    public ScaleTool() {
        this("ScaleActivation");
    }

    public void activate(ToolContext tc) {
        this.active = true;
        PickResult currentPick = tc.getCurrentPick();
        this.pickPoint = currentPick.getObjectCoordinates();
        super.activate(tc);
        this.pickedSGC = tc.getRootToLocal().getLastComponent();
        if (this.pickedSGC.getTransformation() == null) {
            this.pickedSGC.setTransformation(new Transformation());
        }
        this.oldSGCTrafo = this.pickedSGC.getTransformation();
        this.objCenter = BoundingBoxUtility.calculateBoundingBox(this.pickedSGC).getCenter();
        Matrix mtx = new Matrix(this.oldSGCTrafo);
        mtx.invert();
        this.objCenter = mtx.multiplyVector(this.objCenter);
    }

    public void perform(ToolContext tc) {
        if (!this.active) {
            return;
        }
        super.perform(tc);
        double factor = Rn.euclideanNorm(Rn.subtract(null, Rn.add(null, this.pickPoint, this.translation), this.objCenter)) / Rn.euclideanNorm(Rn.subtract(null, this.pickPoint, this.objCenter));
        MatrixBuilder.euclidean(this.oldSGCTrafo).translate(this.objCenter).scale(factor).translate(Rn.times(null, -1.0, this.objCenter)).assignTo(this.pickedSGC);
    }

    public void deactivate(ToolContext tc) {
        super.deactivate(tc);
        this.active = false;
    }
}

