/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.tools;

import de.jreality.math.FactoredMatrix;
import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.tool.AbstractTool;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.ToolContext;

public class HeadTransformationTool
extends AbstractTool {
    private transient InputSlot rotateActivation = InputSlot.getDevice("ShipRotateActivation");
    private final transient InputSlot verticalRotation = InputSlot.getDevice("VerticalHeadRotationAngleEvolution");
    private double maxAngle = 1.0995574287564276;
    private double minAngle = -1.0995574287564276;
    private boolean invert;
    private transient double[] headTranslation;
    private transient double currentAngle;
    private transient boolean rotate;
    private final transient Matrix m = new Matrix();

    public HeadTransformationTool() {
        super(new InputSlot[0]);
        this.addCurrentSlot(this.verticalRotation);
        this.addCurrentSlot(this.rotateActivation);
    }

    public void perform(ToolContext tc) {
        if (this.rotate) {
            if (!tc.getAxisState(this.rotateActivation).isPressed()) {
                this.removeCurrentSlot(this.verticalRotation);
                this.rotate = false;
            }
        } else {
            if (tc.getAxisState(this.rotateActivation).isPressed()) {
                this.addCurrentSlot(this.verticalRotation);
                this.rotate = true;
            }
            if (tc.getSource() == this.rotateActivation || !this.rotate) {
                return;
            }
        }
        double deltaAngle = tc.getAxisState(this.verticalRotation).doubleValue();
        if (tc.getRootToToolComponent().getLastComponent().getTransformation() != null) {
            tc.getRootToToolComponent().getLastComponent().getTransformation().getMatrix(this.m.getArray());
            if (this.headTranslation == null) {
                FactoredMatrix fm = new FactoredMatrix(this.m.getArray());
                this.currentAngle = fm.getRotationAngle();
                if (this.currentAngle > Math.PI) {
                    this.currentAngle -= Math.PI * 2;
                }
            }
            this.headTranslation = this.m.getColumn(3);
        } else {
            this.headTranslation = new double[]{0.0, 1.7, 0.0};
        }
        double dAngle = (double)(this.invert ? -1 : 1) * deltaAngle;
        if (this.currentAngle + dAngle > this.maxAngle || this.currentAngle + dAngle < this.minAngle) {
            return;
        }
        this.currentAngle += dAngle;
        SceneGraphComponent myComponent = tc.getRootToToolComponent().getLastComponent();
        MatrixBuilder.euclidean().translate(this.headTranslation).rotateX(this.currentAngle).assignTo(myComponent);
    }

    public double getMaxAngle() {
        return this.maxAngle;
    }

    public void setMaxAngle(double maxAngle) {
        this.maxAngle = maxAngle;
    }

    public double getMinAngle() {
        return this.minAngle;
    }

    public void setMinAngle(double minAngle) {
        this.minAngle = minAngle;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public void setInvert(boolean invert) {
        this.invert = invert;
    }

    public void currentAngle(double ang) {
        this.currentAngle = ang;
    }
}

