/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.tools;

import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.data.Attribute;
import java.util.EventObject;

public class FaceDragEvent
extends EventObject {
    private static final long serialVersionUID = 19823L;
    private final int index;
    private final double[] translation;
    private final double[] position;
    private final IndexedFaceSet faceSet;
    private int[] faceIndices;
    private double[][] faceVertices;

    public FaceDragEvent(IndexedFaceSet faceSet, int index, double[] translation, double[] position) {
        super(faceSet);
        this.faceSet = faceSet;
        this.index = index;
        this.translation = (double[])translation.clone();
        this.position = (double[])position.clone();
        this.faceIndices = faceSet.getFaceAttributes(Attribute.INDICES).toIntArrayArray().getValueAt(index).toIntArray(null);
        this.faceVertices = new double[this.faceIndices.length][];
        for (int i = 0; i < this.faceIndices.length; ++i) {
            this.faceVertices[i] = faceSet.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray().getValueAt(this.faceIndices[i]).toDoubleArray(null);
        }
    }

    public double getX() {
        return this.translation[0];
    }

    public double getY() {
        return this.translation[1];
    }

    public double getZ() {
        return this.translation[2];
    }

    public double[] getTranslation() {
        return (double[])this.translation.clone();
    }

    public double[] getPosition() {
        return (double[])this.position.clone();
    }

    public int getIndex() {
        return this.index;
    }

    public int[] getFaceIndices() {
        return this.faceIndices;
    }

    public double[][] getFaceVertices() {
        return this.faceVertices;
    }

    public IndexedFaceSet getIndexedFaceSet() {
        return this.faceSet;
    }
}

