/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.tools;

import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.math.P3;
import de.jreality.math.Rn;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Transformation;
import de.jreality.scene.tool.AbstractTool;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.ToolContext;
import de.jreality.shader.EffectiveAppearance;

public class DraggingTool
extends AbstractTool {
    private boolean moveChildren;
    protected transient boolean dragInViewDirection;
    static InputSlot activationSlot = InputSlot.getDevice("DragActivation");
    static InputSlot alongPointerSlot = InputSlot.getDevice("DragAlongViewDirection");
    static InputSlot evolutionSlot = InputSlot.getDevice("PointerEvolution");
    protected transient SceneGraphComponent comp;
    transient EffectiveAppearance eap;
    private transient int metric;
    transient Matrix result = new Matrix();
    transient Matrix local2world = new Matrix();
    transient Matrix dragFrame;
    transient Matrix pointer = new Matrix();

    public DraggingTool() {
        super(activationSlot);
        this.addCurrentSlot(evolutionSlot);
        this.addCurrentSlot(alongPointerSlot);
    }

    public void activate(ToolContext tc) {
        this.comp = (this.moveChildren ? tc.getRootToLocal() : tc.getRootToToolComponent()).getLastComponent();
        if (this.comp.getTransformation() == null) {
            this.comp.setTransformation(new Transformation());
        }
        try {
            this.dragInViewDirection = tc.getAxisState(alongPointerSlot).isPressed();
        }
        catch (Exception me) {
            this.dragInViewDirection = false;
        }
        if (this.eap == null || !EffectiveAppearance.matches(this.eap, tc.getRootToToolComponent())) {
            this.eap = EffectiveAppearance.create(tc.getRootToToolComponent());
        }
        this.metric = this.eap.getAttribute("metric", 0);
    }

    public void perform(ToolContext tc) {
        if (tc.getSource() == alongPointerSlot) {
            this.dragInViewDirection = tc.getAxisState(alongPointerSlot).isPressed();
            return;
        }
        Matrix evolution = new Matrix(tc.getTransformationMatrix(evolutionSlot));
        if (this.metric != 0) {
            MatrixBuilder.init(null, this.metric).translate(evolution.getColumn(3)).assignTo(evolution);
        }
        (this.moveChildren ? tc.getRootToLocal() : tc.getRootToToolComponent()).getMatrix(this.local2world.getArray());
        if (Rn.isNan(this.local2world.getArray())) {
            return;
        }
        this.comp.getTransformation().getMatrix(this.result.getArray());
        if (this.dragInViewDirection) {
            tc.getTransformationMatrix(InputSlot.getDevice("CameraToWorld")).toDoubleArray(this.pointer.getArray());
            double dz = evolution.getEntry(0, 3) + evolution.getEntry(1, 3);
            double[] tlate = Rn.times(null, dz, this.pointer.getColumn(2));
            if (this.metric == 0) {
                tlate[3] = 1.0;
            }
            MatrixBuilder.init(null, this.metric).translate(tlate).assignTo(evolution);
        }
        evolution.conjugateBy(this.local2world.getInverse());
        if (this.metric != 0) {
            P3.orthonormalizeMatrix(evolution.getArray(), evolution.getArray(), 1.0E-7, this.metric);
        }
        this.result.multiplyOnRight(evolution);
        if (Rn.isNan(this.result.getArray())) {
            return;
        }
        this.comp.getTransformation().setMatrix(this.result.getArray());
    }

    public boolean getMoveChildren() {
        return this.moveChildren;
    }

    public void setMoveChildren(boolean moveChildren) {
        this.moveChildren = moveChildren;
    }
}

