/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.tools;

import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.math.Rn;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Transformation;
import de.jreality.scene.tool.AbstractTool;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.ToolContext;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.tools.AnimatorTask;
import de.jreality.tools.AnimatorTool;

public class DampedDraggingTool
extends AbstractTool {
    private boolean moveChildren;
    private boolean damped = true;
    private double linearScaleFactor = 500.0;
    private double featherPow = 2.0;
    private transient boolean dragInViewDirection;
    protected transient SceneGraphComponent comp;
    private transient EffectiveAppearance eap;
    private transient int metric;
    private transient Matrix result = new Matrix();
    private transient Matrix local2world = new Matrix();
    private transient Matrix pointer = new Matrix();
    protected transient SceneGraphPath path;
    private double[] lostAxis = new double[]{0.0, 0.0, 1.0};
    private double lostAngle = 0.0;
    private Matrix newEvolution = new Matrix();
    private long timeStamp = 0L;
    private double[] m3;
    static InputSlot activationSlot = InputSlot.getDevice("DragActivation");
    static InputSlot alongPointerSlot = InputSlot.getDevice("DragAlongViewDirection");
    static InputSlot evolutionSlot = InputSlot.getDevice("PointerEvolution");
    static InputSlot timerSlot = InputSlot.getDevice("SystemTime");

    public DampedDraggingTool() {
        super(activationSlot);
        this.addCurrentSlot(evolutionSlot);
        this.addCurrentSlot(alongPointerSlot);
        this.addCurrentSlot(timerSlot);
    }

    public void activate(ToolContext tc) {
        this.path = this.moveChildren ? tc.getRootToLocal() : tc.getRootToToolComponent();
        this.comp = this.path.getLastComponent();
        AnimatorTool.getInstance(tc).deschedule(this.comp);
        if (this.comp.getTransformation() == null) {
            this.comp.setTransformation(new Transformation());
        }
        try {
            this.dragInViewDirection = tc.getAxisState(alongPointerSlot).isPressed();
        }
        catch (Exception me) {
            this.dragInViewDirection = false;
        }
        if (this.eap == null || !EffectiveAppearance.matches(this.eap, tc.getRootToToolComponent())) {
            this.eap = EffectiveAppearance.create(tc.getRootToToolComponent());
        }
        this.metric = this.eap.getAttribute("metric", 0);
    }

    public void perform(ToolContext tc) {
        if (tc.getSource() == alongPointerSlot) {
            this.dragInViewDirection = tc.getAxisState(alongPointerSlot).isPressed();
            return;
        }
        Matrix evolution = new Matrix(tc.getTransformationMatrix(evolutionSlot));
        if (this.metric != 0) {
            MatrixBuilder.init(null, this.metric).translate(evolution.getColumn(3)).assignTo(evolution);
        }
        if (this.dragInViewDirection && tc.getSource() != timerSlot) {
            tc.getTransformationMatrix(InputSlot.getDevice("CameraToWorld")).toDoubleArray(this.pointer.getArray());
            double dz = evolution.getEntry(0, 3) + evolution.getEntry(1, 3);
            double[] tlate = Rn.times(null, dz, this.pointer.getColumn(2));
            if (this.metric == 0) {
                tlate[3] = 1.0;
            }
            MatrixBuilder.init(null, this.metric).translate(tlate).assignTo(evolution);
        }
        (this.moveChildren ? tc.getRootToLocal() : tc.getRootToToolComponent()).getMatrix(this.local2world.getArray());
        evolution.conjugateBy(this.local2world.getInverse());
        this.comp.getTransformation().getMatrix(this.result.getArray());
        if (this.damped && (!this.dragInViewDirection || tc.getSource() == timerSlot)) {
            if (tc.getSource() == activationSlot) {
                this.timeStamp = tc.getTime();
            }
            double dt = tc.getTime() - this.timeStamp;
            this.timeStamp = (long)((double)this.timeStamp + dt);
            SceneGraphPath toCamPath = tc.getViewer().getCameraPath().popNew();
            double[] m1 = this.path.getInverseMatrix(null);
            double[] m2 = toCamPath.getMatrix(null);
            double[] m1i = this.path.getMatrix(null);
            double[] m2i = toCamPath.getInverseMatrix(null);
            this.m3 = Rn.times(null, m1, m2);
            double[] m3i = Rn.times(null, m2i, m1i);
            if (tc.getSource() == timerSlot) {
                this.recalcAngleAndAxis2(dt, MatrixBuilder.euclidean().getMatrix());
            }
            if (tc.getSource() == evolutionSlot) {
                double[] camEvolution = Rn.conjugateByMatrix(null, evolution.getArray(), m3i);
                this.recalcAngleAndAxis2(dt, new Matrix(camEvolution));
            }
            evolution = new Matrix(Rn.conjugateByMatrix(null, this.newEvolution.getArray(), this.m3));
        }
        if (this.damped || tc.getSource() != timerSlot) {
            this.result.multiplyOnRight(evolution);
        }
        this.comp.getTransformation().setMatrix(this.result.getArray());
    }

    public void deactivate(ToolContext tc) {
        (this.moveChildren ? tc.getRootToLocal() : tc.getRootToToolComponent()).getMatrix(this.local2world.getArray());
        this.comp.getTransformation().getMatrix(this.result.getArray());
        SceneGraphPath toCamPath = tc.getViewer().getCameraPath().popNew();
        double[] m1 = this.path.getInverseMatrix(null);
        double[] m2 = toCamPath.getMatrix(null);
        this.m3 = Rn.times(null, m1, m2);
        AnimatorTask task = new AnimatorTask(){

            public boolean run(double time, double dt) {
                DampedDraggingTool.this.timeStamp = (long)((double)DampedDraggingTool.this.timeStamp + dt);
                boolean unFinished = DampedDraggingTool.this.recalcAngleAndAxis2(dt, MatrixBuilder.euclidean().getMatrix());
                DampedDraggingTool.this.newEvolution = new Matrix(Rn.conjugateByMatrix(null, DampedDraggingTool.this.newEvolution.getArray(), DampedDraggingTool.this.m3));
                DampedDraggingTool.this.result.multiplyOnRight(DampedDraggingTool.this.newEvolution);
                DampedDraggingTool.this.comp.getTransformation().setMatrix(DampedDraggingTool.this.result.getArray());
                return unFinished;
            }
        };
        AnimatorTool.getInstance(tc).schedule(this.comp, task);
    }

    public void setMoveChildren(boolean moveChildren) {
        this.moveChildren = moveChildren;
    }

    public boolean isMoveChildren() {
        return this.moveChildren;
    }

    public void setFeathered(boolean feathered) {
        this.damped = feathered;
    }

    public boolean isFeathered() {
        return this.damped;
    }

    public void setLinearScaleFactor(double linearScaleFactor) {
        this.linearScaleFactor = linearScaleFactor > 0.0 ? linearScaleFactor * 1000.0 : 1000.0;
    }

    public double getLinearScaleFactor() {
        return this.linearScaleFactor / 1000.0;
    }

    public void setFeatherPow(double featherPow) {
        this.featherPow = featherPow >= 1.0 ? featherPow : 1.0;
    }

    public double getFeatherPow() {
        return this.featherPow;
    }

    public String getDescription() {
        return "featheres the movement";
    }

    protected void setDescription(InputSlot slot, String description) {
    }

    private double goodAngle(double angle) {
        while (angle > Math.PI) {
            angle -= Math.PI * 2;
        }
        while (angle < -Math.PI) {
            angle += Math.PI * 2;
        }
        return angle;
    }

    private double[] normalizedR3(double[] x) {
        return Rn.normalize(null, new double[]{x[0], x[1], x[2]});
    }

    private double[] getRotAxisFromTo(double[] x, double[] y) {
        if (x.length != 3 || y.length != 3) {
            return null;
        }
        double[] result = new double[]{x[1] * y[2] - x[2] * y[1], -(x[0] * y[2] - x[2] * y[0]), x[0] * y[1] - x[1] * y[0]};
        Rn.normalize(result, result);
        return result;
    }

    private double allowedAngle(double angle, double dt) {
        double tMinus = Math.pow(angle, 1.0 / this.featherPow);
        double destTMinus = Math.max(tMinus - dt / this.linearScaleFactor, 0.0);
        double restAngle = Math.pow(destTMinus, this.featherPow);
        return angle - restAngle;
    }

    private boolean hasFinished(double angle, double dt) {
        double tMinus = Math.pow(angle, 1.0 / this.featherPow);
        return tMinus <= 0.0;
    }

    private boolean recalcAngleAndAxis2(double dt, Matrix evolution) {
        double[] viewDir = new double[]{0.0, 0.0, -1.0, 0.0};
        double[] lostEvolution = MatrixBuilder.euclidean().rotate(this.lostAngle, this.lostAxis).getArray();
        double[] totalEvolution = Rn.times(null, evolution.getArray(), lostEvolution);
        double[] destdir = Rn.matrixTimesVector(null, totalEvolution, viewDir);
        viewDir = this.normalizedR3(viewDir);
        destdir = this.normalizedR3(destdir);
        double totalAngle = this.goodAngle(Rn.euclideanAngle(viewDir, destdir));
        double[] totalAxis = this.getRotAxisFromTo(viewDir, destdir);
        double possAngle = this.allowedAngle(totalAngle, dt);
        double[] possibleEvolution = MatrixBuilder.euclidean().rotate(possAngle, totalAxis).getArray();
        this.lostAngle = totalAngle - possAngle;
        this.lostAxis = totalAxis;
        this.newEvolution = new Matrix(possibleEvolution);
        return !this.hasFinished(totalAngle, dt);
    }
}

