/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.tools;

import de.jreality.scene.tool.AbstractTool;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.ToolContext;
import de.jreality.tools.AnimatorTask;
import de.jreality.tools.TimerQueue;
import de.jreality.toolsystem.ToolSystem;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;

public class AnimatorTool
extends AbstractTool {
    private static InputSlot timer = InputSlot.getDevice("SystemTime");
    private static HashMap<Object, AnimatorTool> instances = new HashMap();
    private TimerQueue timerQueue;
    private IdentityHashMap<Object, AnimatorTask> animators = new IdentityHashMap();
    private final Object mutex = new Object();
    private double totalTime;

    public static AnimatorTool getInstance(ToolContext context) {
        return AnimatorTool.getInstanceImpl(context.getKey());
    }

    public static AnimatorTool getInstanceImpl(Object key) {
        AnimatorTool instance = instances.get(key);
        if (instance == null) {
            instance = new AnimatorTool();
            instances.put(key, instance);
        }
        return instance;
    }

    public static void disposeInstance(Object key) {
        AnimatorTool at = instances.remove(key);
        if (at != null) {
            at.dispose();
        }
    }

    private AnimatorTool() {
        super(new InputSlot[0]);
        this.addCurrentSlot(timer, "Triggers the animator tasks.");
        this.timerQueue = new TimerQueue(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(ToolContext tc) {
        Object object = this.mutex;
        synchronized (object) {
            int dt = tc.getAxisState(timer).intValue();
            this.totalTime += (double)dt;
            Iterator<AnimatorTask> i = this.animators.values().iterator();
            while (i.hasNext()) {
                AnimatorTask task = i.next();
                if (task.run(this.totalTime, dt)) continue;
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Object key, AnimatorTask task) {
        Object object = this.mutex;
        synchronized (object) {
            this.animators.put(key, task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deschedule(Object key) {
        Object object = this.mutex;
        synchronized (object) {
            this.animators.remove(key);
        }
    }

    public TimerQueue getTimerQueue() {
        return this.timerQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.mutex;
        synchronized (object) {
            this.animators.clear();
        }
    }

    public static AnimatorTool getInstance(ToolSystem ts) {
        return AnimatorTool.getInstanceImpl(ts.getKey());
    }
}

