/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.sunflow.batchrender;

import de.jreality.sunflow.RenderOptions;
import de.jreality.sunflow.batchrender.BatchRenderer;
import de.smrj.executor.DistributedExecutorService;
import de.smrj.executor.RemoteCallable;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;

public class Master {
    int tilesX;
    int tilesY;
    BufferedImage img;
    File outFile;
    boolean[][] merged;

    public Master(String pngFile, int w, int h, int tX, int tY) throws IOException {
        this.outFile = new File(pngFile);
        this.outFile.createNewFile();
        if (this.outFile.isDirectory() || !this.outFile.canWrite()) {
            throw new IOException("illegal file: " + pngFile);
        }
        this.img = new BufferedImage(w, h, 1);
        this.tilesX = tX;
        this.tilesY = tY;
        this.merged = new boolean[tX][tY];
    }

    synchronized void tileFinished(int tx, int ty, String filename) throws IOException {
        System.out.println("writing tile: " + tx + "x" + ty);
        this.merged[tx][ty] = true;
        if (filename != null) {
            BufferedImage bi = ImageIO.read(new File(filename));
            this.img.getGraphics().drawImage(bi, tx * this.img.getWidth() / this.tilesX, this.img.getHeight() - (ty + 1) * this.img.getHeight() / this.tilesY, null);
        }
        this.checkFinished();
    }

    private void checkFinished() {
        for (int i = 0; i < this.tilesX; ++i) {
            for (int j = 0; j < this.tilesY; ++j) {
                if (this.merged[i][j]) continue;
                return;
            }
        }
        try {
            ImageIO.write((RenderedImage)this.img, "png", this.outFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    public static void main(String[] args) throws IOException {
        int width = 8000;
        int height = 8000;
        int tilesX = 40;
        int tilesY = 40;
        String base = args[0];
        RenderOptions renderOptions = new RenderOptions();
        renderOptions.setProgressiveRender(false);
        renderOptions.setAaMin(0);
        renderOptions.setAaMax(4);
        renderOptions.setDepthsRefraction(8);
        renderOptions.setDepthsReflection(4);
        String[] hosts = new String[100];
        DistributedExecutorService des = new DistributedExecutorService(hosts);
        des.broadcastStaticMethodCall(BatchRenderer.class, "setJrsFile", new Class[]{String.class}, new Object[]{base + ".jrs"});
        des.broadcastStaticMethodCall(BatchRenderer.class, "setRenderOptions", new Class[]{RenderOptions.class}, new Object[]{renderOptions});
        des.broadcastStaticMethodCall(BatchRenderer.class, "setExtension", new Class[]{String.class}, new Object[]{"png"});
        des.broadcastStaticMethodCall(BatchRenderer.class, "setImageSize", new Class[]{Integer.class, Integer.class}, new Object[]{width, height});
        des.broadcastStaticMethodCall(BatchRenderer.class, "setTiling", new Class[]{Integer.class, Integer.class}, new Object[]{tilesX, tilesY});
        final Master master = new Master(base + ".png", width, height, tilesX, tilesY);
        for (int i = 0; i < tilesX; ++i) {
            int j = 0;
            while (j < tilesX) {
                final int tX = i;
                final int tY = j++;
                final Future f = des.submit((RemoteCallable)new RemoteCallable<String>(){
                    private static final long serialVersionUID = 3713825184723907804L;

                    public String call() throws Exception {
                        return BatchRenderer.renderTile(tX, tY);
                    }
                });
                new Thread(){

                    public void run() {
                        try {
                            master.tileFinished(tX, tY, (String)f.get());
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        catch (ExecutionException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }.start();
            }
        }
    }
}

