/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.sunflow;

import de.jreality.backends.label.LabelUtility;
import de.jreality.geometry.BoundingBoxUtility;
import de.jreality.geometry.Primitives;
import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.math.Rn;
import de.jreality.scene.Appearance;
import de.jreality.scene.Camera;
import de.jreality.scene.DirectionalLight;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.PointLight;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.AttributeEntityUtility;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.data.DoubleArrayArray;
import de.jreality.scene.data.IntArray;
import de.jreality.scene.data.IntArrayArray;
import de.jreality.shader.CubeMap;
import de.jreality.shader.DefaultGeometryShader;
import de.jreality.shader.DefaultLineShader;
import de.jreality.shader.DefaultPointShader;
import de.jreality.shader.DefaultTextShader;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.ImageData;
import de.jreality.shader.RenderingHintsShader;
import de.jreality.shader.ShaderUtility;
import de.jreality.shader.Texture2D;
import de.jreality.shader.TextureUtility;
import de.jreality.sunflow.PerezSky;
import de.jreality.sunflow.RenderOptions;
import de.jreality.sunflow.core.camera.OrthogonalLens;
import de.jreality.sunflow.core.camera.TiledPinholeLens;
import de.jreality.sunflow.core.light.GlPointLight;
import de.jreality.sunflow.core.primitive.Cylinder;
import de.jreality.sunflow.core.primitive.SkyBox;
import de.jreality.sunflow.core.shader.DefaultPolygonShader;
import de.jreality.util.CameraUtility;
import de.jreality.util.Rectangle3D;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import org.sunflow.SunflowAPI;
import org.sunflow.core.CameraLens;
import org.sunflow.core.Display;
import org.sunflow.core.LightSource;
import org.sunflow.core.ParameterList;
import org.sunflow.core.PrimitiveList;
import org.sunflow.core.Shader;
import org.sunflow.core.camera.PinholeLens;
import org.sunflow.core.light.DirectionalSpotlight;
import org.sunflow.core.light.SunSkyLight;
import org.sunflow.core.primitive.Background;
import org.sunflow.core.primitive.ParticleSurface;
import org.sunflow.core.primitive.Plane;
import org.sunflow.core.primitive.Sphere;
import org.sunflow.core.primitive.TriangleMesh;
import org.sunflow.core.shader.ConstantShader;
import org.sunflow.core.shader.DiffuseShader;
import org.sunflow.core.shader.GlassShader;
import org.sunflow.core.shader.IDShader;
import org.sunflow.core.shader.NormalShader;
import org.sunflow.core.shader.PrimIDShader;
import org.sunflow.core.shader.SimpleShader;
import org.sunflow.core.shader.UVShader;
import org.sunflow.core.shader.ViewCausticsShader;
import org.sunflow.core.shader.ViewGlobalPhotonsShader;
import org.sunflow.core.shader.ViewIrradianceShader;
import org.sunflow.math.Matrix4;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;

public class SunflowRenderer
extends SunflowAPI {
    IdentityHashMap<Object, String> geom2name = new IdentityHashMap();
    HashMap<String, Object> name2geom = new HashMap();
    private static final String POINT_SPHERE = "point";
    private static final String LINE_CYLINDER = "line";
    private static final String PARTICLE_SURFACE = "particleSurface";
    private SceneGraphPath bakingPath;
    private String bakingInstance;
    private RenderOptions options = new RenderOptions();
    private boolean ignoreSunLight;
    private double[] world2Camera;

    public int[] convert(IntArrayArray faces) {
        int triCnt = 0;
        for (int i = 0; i < faces.getLength(); ++i) {
            triCnt += faces.getLengthAt(i) - 2;
        }
        int[] tris = new int[triCnt * 3];
        int ind = 0;
        for (int i = 0; i < faces.getLength(); ++i) {
            IntArray face = faces.getValueAt(i);
            for (int k = 0; k < face.getLength() - 2; ++k) {
                tris[ind++] = face.getValueAt(0);
                tris[ind++] = face.getValueAt(k + 1);
                tris[ind++] = face.getValueAt(k + 2);
            }
        }
        return tris;
    }

    public float[] convert(DoubleArrayArray array, int slotLen, Matrix matrix) {
        float[] ret = new float[array.getLength() * slotLen];
        boolean dehomogenize = array.getLengthAt(0) > slotLen;
        double[] tmp = new double[4];
        tmp[3] = 1.0;
        int ind = 0;
        for (int i = 0; i < array.getLength(); ++i) {
            int j;
            double factor = dehomogenize ? 1.0 / array.getValueAt(i, 3) : 1.0;
            for (j = 0; j < slotLen; ++j) {
                tmp[j] = array.getValueAt(i, j) * factor;
            }
            if (matrix != null) {
                tmp = matrix.multiplyVector(tmp);
            }
            for (j = 0; j < slotLen; ++j) {
                ret[ind++] = (float)tmp[j];
            }
        }
        return ret;
    }

    public void render(SceneGraphComponent sceneRoot, SceneGraphPath cameraPath, SceneGraphPath bakingPath, Display display, int width, int height) {
        this.bakingPath = bakingPath;
        this.render(sceneRoot, cameraPath, display, width, height, new int[0]);
        bakingPath = null;
    }

    public void render(SceneGraphComponent sceneRoot, SceneGraphPath cameraPath, Display display, int width, int height, int ... tiling) {
        String giEngine;
        this.shader("constantWhite", (Shader)new ConstantShader());
        this.shader("ambientOcclusion", (Shader)new DiffuseShader());
        String shaderOverride = this.options.getShaderOverride();
        ViewCausticsShader overrideShader = null;
        if ("viewCaustics".equals(shaderOverride)) {
            overrideShader = new ViewCausticsShader();
        } else if ("viewGlobalPhotons".equals(shaderOverride)) {
            overrideShader = new ViewGlobalPhotonsShader();
        } else if ("viewIrradiance".equals(shaderOverride)) {
            overrideShader = new ViewIrradianceShader();
        } else if ("uv".equals(shaderOverride)) {
            overrideShader = new UVShader();
        } else if ("id".equals(shaderOverride)) {
            overrideShader = new IDShader();
        } else if ("simple".equals(shaderOverride)) {
            overrideShader = new SimpleShader();
        } else if ("primID".equals(shaderOverride)) {
            overrideShader = new PrimIDShader();
        } else if ("normal".equals(shaderOverride)) {
            overrideShader = new NormalShader();
        }
        if (overrideShader != null) {
            this.shader("overrideShader", (Shader)overrideShader);
            this.shaderOverride("overrideShader", false);
        } else {
            Appearance rootApp = sceneRoot.getAppearance();
            Geometry rootGeom = sceneRoot.getGeometry();
            if (rootGeom instanceof PerezSky) {
                this.ignoreSunLight = true;
                PerezSky perezSky = (PerezSky)rootGeom;
                ParameterList pl = new ParameterList();
                double[] dir = perezSky.getSunDirection();
                pl.addVectors("up", ParameterList.InterpolationType.NONE, new float[]{0.0f, 1.0f, 0.0f});
                pl.addVectors("sundir", ParameterList.InterpolationType.NONE, new float[]{(float)dir[0], (float)dir[2], (float)dir[1]});
                SunSkyLight skyLight = new SunSkyLight();
                skyLight.update(pl, (SunflowAPI)this);
                skyLight.init("sunSky", (SunflowAPI)this);
            } else if (rootApp != null) {
                if (AttributeEntityUtility.hasAttributeEntity(CubeMap.class, "skyBox", rootApp)) {
                    CubeMap cm = (CubeMap)AttributeEntityUtility.createAttributeEntity(CubeMap.class, "skyBox", rootApp, true);
                    SkyBox skyBox = new SkyBox(cm);
                    this.parameter("center", new Vector3(1.0f, 0.0f, 0.0f));
                    this.parameter("up", new Vector3(0.0f, -1.0f, 0.0f));
                    skyBox.init("skyBox", this);
                } else {
                    try {
                        Color backColor = (Color)rootApp.getAttribute("backgroundColor");
                        if (backColor != null) {
                            this.parameter("color", backColor);
                            this.shader("background.shader", (Shader)new ConstantShader());
                            this.geometry("background", (PrimitiveList)new Background());
                            this.parameter("shaders", "background.shader");
                            this.instance("background.instance", "background");
                        }
                    }
                    catch (ClassCastException e) {
                        System.err.println("\nonly uniform background colors supported yet");
                    }
                }
            }
        }
        try {
            File tmpF = File.createTempFile("foo", ".png");
            this.addTextureSearchPath(tmpF.getParentFile().getAbsolutePath());
            if (!tmpF.delete()) {
                tmpF.deleteOnExit();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.geometry(POINT_SPHERE, (PrimitiveList)new Sphere());
        this.geometry(LINE_CYLINDER, new Cylinder());
        Rectangle3D sceneBounds = BoundingBoxUtility.calculateBoundingBox(sceneRoot);
        double[] c = sceneBounds.getCenter();
        Point3 sceneCenter = new Point3((float)c[0], (float)c[1], (float)c[2]);
        double[] e = sceneBounds.getExtent();
        float sceneRadius = (float)Math.sqrt(e[0] * e[0] + e[1] * e[1] + e[2] * e[2]) / 2.0f;
        new Visitor(sceneCenter, sceneRadius, cameraPath).visit(sceneRoot);
        float aspect = (float)width / (float)height;
        this.parameter("aspect", aspect);
        Camera camera = (Camera)cameraPath.getLastElement();
        Matrix m = new Matrix(cameraPath.getMatrix(null));
        this.world2Camera = cameraPath.getInverseMatrix(null);
        System.out.println("world2camera=" + this.world2Camera);
        this.parameter("transform", m);
        double fov = camera.getFieldOfView();
        if (width > height) {
            fov = Math.atan((double)width / (double)height * Math.tan(fov / 360.0 * Math.PI)) / Math.PI * 360.0;
        }
        this.parameter("fov", fov);
        if (tiling.length > 0) {
            this.parameter("tilesX", tiling[0]);
            this.parameter("tilesY", tiling[1]);
            this.parameter("tileX", tiling[2]);
            this.parameter("tileY", tiling[3]);
        }
        String name = this.getUniqueName("camera");
        this.camera(name, (CameraLens)(tiling.length == 0 ? (camera.isPerspective() ? new PinholeLens() : new OrthogonalLens()) : new TiledPinholeLens()));
        this.parameter("camera", name);
        this.parameter("sampler", this.options.isProgressiveRender() ? "ipr" : "bucket");
        if (this.bakingInstance != null) {
            this.parameter("baking.instance", this.bakingInstance);
        }
        this.parameter("resolutionX", tiling.length == 0 ? width : width / tiling[0]);
        this.parameter("resolutionY", tiling.length == 0 ? height : height / tiling[1]);
        this.parameter("threads.lowPriority", this.options.isThreadsLowPriority());
        this.parameter("aa.min", this.options.getAaMin());
        this.parameter("aa.max", this.options.getAaMax());
        System.out.println("antialiasing " + this.options.getAaMin() + ", " + this.options.getAaMax());
        this.parameter("depths.diffuse", this.options.getDepthsDiffuse());
        this.parameter("depths.reflection", this.options.getDepthsReflection());
        this.parameter("depths.refraction", this.options.getDepthsRefraction());
        this.parameter("filter", this.options.getFilter());
        this.parameter("aa.contrast", this.options.getContrastThreshold());
        int causticPhotons = this.options.getCausticsEmit();
        if (causticPhotons > 0) {
            this.parameter("caustics", "kd");
            this.parameter("caustics.emit", this.options.getCausticsEmit());
            this.parameter("caustics.gather", this.options.getCausticsGather());
            this.parameter("caustics.radius", this.options.getCausticsRadius());
            this.parameter("caustics.filter", this.options.getCausticsFilter());
        }
        if ("ambocc".equals(giEngine = this.options.getGiEngine())) {
            float ambient = (float)this.options.getAmbientOcclusionBright();
            int ambientOcclusionSamples = this.options.getAmbientOcclusionSamples();
            this.parameter("gi.engine", "ambocc");
            this.parameter("gi.ambocc.bright", new org.sunflow.image.Color(ambient, ambient, ambient));
            this.parameter("gi.ambocc.dark", org.sunflow.image.Color.BLACK);
            this.parameter("gi.ambocc.samples", ambientOcclusionSamples);
            this.parameter("gi.ambocc.maxdist", 100.0f);
        } else if ("igi".equals(giEngine)) {
            this.parameter("gi.engine", "igi");
        } else if ("fake".equals(giEngine)) {
            this.parameter("gi.engine", "fake");
        } else if ("path".equals(giEngine)) {
            this.parameter("gi.engine", "path");
        } else if ("irr-cache".equals(giEngine)) {
            this.parameter("gi.engine", "irr-cache");
            this.parameter("gi.irr-cache.gmap", "kd");
        }
        this.options("::options");
        this.render("::options", display);
    }

    public String getName(Geometry geom) {
        String prefix = geom.getName();
        return this.getName(prefix, geom);
    }

    private String getName(String prefix, Object geom) {
        String ret;
        if (this.geom2name.containsKey(geom)) {
            ret = this.geom2name.get(geom);
        } else if (!this.name2geom.containsKey(prefix)) {
            this.geom2name.put(geom, prefix);
            ret = prefix;
        } else {
            String name;
            int counter = 1;
            do {
                name = String.format("%s_%d", prefix, counter);
                ++counter;
            } while (this.name2geom.containsKey(name));
            this.name2geom.put(name, geom);
            this.geom2name.put(geom, name);
            ret = name;
        }
        return ret;
    }

    public void parameter(String string, Color c) {
        this.parameter(string, new org.sunflow.image.Color((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f));
    }

    public void parameter(String name, Matrix m) {
        this.parameter(name, new Matrix4((float)m.getEntry(0, 0), (float)m.getEntry(0, 1), (float)m.getEntry(0, 2), (float)m.getEntry(0, 3), (float)m.getEntry(1, 0), (float)m.getEntry(1, 1), (float)m.getEntry(1, 2), (float)m.getEntry(1, 3), (float)m.getEntry(2, 0), (float)m.getEntry(2, 1), (float)m.getEntry(2, 2), (float)m.getEntry(2, 3), (float)m.getEntry(3, 0), (float)m.getEntry(3, 1), (float)m.getEntry(3, 2), (float)m.getEntry(3, 3)));
    }

    public void parameterPoint(String name, double[] column) {
        this.parameter(name, new Point3((float)column[0], (float)column[1], (float)column[2]));
    }

    public void parameterVector(String name, double[] column) {
        this.parameter(name, new Vector3((float)column[0], (float)column[1], (float)column[2]));
    }

    public void parameter(String name, double val) {
        this.parameter(name, (float)val);
    }

    public RenderOptions getOptions() {
        return this.options;
    }

    public void setOptions(RenderOptions options) {
        this.options = options;
    }

    private class Visitor
    extends SceneGraphVisitor {
        SceneGraphPath path = new SceneGraphPath();
        EffectiveAppearance eapp;
        DefaultGeometryShader dgs;
        de.jreality.shader.DefaultPolygonShader dps;
        Point3 sceneCenter;
        float sceneRadius;
        SceneGraphPath cameraPath;
        int lightID;
        private RenderingHintsShader rhs;
        private String shader;
        int appCount = 0;
        private Matrix currentMatrix;
        int instanceCnt = 0;
        int particleSurfaceCnt = 0;
        private final Texture2D tex2d = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, "", new Appearance(), true);
        private IndexedFaceSet labelFace;

        Visitor(Point3 sceneCenter, float sceneRadius, SceneGraphPath cameraPath) {
            this.tex2d.setRepeatS(10496);
            this.tex2d.setRepeatT(10496);
            this.labelFace = Primitives.texturedQuadrilateral(new double[]{0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0});
            this.sceneCenter = sceneCenter;
            this.sceneRadius = sceneRadius;
            this.cameraPath = cameraPath;
        }

        public void visit(SceneGraphComponent c) {
            if (!c.isVisible()) {
                return;
            }
            this.path.push(c);
            this.currentMatrix = new Matrix(this.path.getMatrix(null));
            this.eapp = EffectiveAppearance.create(this.path);
            this.shader = (String)this.eapp.getAttribute("sunflowShader", "default");
            this.dgs = ShaderUtility.createDefaultGeometryShader(this.eapp);
            this.rhs = ShaderUtility.createRenderingHintsShader(this.eapp);
            c.childrenAccept(this);
            this.path.pop();
        }

        public void visit(IndexedFaceSet ifs) {
            DefaultTextShader ts;
            Boolean infPlane = (Boolean)ifs.getGeometryAttributes("infinite plane");
            if (infPlane != null && infPlane.booleanValue()) {
                this.dps = (de.jreality.shader.DefaultPolygonShader)this.dgs.getPolygonShader();
                this.applyShader(this.dps, true);
                SunflowRenderer.this.parameter("point1", new Point3(1.0f, 0.0f, 0.0f));
                SunflowRenderer.this.parameter("point2", new Point3(0.0f, 1.0f, 0.0f));
                SunflowRenderer.this.geometry(SunflowRenderer.this.getName(ifs), (PrimitiveList)new Plane());
            } else {
                this.visit((IndexedLineSet)ifs);
                if (ifs.getNumFaces() > 0 && this.dgs.getShowFaces().booleanValue()) {
                    DataList tex = ifs.getVertexAttributes(Attribute.TEXTURE_COORDINATES);
                    float[] texCoords = null;
                    if (tex != null) {
                        Matrix texMat = null;
                        texCoords = SunflowRenderer.this.convert(tex.toDoubleArrayArray(), 2, texMat);
                    }
                    this.dps = (de.jreality.shader.DefaultPolygonShader)this.dgs.getPolygonShader();
                    this.applyShader(this.dps, texCoords != null);
                    float[] points = SunflowRenderer.this.convert(ifs.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray(), 3, null);
                    float[] normals = null;
                    if (this.dps.getSmoothShading().booleanValue() && ifs.getVertexAttributes(Attribute.NORMALS) != null) {
                        normals = SunflowRenderer.this.convert(ifs.getVertexAttributes(Attribute.NORMALS).toDoubleArrayArray(), 3, null);
                        SunflowRenderer.this.parameter("normals", "vector", "vertex", normals);
                    }
                    int[] faces = SunflowRenderer.this.convert(ifs.getFaceAttributes(Attribute.INDICES).toIntArrayArray());
                    SunflowRenderer.this.parameter("triangles", faces);
                    SunflowRenderer.this.parameter("points", SunflowRenderer.POINT_SPHERE, "vertex", points);
                    if (texCoords != null) {
                        SunflowRenderer.this.parameter("uvs", "texcoord", "vertex", texCoords);
                    }
                    SunflowRenderer.this.geometry(SunflowRenderer.this.getName(ifs), (PrimitiveList)new TriangleMesh());
                }
            }
            SunflowRenderer.this.parameter("transform", this.currentMatrix);
            String geomName = SunflowRenderer.this.getName(ifs);
            String instanceName = geomName + ".instance" + this.instanceCnt++;
            if (SunflowRenderer.this.bakingPath == null) {
                SunflowRenderer.this.parameter("shaders", "default-shader" + this.appCount);
            } else if (this.path.isEqual(SunflowRenderer.this.bakingPath)) {
                SunflowRenderer.this.bakingInstance = instanceName;
                SunflowRenderer.this.parameter("shaders", "ambientOcclusion");
            } else {
                SunflowRenderer.this.parameter("shaders", "constantWhite");
            }
            SunflowRenderer.this.instance(instanceName, geomName);
            DataList labelsList = ifs.getFaceAttributes(Attribute.LABELS);
            if (labelsList != null && (ts = (DefaultTextShader)this.dps.getTextShader()).getShowLabels().booleanValue()) {
                Font font = ts.getFont();
                Color c = ts.getDiffuseColor();
                double scale = ts.getScale();
                double[] offset = ts.getOffset();
                int alignment = ts.getAlignment();
                ImageData[] img = LabelUtility.createFaceImages(ifs, font, c);
                DoubleArrayArray coords = ifs.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray();
                IntArrayArray inds = ifs.getFaceAttributes(Attribute.INDICES).toIntArrayArray();
                this.writeLabels(img, coords, inds, offset, alignment, scale);
            }
        }

        public void visit(IndexedLineSet indexedLineSet) {
            HashMap particleSurface = (HashMap)indexedLineSet.getGeometryAttributes(SunflowRenderer.PARTICLE_SURFACE);
            if (particleSurface != null) {
                DefaultPointShader pointShader = (DefaultPointShader)this.dgs.getPointShader();
                this.dps = (de.jreality.shader.DefaultPolygonShader)pointShader.getPolygonShader();
                this.applyShader(this.dps, false);
                float[] particles = (float[])particleSurface.get("particles");
                int n = (Integer)particleSurface.get("n");
                double radius = pointShader.getPointRadius();
                double[] tmp = new double[4];
                for (int i = 0; i < n; ++i) {
                    tmp[0] = particles[3 * i];
                    tmp[1] = particles[3 * i + 1];
                    tmp[2] = particles[3 * i + 2];
                    tmp[3] = 1.0;
                    particles[3 * i] = (float)tmp[0];
                    particles[3 * i + 1] = (float)tmp[1];
                    particles[3 * i + 2] = (float)tmp[2];
                }
                SunflowRenderer.this.parameter("particles", SunflowRenderer.POINT_SPHERE, "vertex", particles);
                SunflowRenderer.this.parameter("num", n);
                SunflowRenderer.this.parameter("radius", radius);
                String name = "particeSurface" + this.particleSurfaceCnt;
                SunflowRenderer.this.geometry(name, (PrimitiveList)new ParticleSurface());
                SunflowRenderer.this.parameter("transform", this.currentMatrix);
                SunflowRenderer.this.parameter("shaders", "default-shader" + this.appCount);
                System.out.println("[" + name + "] particle surface with n=" + n + ", r=" + radius);
                SunflowRenderer.this.instance("particeSurface.instance" + this.particleSurfaceCnt, name);
                ++this.particleSurfaceCnt;
                return;
            }
            this.visit((PointSet)indexedLineSet);
            DefaultLineShader ls = (DefaultLineShader)this.dgs.getLineShader();
            Matrix m = null;
            if (this.dgs.getShowLines().booleanValue() && ls.getTubeDraw().booleanValue() && indexedLineSet.getNumEdges() > 0 && indexedLineSet.getNumPoints() > 0) {
                DefaultTextShader ts;
                DoubleArrayArray colors;
                double[] dArray;
                DoubleArray radii;
                this.dps = (de.jreality.shader.DefaultPolygonShader)ls.getPolygonShader();
                double r = ls.getTubeRadius();
                DoubleArrayArray pts = indexedLineSet.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray();
                IntArrayArray lines = indexedLineSet.getEdgeAttributes(Attribute.INDICES).toIntArrayArray();
                DataList radiiAttributes = indexedLineSet.getEdgeAttributes(Attribute.RELATIVE_RADII);
                DoubleArray doubleArray = radii = radiiAttributes != null ? radiiAttributes.toDoubleArray() : null;
                if (pts.getLengthAt(0) == 3) {
                    double[] dArray2 = new double[3];
                    dArray2[0] = 0.0;
                    dArray2[1] = 0.0;
                    dArray = dArray2;
                    dArray2[2] = -1.0;
                } else {
                    double[] dArray3 = new double[4];
                    dArray3[0] = 0.0;
                    dArray3[1] = 0.0;
                    dArray3[2] = -1.0;
                    dArray = dArray3;
                    dArray3[3] = 1.0;
                }
                double[] zAxis = dArray;
                DataList colorAttributes = indexedLineSet.getEdgeAttributes(Attribute.COLORS);
                boolean lineColors = colorAttributes != null;
                DoubleArrayArray doubleArrayArray = colors = lineColors ? colorAttributes.toDoubleArrayArray() : null;
                if (!lineColors) {
                    this.applyShader(this.dps, false);
                }
                for (int i = 0; i < lines.getLength(); ++i) {
                    double radius;
                    double d = radius = radii != null ? radii.getValueAt(i) : r;
                    if (ls.getRadiiWorldCoordinates().booleanValue()) {
                        radius /= CameraUtility.getScalingFactor(this.currentMatrix.getArray(), 0);
                    }
                    if (lineColors) {
                        Appearance app = new Appearance("fake app");
                        EffectiveAppearance ea = this.eapp.create(app);
                        this.dgs = ShaderUtility.createDefaultGeometryShader(ea);
                        this.dps = (de.jreality.shader.DefaultPolygonShader)((DefaultLineShader)this.dgs.getLineShader()).getPolygonShader();
                        double[] vc = colors.getValueAt(i).toDoubleArray(null);
                        Color vcc = new Color((float)vc[0], (float)vc[1], (float)vc[2]);
                        app.setAttribute("lineShader.polygonShader.diffuseColor", vcc);
                        if (vc.length == 4) {
                            app.setAttribute("lineShader.polygonShader.transparency", this.dps.getTransparency() * vc[3]);
                        }
                        this.applyShader(this.dps, false);
                    }
                    for (int j = 0; j < lines.getLengthAt(i) - 1; ++j) {
                        double[] p1 = pts.getValueAt(lines.getValueAt(i, j)).toDoubleArray(null);
                        double[] p2 = pts.getValueAt(lines.getValueAt(i, j + 1)).toDoubleArray(null);
                        double[] seg = Rn.subtract(null, p2, p1);
                        double[] center = Rn.linearCombination(null, 0.5, p1, 0.5, p2);
                        double len = Rn.euclideanNorm(seg);
                        m = Matrix.times(this.currentMatrix, MatrixBuilder.euclidean().translate(center[0], center[1], center[2]).rotateFromTo(zAxis, seg).scale(radius, radius, len / 2.0).getMatrix());
                        SunflowRenderer.this.parameter("transform", m);
                        if (SunflowRenderer.this.bakingPath == null) {
                            SunflowRenderer.this.parameter("shaders", "default-shader" + this.appCount);
                        } else {
                            SunflowRenderer.this.parameter("shaders", "constantWhite");
                        }
                        SunflowRenderer.this.instance("line.instance" + this.instanceCnt++, SunflowRenderer.LINE_CYLINDER);
                    }
                }
                DataList labelsList = indexedLineSet.getEdgeAttributes(Attribute.LABELS);
                if (labelsList != null && (ts = (DefaultTextShader)this.dps.getTextShader()).getShowLabels().booleanValue()) {
                    Font font = ts.getFont();
                    Color c = ts.getDiffuseColor();
                    double scale = ts.getScale();
                    double[] offset = ts.getOffset();
                    int alignment = ts.getAlignment();
                    ImageData[] img = LabelUtility.createEdgeImages(indexedLineSet, font, c);
                    DoubleArrayArray coords = indexedLineSet.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray();
                    IntArrayArray inds = indexedLineSet.getEdgeAttributes(Attribute.INDICES).toIntArrayArray();
                    this.writeLabels(img, coords, inds, offset, alignment, scale);
                }
            }
        }

        public void visit(PointSet pointSet) {
            DefaultPointShader ps = (DefaultPointShader)this.dgs.getPointShader();
            if (this.dgs.getShowPoints().booleanValue() && ps.getSpheresDraw().booleanValue() && pointSet.getNumPoints() > 0) {
                DefaultTextShader ts;
                DoubleArrayArray colors;
                this.dps = (de.jreality.shader.DefaultPolygonShader)ps.getPolygonShader();
                double r = ps.getPointRadius();
                DoubleArrayArray pts = pointSet.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray();
                DataList radiiAttributes = pointSet.getVertexAttributes(Attribute.RELATIVE_RADII);
                DoubleArray radii = radiiAttributes != null ? radiiAttributes.toDoubleArray() : null;
                DataList colorAttributes = pointSet.getVertexAttributes(Attribute.COLORS);
                boolean vertexColors = colorAttributes != null;
                DoubleArrayArray doubleArrayArray = colors = vertexColors ? colorAttributes.toDoubleArrayArray() : null;
                if (!vertexColors) {
                    this.applyShader(this.dps, false);
                }
                for (int i = 0; i < pts.getLength(); ++i) {
                    double w;
                    double radius;
                    double d = radius = radii != null ? radii.getValueAt(i) : r;
                    if (ps.getRadiiWorldCoordinates().booleanValue()) {
                        radius /= CameraUtility.getScalingFactor(this.currentMatrix.getArray(), 0);
                    }
                    if (vertexColors) {
                        Appearance app = new Appearance("fake app");
                        EffectiveAppearance ea = this.eapp.create(app);
                        this.dgs = ShaderUtility.createDefaultGeometryShader(ea);
                        this.dps = (de.jreality.shader.DefaultPolygonShader)((DefaultPointShader)this.dgs.getPointShader()).getPolygonShader();
                        double[] vc = colors.getValueAt(i).toDoubleArray(null);
                        Color vcc = new Color((float)vc[0], (float)vc[1], (float)vc[2]);
                        app.setAttribute("pointShader.polygonShader.diffuseColor", vcc);
                        if (vc.length == 4) {
                            app.setAttribute("pointShader.polygonShader.transparency", this.dps.getTransparency() * vc[3]);
                        }
                        this.applyShader(this.dps, false);
                    }
                    double d2 = w = pts.getLengthAt(i) == 3 ? 1.0 : pts.getValueAt(i, 3);
                    if (w == 0.0) continue;
                    Matrix m = Matrix.times(this.currentMatrix, MatrixBuilder.euclidean().translate(pts.getValueAt(i, 0) / w, pts.getValueAt(i, 1) / w, pts.getValueAt(i, 2) / w).scale(radius).getMatrix());
                    SunflowRenderer.this.parameter("transform", m);
                    if (SunflowRenderer.this.bakingPath == null) {
                        SunflowRenderer.this.parameter("shaders", "default-shader" + this.appCount);
                    } else {
                        SunflowRenderer.this.parameter("shaders", "constantWhite");
                    }
                    SunflowRenderer.this.instance("point.instance" + this.instanceCnt++, SunflowRenderer.POINT_SPHERE);
                }
                DataList labelsList = pointSet.getVertexAttributes(Attribute.LABELS);
                if (labelsList != null && (ts = (DefaultTextShader)this.dps.getTextShader()).getShowLabels().booleanValue()) {
                    Font font = ts.getFont();
                    Color c = ts.getDiffuseColor();
                    double scale = ts.getScale();
                    double[] offset = ts.getOffset();
                    int alignment = ts.getAlignment();
                    ImageData[] img = LabelUtility.createPointImages(pointSet, font, c);
                    DoubleArrayArray coords = pointSet.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray();
                    this.writeLabels(img, coords, null, offset, alignment, scale);
                }
            }
        }

        public void visit(DirectionalLight l) {
            if (!l.isAmbientFake() || "sun light".equals(l.getName()) && !SunflowRenderer.this.ignoreSunLight) {
                double[] d = this.currentMatrix.multiplyVector(new double[]{0.0, 0.0, -1.0, 0.0});
                Vector3 dir = new Vector3((float)d[0], (float)d[1], (float)d[2]);
                Point3 src = new Point3(this.sceneCenter.x - this.sceneRadius * dir.x, this.sceneCenter.y - this.sceneRadius * dir.y, this.sceneCenter.z - this.sceneRadius * dir.z);
                System.out.println("source at " + src);
                System.out.println("direction " + dir);
                System.out.println("radius " + this.sceneRadius);
                SunflowRenderer.this.parameter("source", src);
                SunflowRenderer.this.parameter("radius", this.sceneRadius);
                SunflowRenderer.this.parameter("dir", dir);
                DirectionalSpotlight sun = new DirectionalSpotlight();
                Color c = l.getColor();
                float i = (float)l.getIntensity() * (float)Math.PI;
                org.sunflow.image.Color col = new org.sunflow.image.Color((float)c.getRed() / 255.0f * i, (float)c.getGreen() / 255.0f * i, (float)c.getBlue() / 255.0f * i);
                SunflowRenderer.this.parameter("radiance", col);
                SunflowRenderer.this.light("directionalLight" + this.lightID++, (LightSource)sun);
            }
        }

        public void visit(PointLight l) {
            if (!l.isAmbientFake()) {
                double[] point = this.currentMatrix.multiplyVector(new double[]{0.0, 0.0, 0.0, 1.0});
                SunflowRenderer.this.parameterPoint("center", point);
                GlPointLight light = new GlPointLight();
                Color c = l.getColor();
                float i = (float)l.getIntensity() * (float)Math.PI;
                org.sunflow.image.Color col = new org.sunflow.image.Color((float)c.getRed() / 255.0f * i, (float)c.getGreen() / 255.0f * i, (float)c.getBlue() / 255.0f * i);
                SunflowRenderer.this.parameter("power", col);
                SunflowRenderer.this.parameter("fallOffA0", l.getFalloffA0());
                SunflowRenderer.this.parameter("fallOffA1", l.getFalloffA1());
                SunflowRenderer.this.parameter("fallOffA2", l.getFalloffA2());
                SunflowRenderer.this.light("pointLight" + this.lightID++, light);
            }
        }

        public void visit(de.jreality.scene.Sphere s) {
            SunflowRenderer.this.geometry(SunflowRenderer.this.getName(s), (PrimitiveList)new Sphere());
        }

        public void visit(de.jreality.scene.Cylinder c) {
            SunflowRenderer.this.geometry(SunflowRenderer.this.getName(c), new Cylinder());
        }

        private void applyShader(de.jreality.shader.DefaultPolygonShader ps, boolean hasTextureCoordinates) {
            ++this.appCount;
            if ("default".equals(this.shader)) {
                SunflowRenderer.this.shader("default-shader" + this.appCount, new DefaultPolygonShader(ps, this.rhs, hasTextureCoordinates));
            } else if ("glass".equals(this.shader)) {
                System.out.println("applying glass shader");
                SunflowRenderer.this.parameter("color", ps.getDiffuseColor());
                SunflowRenderer.this.shader("default-shader" + this.appCount, (Shader)new GlassShader());
            }
        }

        private void writeLabels(ImageData[] labels, DoubleArrayArray vertices, IntArrayArray indices, double[] offset, int alignment, double scale) {
            double[] cam2obj = new Matrix(Rn.times(null, this.cameraPath.getInverseMatrix(null), this.currentMatrix.getArray())).getInverse().getArray();
            Matrix bbm = new Matrix();
            int n = labels.length;
            for (int i = 0; i < n; ++i) {
                ImageData img = labels[i];
                LabelUtility.calculateBillboardMatrix(bbm.getArray(), (double)img.getWidth() * scale, (double)img.getHeight() * scale, offset, alignment, cam2obj, LabelUtility.positionFor(i, vertices, indices), 0, 0);
                Appearance labelApp = new Appearance();
                labelApp.setAttribute("showPoints", false);
                labelApp.setAttribute("showLines", false);
                labelApp.setAttribute("lightingEnabled", false);
                TextureUtility.createTexture(labelApp, "polygonShader", img, false);
                this.dgs = ShaderUtility.createDefaultGeometryShader(labelApp, true);
                this.dps = (de.jreality.shader.DefaultPolygonShader)this.dgs.getPolygonShader();
                this.applyShader(this.dps, true);
                Matrix tempTrafo = new Matrix();
                tempTrafo.multiplyOnRight(this.currentMatrix);
                this.currentMatrix.multiplyOnRight(bbm);
                this.visit(this.labelFace);
                this.currentMatrix = tempTrafo;
                this.dgs = ShaderUtility.createDefaultGeometryShader(this.eapp);
                this.dps = (de.jreality.shader.DefaultPolygonShader)this.dgs.getPolygonShader();
            }
        }
    }
}

