/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.sunflow;

import de.jreality.math.MatrixBuilder;
import de.jreality.scene.DirectionalLight;
import de.jreality.scene.Geometry;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.shader.ImageData;
import de.jreality.sunflow.SkyLight;
import java.awt.image.BufferedImage;
import org.sunflow.core.ParameterList;

public class PerezSky
extends Geometry {
    private SkyLight skyLight = new SkyLight();
    private ImageData[] cubeMap;
    private Double turbidity;
    private double[] sunDirection;
    private int resolution;
    private BufferedImage posX;
    private BufferedImage negX;
    private BufferedImage posY;
    private BufferedImage negY;
    private BufferedImage posZ;
    private BufferedImage negZ;
    private DirectionalLight sunLight;
    private DirectionalLight skyAmbientLight;
    private SceneGraphComponent sunLightNode;
    private SceneGraphComponent skyAmbientNode;
    private SceneGraphComponent lightComponent;

    public PerezSky() {
        this(32, null, new double[]{0.0, 1.0, 1.0});
    }

    public PerezSky(int resolution, Double turbidity, double[] sunDirWorld) {
        super("perezSky");
        this.resolution = resolution;
        this.turbidity = turbidity;
        this.lightComponent = new SceneGraphComponent();
        this.sunLight = new DirectionalLight();
        this.sunLight.setAmbientFake(true);
        this.sunLight.setName("sun light");
        this.sunLightNode = new SceneGraphComponent("sun");
        this.sunLightNode.setLight(this.sunLight);
        MatrixBuilder.euclidean().rotateFromTo(new double[]{0.0, 0.0, 1.0}, new double[]{0.0, 1.0, 1.0}).assignTo(this.sunLightNode);
        this.lightComponent.addChild(this.sunLightNode);
        this.skyAmbientNode = new SceneGraphComponent("skyAmbient");
        this.skyAmbientLight = new DirectionalLight();
        this.skyAmbientLight.setAmbientFake(true);
        this.skyAmbientLight.setName("sky light");
        this.skyAmbientNode.setLight(this.skyAmbientLight);
        MatrixBuilder.euclidean().rotateFromTo(new double[]{0.0, 0.0, 1.0}, new double[]{0.0, 1.0, 0.0}).assignTo(this.skyAmbientNode);
        this.lightComponent.addChild(this.skyAmbientNode);
        this.makeBufferedImages();
        this.setSunDirection(sunDirWorld);
    }

    public Double getTurbidity() {
        return this.turbidity;
    }

    public void setTurbidity(Double turbidity) {
        this.turbidity = turbidity;
        this.updateSkyLight();
        this.updateCubeMap();
    }

    public double[] getSunDirection() {
        return (double[])this.sunDirection.clone();
    }

    public void setSunDirection(double[] sunDirWorld) {
        this.sunDirection = (double[])sunDirWorld.clone();
        MatrixBuilder.euclidean().rotateFromTo(new double[]{0.0, 0.0, 1.0}, sunDirWorld).assignTo(this.sunLightNode);
        this.updateSkyLight();
        this.updateCubeMap();
    }

    private void updateSkyLight() {
        ParameterList pl = new ParameterList();
        if (this.turbidity != null) {
            pl.addFloat("turbidity", this.turbidity.floatValue());
        }
        if (this.sunDirection != null) {
            pl.addVectors("sundir", ParameterList.InterpolationType.NONE, new float[]{(float)this.sunDirection[0], (float)this.sunDirection[1], (float)this.sunDirection[2]});
        }
        this.skyLight.update(pl);
    }

    public ImageData[] getCubeMap() {
        return this.cubeMap;
    }

    private void updateCubeMap() {
        for (int i = 0; i < this.resolution; ++i) {
            for (int j = 0; j < this.resolution; ++j) {
                double v = ((double)(this.resolution - 1) - 2.0 * (double)i) / ((double)this.resolution - 0.5);
                double u = ((double)(this.resolution - 1) - 2.0 * (double)j) / ((double)this.resolution - 0.5);
                this.posX.setRGB(i, j, this.skyLight.getRadiance(1.0, u, v));
                this.negX.setRGB(i, j, this.skyLight.getRadiance(-1.0, u, -v));
                this.posY.setRGB(i, j, this.skyLight.getRadiance(-v, 1.0, -u));
                this.negY.setRGB(i, j, this.skyLight.getRadiance(-v, -1.0, u));
                this.posZ.setRGB(i, j, this.skyLight.getRadiance(-v, u, 1.0));
                this.negZ.setRGB(i, j, this.skyLight.getRadiance(v, u, -1.0));
            }
        }
        this.cubeMap = new ImageData[]{new ImageData(this.posX), new ImageData(this.negX), new ImageData(this.posY), new ImageData(this.negY), new ImageData(this.posZ), new ImageData(this.negZ)};
    }

    private void makeBufferedImages() {
        this.posX = new BufferedImage(this.resolution, this.resolution, 1);
        this.negX = new BufferedImage(this.resolution, this.resolution, 1);
        this.posY = new BufferedImage(this.resolution, this.resolution, 1);
        this.posX = new BufferedImage(this.resolution, this.resolution, 1);
        this.negY = new BufferedImage(this.resolution, this.resolution, 1);
        this.posZ = new BufferedImage(this.resolution, this.resolution, 1);
        this.negZ = new BufferedImage(this.resolution, this.resolution, 1);
    }

    public int getResolution() {
        return this.resolution;
    }

    public void setResolution(int resolution) {
        if (resolution != this.resolution) {
            this.resolution = resolution;
            this.makeBufferedImages();
            this.updateCubeMap();
        }
    }

    public SceneGraphComponent getLightComponent() {
        return this.lightComponent;
    }
}

