/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.softviewer.shader;

import de.jreality.backends.texture.EnvironmentTexture;
import de.jreality.backends.texture.SimpleTexture;
import de.jreality.backends.texture.Texture;
import de.jreality.scene.Geometry;
import de.jreality.shader.CubeMap;
import de.jreality.shader.Texture2D;
import de.jreality.softviewer.Environment;
import de.jreality.softviewer.Polygon;
import de.jreality.softviewer.VecMat;
import de.jreality.softviewer.shader.DefaultVertexShader;
import de.jreality.softviewer.shader.PolygonShader;
import de.jreality.softviewer.shader.VertexShader;

public class DefaultPolygonShader
extends PolygonShader {
    private boolean interpolateColor = true;
    protected VertexShader vertexShader;
    protected boolean outline = false;
    private final boolean smooth;
    private final boolean needsNormals;
    private final de.jreality.shader.DefaultPolygonShader ps;

    public DefaultPolygonShader() {
        this(new DefaultVertexShader());
    }

    public DefaultPolygonShader(VertexShader v) {
        this.vertexShader = v;
        this.smooth = true;
        this.ps = null;
        this.needsNormals = false;
    }

    public DefaultPolygonShader(de.jreality.shader.DefaultPolygonShader ps) {
        CubeMap cm;
        this.vertexShader = new DefaultVertexShader(ps.getDiffuseColor(), ps.getSpecularCoefficient(), ps.getSpecularExponent(), ps.getTransparency());
        this.ps = ps;
        Texture2D tex = ps.getTexture2d();
        if (tex != null && tex.getImage() != null) {
            this.texture = new SimpleTexture(tex);
        }
        if ((cm = ps.getReflectionMap()) != null) {
            this.texture = new EnvironmentTexture(cm, this.texture);
            this.needsNormals = true;
        } else {
            this.needsNormals = false;
        }
        this.smooth = ps.getSmoothShading();
    }

    public void shadePolygon(Polygon p, Environment environment, boolean vertexColors) {
        p.setTransparency(this.vertexShader.getTransparency());
        p.setTexture(this.texture);
        p.setInterpolateAlpha(this.interpolateAlpha());
        p.setInterpolateColor(this.interpolateColor());
        p.setSkybox(false);
        int n = p.getLength();
        if (this.smooth) {
            for (int i = 0; i < n; ++i) {
                double[] v = p.getPoint(i);
                this.vertexShader.shadeVertex(v, environment, vertexColors);
                if (!this.needsNormals) continue;
                double ff = (v[0] * v[14] + v[1] * v[15] + v[2] * v[16]) / (v[14] * v[14] + v[15] * v[15] + v[16] * v[16]);
                double[] m = environment.getCameraWorld();
                VecMat.transformUnNormalized(m, -2.0 * ff * v[14] + v[0], -2.0 * ff * v[15] + v[1], -2.0 * ff * v[16] + v[2], v, 14);
            }
        } else {
            double[] v = p.getCenter();
            v[4] = 0.0;
            v[5] = 0.0;
            v[6] = 0.0;
            for (int i = 0; i < n; ++i) {
                double[] vertexData = p.getPoint(i);
                v[4] = v[4] + vertexData[4];
                v[5] = v[5] + vertexData[5];
                v[6] = v[6] + vertexData[6];
                v[0] = v[0] + vertexData[0];
                v[1] = v[1] + vertexData[1];
                v[2] = v[2] + vertexData[2];
                v[8] = v[8] + vertexData[8];
                v[9] = v[9] + vertexData[9];
                v[10] = v[10] + vertexData[10];
                v[11] = v[11] + vertexData[11];
            }
            v[4] = v[4] / (double)n;
            v[5] = v[5] / (double)n;
            v[6] = v[6] / (double)n;
            v[7] = 1.0;
            v[3] = 1.0;
            v[8] = v[8] / (double)n;
            v[9] = v[9] / (double)n;
            v[10] = v[10] / (double)n;
            v[11] = v[11] / (double)n;
            double[] vertexData = p.getPoint(0);
            this.vertexShader.shadeVertex(v, environment, vertexColors);
            for (int i = 0; i < n; ++i) {
                vertexData = p.getPoint(i);
                vertexData[8] = v[8];
                vertexData[9] = v[9];
                vertexData[10] = v[10];
            }
        }
    }

    public final VertexShader getVertexShader() {
        return this.vertexShader;
    }

    public final boolean interpolateColor() {
        return this.smooth || this.vertexShader.isVertexColors();
    }

    public boolean interpolateAlpha() {
        return this.vertexShader.interpolateAlpha();
    }

    public boolean isOutline() {
        return this.outline;
    }

    public void setOutline(boolean outline) {
        this.outline = outline;
    }

    public Texture getTexture() {
        return this.texture;
    }

    public boolean hasTexture() {
        return this.texture != null;
    }

    public void startGeometry(Geometry geom) {
        if (this.vertexShader != null) {
            this.vertexShader.startGeometry(geom);
        }
    }

    public boolean needsSorting() {
        return this.vertexShader.getTransparency() != 0.0 || this.hasTexture() && this.texture.isTransparent() || this.interpolateAlpha();
    }

    public void setColor(double r, double g, double b) {
        this.vertexShader.setColor(r, g, b);
    }

    public double getBlue() {
        return this.vertexShader.getBlue();
    }

    public double getGreen() {
        return this.vertexShader.getGreen();
    }

    public double getRed() {
        return this.vertexShader.getRed();
    }
}

