/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.softviewer;

import de.jreality.backends.texture.SimpleTexture;
import de.jreality.geometry.IndexedFaceSetUtility;
import de.jreality.geometry.Primitives;
import de.jreality.geometry.SphereUtility;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.data.DoubleArrayArray;
import de.jreality.scene.data.IntArray;
import de.jreality.scene.data.IntArrayArray;
import de.jreality.scene.data.StorageModel;
import de.jreality.shader.CubeMap;
import de.jreality.softviewer.TrianglePipeline;
import de.jreality.softviewer.shader.SkyboxPolygonShader;

public class PrimitiveCache {
    private static IndexedFaceSet[] sphere;
    private static IntArrayArray[] sphereIndices;
    private static DoubleArrayArray[] sphereVertices;
    private static DoubleArrayArray[] sphereNormals;
    private static IndexedFaceSet[] cylinder;
    private static IntArrayArray[] cylinderIndices;
    private static DoubleArrayArray[] cylinderVertices;
    private static DoubleArrayArray[] cylinderNormals;
    private static IntArrayArray[] tubeIndices;
    private static DoubleArrayArray[] tubeVertices;
    private static double[][] tubeVerticesDoubles;
    private static DoubleArrayArray[] tubeNormals;
    private static SkyboxPolygonShader skybox;
    private static final DoubleArrayArray[] cubeVertices;
    private static final DoubleArrayArray cubeTex;
    private static final IntArray cubeIndices;
    private static final DoubleArray[] cubeNormals;

    private PrimitiveCache() {
    }

    public static void renderSphere(TrianglePipeline pipeline, double lod) {
        int i = (int)Math.min(4.0 * Math.pow(lod, 0.25), 4.0);
        int n = sphereIndices[i].size();
        for (int j = 0; j < n; ++j) {
            pipeline.processPolygon(sphereVertices[i], sphereIndices[i].getValueAt(j), sphereNormals[i], sphereIndices[i].getValueAt(j), null, null, null, null);
        }
    }

    public static void renderCylinder(TrianglePipeline pipeline, double lod) {
        int i = (int)Math.min(12.0 * Math.pow(lod, 0.4), 12.0);
        int n = cylinderIndices[i].size();
        for (int j = 0; j < n; ++j) {
            pipeline.processPolygon(cylinderVertices[i], cylinderIndices[i].getValueAt(j), cylinderNormals[i], cylinderIndices[i].getValueAt(j), null, null, null, null);
        }
    }

    public static IndexedFaceSet getSphere(double lod) {
        int i = (int)Math.min(4.0 * Math.pow(lod, 0.2857142857142857), 4.0);
        return sphere[i] == null ? SphereUtility.tessellatedIcosahedronSphere(i - 1, true) : sphere[i];
    }

    public static IndexedFaceSet getCylinder(double lod) {
        int i = (int)Math.min(16.0 * Math.pow(lod, 0.2857142857142857), 16.0);
        return cylinder[i];
    }

    public static void renderSky(TrianglePipeline pipeline, CubeMap sky) {
        pipeline.setFaceShader(skybox);
        SimpleTexture tex = SimpleTexture.create(sky.getBack());
        skybox.setTexture(tex);
        pipeline.processPolygon(cubeVertices[0], cubeIndices, null, null, cubeTex, null, cubeNormals[0], null);
        tex = SimpleTexture.create(sky.getFront());
        skybox.setTexture(tex);
        pipeline.processPolygon(cubeVertices[1], cubeIndices, null, null, cubeTex, null, cubeNormals[1], null);
        tex = SimpleTexture.create(sky.getTop());
        skybox.setTexture(tex);
        pipeline.processPolygon(cubeVertices[2], cubeIndices, null, null, cubeTex, null, cubeNormals[2], null);
        tex = SimpleTexture.create(sky.getBottom());
        skybox.setTexture(tex);
        pipeline.processPolygon(cubeVertices[3], cubeIndices, null, null, cubeTex, null, cubeNormals[3], null);
        tex = SimpleTexture.create(sky.getLeft());
        skybox.setTexture(tex);
        pipeline.processPolygon(cubeVertices[4], cubeIndices, null, null, cubeTex, null, cubeNormals[4], null);
        tex = SimpleTexture.create(sky.getRight());
        skybox.setTexture(tex);
        pipeline.processPolygon(cubeVertices[5], cubeIndices, null, null, cubeTex, null, cubeNormals[5], null);
    }

    public static void renderCylinder2(TrianglePipeline pipeline, double lod) {
        int i = (int)Math.min(12.0 * Math.pow(lod, 0.4), 12.0);
        int n = tubeIndices[i].size();
        for (int j = 0; j < n; ++j) {
            pipeline.processPolygon(tubeVertices[i], tubeIndices[i].getValueAt(j), tubeNormals[i], tubeIndices[i].getValueAt(j), null, null, null, null);
        }
    }

    public static void makeCylinders() {
        for (int n = 3; n < 16; ++n) {
            int rn = n;
            double[] verts = new double[8 * rn];
            double[] norms = new double[6 * rn];
            int[][] idx = new int[rn][4];
            double angle = 0.0;
            double delta = Math.PI * 2 / (double)n;
            for (int i = 0; i < rn; ++i) {
                angle = (double)i * delta;
                verts[4 * (i + rn)] = 0.0;
                double d = Math.cos(angle);
                norms[3 * i] = d;
                norms[3 * (i + rn)] = d;
                verts[4 * i] = d;
                verts[4 * (i + rn) + 1] = 0.0;
                double d2 = Math.sin(angle);
                norms[3 * i + 1] = d2;
                norms[3 * (i + rn) + 1] = d2;
                verts[4 * i + 1] = d2;
                verts[4 * i + 2] = 0.0;
                verts[4 * (i + rn) + 2] = 1.0;
                verts[4 * i + 3] = 1.0;
                verts[4 * (i + rn) + 3] = 0.0;
                norms[3 * (i + rn) + 2] = 0.0;
                norms[3 * i + 2] = 0.0;
                idx[i][0] = i;
                idx[i][1] = (i + 1) % rn;
                idx[i][2] = (i + 1) % rn + rn;
                idx[i][3] = i + rn;
            }
            PrimitiveCache.tubeVerticesDoubles[n - 3] = verts;
            PrimitiveCache.tubeVertices[n - 3] = new DoubleArrayArray.Inlined(verts, 4);
            PrimitiveCache.tubeNormals[n - 3] = new DoubleArrayArray.Inlined(norms, 3);
            PrimitiveCache.tubeIndices[n - 3] = new IntArrayArray.Array(idx);
        }
    }

    static {
        int i;
        sphere = new IndexedFaceSet[5];
        sphereIndices = new IntArrayArray[5];
        sphereVertices = new DoubleArrayArray[5];
        sphereNormals = new DoubleArrayArray[5];
        cylinder = new IndexedFaceSet[13];
        cylinderIndices = new IntArrayArray[13];
        cylinderVertices = new DoubleArrayArray[13];
        cylinderNormals = new DoubleArrayArray[13];
        tubeIndices = new IntArrayArray[13];
        tubeVertices = new DoubleArrayArray[13];
        tubeVerticesDoubles = new double[13][];
        tubeNormals = new DoubleArrayArray[13];
        skybox = new SkyboxPolygonShader();
        cubeVertices = new DoubleArrayArray[]{new DoubleArrayArray.Array(new double[][]{{1.0, 1.0, 1.0}, {1.0, 1.0, -1.0}, {1.0, -1.0, -1.0}, {1.0, -1.0, 1.0}}), new DoubleArrayArray.Array(new double[][]{{-1.0, 1.0, -1.0}, {-1.0, 1.0, 1.0}, {-1.0, -1.0, 1.0}, {-1.0, -1.0, -1.0}}), new DoubleArrayArray.Array(new double[][]{{-1.0, -1.0, 1.0}, {1.0, -1.0, 1.0}, {1.0, -1.0, -1.0}, {-1.0, -1.0, -1.0}}), new DoubleArrayArray.Array(new double[][]{{-1.0, 1.0, -1.0}, {1.0, 1.0, -1.0}, {1.0, 1.0, 1.0}, {-1.0, 1.0, 1.0}}), new DoubleArrayArray.Array(new double[][]{{-1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {1.0, -1.0, 1.0}, {-1.0, -1.0, 1.0}}), new DoubleArrayArray.Array(new double[][]{{1.0, 1.0, -1.0}, {-1.0, 1.0, -1.0}, {-1.0, -1.0, -1.0}, {1.0, -1.0, -1.0}})};
        cubeTex = new DoubleArrayArray.Array(new double[][]{{0.0, 0.0}, {1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}});
        cubeIndices = new IntArray(new int[]{0, 1, 2, 3});
        cubeNormals = new DoubleArray[]{new DoubleArray(new double[]{1.0, 0.0, 0.0}), new DoubleArray(new double[]{-1.0, 0.0, 0.0}), new DoubleArray(new double[]{0.0, 1.0, 0.0}), new DoubleArray(new double[]{0.0, -1.0, 0.0}), new DoubleArray(new double[]{0.0, 0.0, 1.0}), new DoubleArray(new double[]{0.0, 0.0, -1.0})};
        double d = 1.0 / Math.sqrt(3.0);
        double[][] tetrahedronVerts3 = new double[][]{{d, d, d}, {d, -d, -d}, {-d, d, -d}, {-d, -d, d}};
        int[][] tetrahedronIndices = new int[][]{{0, 1, 2}, {2, 1, 3}, {1, 0, 3}, {0, 2, 3}};
        IndexedFaceSet tetra = new IndexedFaceSet(4, 4);
        tetra.setFaceAttributes(Attribute.INDICES, new IntArrayArray.Array(tetrahedronIndices));
        tetra.setVertexAttributes(Attribute.COORDINATES, StorageModel.DOUBLE_ARRAY.array(3).createReadOnly(tetrahedronVerts3));
        IndexedFaceSetUtility.calculateAndSetVertexNormals(tetra);
        PrimitiveCache.sphere[0] = tetra;
        IndexedFaceSetUtility.calculateAndSetVertexNormals(sphere[0]);
        for (i = 0; i < sphere.length; ++i) {
            if (i > 0) {
                PrimitiveCache.sphere[i] = SphereUtility.tessellatedIcosahedronSphere(i - 1, true);
            }
            PrimitiveCache.sphereIndices[i] = sphere[i].getFaceAttributes(Attribute.INDICES).toIntArrayArray();
            PrimitiveCache.sphereVertices[i] = sphere[i].getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray();
            PrimitiveCache.sphereNormals[i] = sphere[i].getVertexAttributes(Attribute.NORMALS).toDoubleArrayArray();
        }
        for (i = 0; i < cylinder.length; ++i) {
            PrimitiveCache.cylinder[i] = Primitives.cylinder(i + 3);
            PrimitiveCache.cylinderIndices[i] = cylinder[i].getFaceAttributes(Attribute.INDICES).toIntArrayArray();
            PrimitiveCache.cylinderVertices[i] = cylinder[i].getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray();
            PrimitiveCache.cylinderNormals[i] = cylinder[i].getVertexAttributes(Attribute.NORMALS).toDoubleArrayArray();
        }
        PrimitiveCache.makeCylinders();
    }
}

