/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.softviewer;

import de.jreality.backends.texture.Texture;
import de.jreality.softviewer.Imager;
import de.jreality.softviewer.Triangle;
import de.jreality.softviewer.TriangleRasterizer;
import de.jreality.softviewer.shader.OutlineImager;
import de.jreality.util.Secure;
import java.awt.Color;
import java.util.Arrays;

public class DoubleTriangleRasterizer
extends TriangleRasterizer {
    private static final double COLOR_CH_SCALE = 0.00392156862745098;
    private static final int COLOR_CH_MASK = 255;
    private static final int OPAQUE = -16777216;
    private static final boolean correctInterpolation = true;
    private boolean interpolateNormals = false;
    private int xmin = 0;
    private int xmax = 0;
    private int ymin = 0;
    private int ymax = 0;
    private double wh;
    private double hh;
    private double minDim;
    private double maxDim;
    private double[][] polygon = new double[3][17];
    private final Quantity xxx = new Quantity();
    private final Quantity yyy = new Quantity();
    private final Quantity zzz = new Quantity();
    private final Quantity www = new Quantity();
    private final Quantity rrr = new Quantity();
    private final Quantity ggg = new Quantity();
    private final Quantity bbb = new Quantity();
    private final Quantity aaa = new Quantity();
    private final Quantity uuu = new Quantity();
    private final Quantity vvv = new Quantity();
    private final Quantity nnx = new Quantity();
    private final Quantity nny = new Quantity();
    private final Quantity nnz = new Quantity();
    private final boolean interpolateY;
    private final boolean interpolateFullX;
    private boolean interpolateColor;
    private boolean interpolateW;
    private boolean interpolateA;
    private boolean interpolateUV;
    protected double transparency = 0.0;
    private Texture texture = null;
    private double[] zBuffer;
    private int w;
    private int h;
    private int[] pixels;
    private int background;
    private Imager imager = null;
    private final double[] color;
    final double[] data;
    private int[] backgroundArray;
    private int rightlower;
    private int rightupper;
    private int leftupper;
    private int leftlower;
    private boolean transparencyEnabled;
    private static final double ZEPS = -1.0E-4;

    public DoubleTriangleRasterizer(int[] pixelBuf, boolean interpolateY, boolean interpolateFullX, Colorizer colorizer) {
        try {
            String img = Secure.getProperty("jreality.soft.imager");
            if (img != null && img.equals("outline")) {
                this.imager = new OutlineImager();
            }
        }
        catch (SecurityException se) {
            // empty catch block
        }
        this.color = new double[4];
        this.data = new double[17];
        this.interpolateY = interpolateY;
        this.interpolateFullX = interpolateFullX;
        this.pixels = pixelBuf;
    }

    public DoubleTriangleRasterizer(int[] pixelBuf) {
        this(pixelBuf, false, false, null);
    }

    public final void renderTriangle(Triangle t, boolean outline) {
        this.transparency = t.getTransparency();
        this.texture = t.getTexture();
        this.interpolateUV = this.texture != null;
        this.interpolateColor = t.isInterpolateColor();
        this.interpolateNormals = this.texture != null && this.texture.needsNormals();
        this.interpolateW = this.interpolateColor || this.interpolateUV;
        for (int i = 0; i < 3; ++i) {
            double iw;
            double[] vertexData = t.getPoint(i);
            double[] pi = this.polygon[i];
            double w = 1.0 / vertexData[7];
            double wxy = w * this.minDim;
            pi[4] = this.wh + vertexData[4] * wxy;
            pi[5] = this.hh - vertexData[5] * wxy;
            pi[6] = vertexData[6] * w;
            if (t.isSkybox()) {
                pi[6] = 2.0;
            }
            pi[7] = iw = this.interpolateW ? w : 1.0;
            pi[12] = vertexData[12] * iw;
            pi[13] = vertexData[13] * iw;
            pi[11] = vertexData[11] * iw;
            if (this.interpolateColor) {
                pi[8] = (vertexData[8] >= 1.0 ? 1.0 : vertexData[8]) * iw;
                pi[9] = (vertexData[9] >= 1.0 ? 1.0 : vertexData[9]) * iw;
                pi[10] = (vertexData[10] >= 1.0 ? 1.0 : vertexData[10]) * iw;
            }
            if (!this.interpolateNormals) continue;
            pi[14] = vertexData[14] * iw;
            pi[15] = vertexData[15] * iw;
            pi[16] = vertexData[16] * iw;
        }
        if (!this.interpolateColor) {
            double[] vertexData = t.getCenter();
            this.rrr.value = Math.min(1.0, vertexData[8]);
            this.ggg.value = Math.min(1.0, vertexData[9]);
            this.bbb.value = Math.min(1.0, vertexData[10]);
            this.aaa.value = Math.min(1.0, vertexData[11]);
        }
        this.www.value = this.polygon[0][7];
        this.interpolateA = t.isInterpolateAlpha();
        if (!this.interpolateA) {
            this.aaa.value = 1.0;
        }
        if (outline) {
            this.transparency = 0.0;
            for (int j = 0; j < 2; ++j) {
                this.line(this.polygon[j][4], this.polygon[j][5], this.polygon[j][6], this.polygon[j + 1][4], this.polygon[j + 1][5], this.polygon[j + 1][6], this.xmin, this.xmax, this.ymin, this.ymax);
            }
            this.line(this.polygon[2][4], this.polygon[2][5], this.polygon[2][6], this.polygon[0][4], this.polygon[0][5], this.polygon[0][6], this.xmin, this.xmax, this.ymin, this.ymax);
        }
        this.scanPolygon(this.polygon);
    }

    private final void scanPolygon(double[][] p) {
        int ry;
        int top = 0;
        double minY = Double.MAX_VALUE;
        for (int i = 0; i < 3; ++i) {
            if (!(p[i][5] < minY)) continue;
            minY = p[i][5];
            top = i;
        }
        int li = top;
        int ri = top;
        int rem = 3;
        int y = (int)Math.ceil(minY - 0.5);
        int ly = ry = y - 1;
        while (rem > 0) {
            int i = li;
            while (ly <= y && rem > 0) {
                --rem;
                li = i--;
                if (i < 0) {
                    i = 2;
                }
                ly = (int)Math.floor(p[i][5] + 0.5);
            }
            if (i != li) {
                this.makeYIncrement(p[li], p[i], y, true);
                li = i;
            }
            i = ri;
            while (ry <= y && rem > 0) {
                --rem;
                ri = i++;
                if (i >= 3) {
                    i = 0;
                }
                ry = (int)Math.floor(p[i][5] + 0.5);
            }
            if (i != ri) {
                this.makeYIncrement(p[ri], p[i], y, false);
                ri = i;
            }
            while (y < ly && y < ry) {
                if (y >= this.ymin && y < this.ymax) {
                    this.scanline(y);
                }
                ++y;
                this.xxx.incrementY();
                if (this.interpolateY) {
                    this.yyy.incrementY();
                }
                this.zzz.incrementY();
                if (this.interpolateW) {
                    this.www.incrementY();
                }
                if (this.interpolateColor) {
                    this.rrr.incrementY();
                    this.ggg.incrementY();
                    this.bbb.incrementY();
                }
                if (this.interpolateA) {
                    this.aaa.incrementY();
                }
                if (this.interpolateUV) {
                    this.uuu.incrementY();
                    this.vvv.incrementY();
                }
                if (!this.interpolateNormals) continue;
                this.nnx.incrementY();
                this.nny.incrementY();
                this.nnz.incrementY();
            }
        }
    }

    private final void makeYIncrement(double[] p1, double[] p2, int y, boolean left) {
        double p1y = p1[5];
        double dy = 1.0 / Math.max(1.0, p2[5] - p1y);
        double frac = (double)y + 0.5 - p1y;
        if (left) {
            this.xxx.makeLeftYIncrement(p1[4], p2[4], dy, frac);
            if (this.interpolateY) {
                this.yyy.makeLeftYIncrement(p1[5], p2[5], dy, frac);
            }
            this.zzz.makeLeftYIncrement(p1[6], p2[6], dy, frac);
            if (this.interpolateW) {
                this.www.makeLeftYIncrement(p1[7], p2[7], dy, frac);
            }
            if (this.interpolateColor) {
                this.rrr.makeLeftYIncrement(p1[8], p2[8], dy, frac);
                this.ggg.makeLeftYIncrement(p1[9], p2[9], dy, frac);
                this.bbb.makeLeftYIncrement(p1[10], p2[10], dy, frac);
            }
            if (this.interpolateA) {
                this.aaa.makeLeftYIncrement(p1[11], p2[11], dy, frac);
            }
            if (this.interpolateUV) {
                this.uuu.makeLeftYIncrement(p1[12], p2[12], dy, frac);
                this.vvv.makeLeftYIncrement(p1[13], p2[13], dy, frac);
            }
            if (this.interpolateNormals) {
                this.nnx.makeLeftYIncrement(p1[14], p2[14], dy, frac);
                this.nny.makeLeftYIncrement(p1[15], p2[15], dy, frac);
                this.nnz.makeLeftYIncrement(p1[16], p2[16], dy, frac);
            }
        } else {
            this.xxx.makeRightYIncrement(p1[4], p2[4], dy, frac);
            if (this.interpolateY) {
                this.yyy.makeRightYIncrement(p1[5], p2[5], dy, frac);
            }
            this.zzz.makeRightYIncrement(p1[6], p2[6], dy, frac);
            if (this.interpolateW) {
                this.www.makeRightYIncrement(p1[7], p2[7], dy, frac);
            }
            if (this.interpolateColor) {
                this.rrr.makeRightYIncrement(p1[8], p2[8], dy, frac);
                this.ggg.makeRightYIncrement(p1[9], p2[9], dy, frac);
                this.bbb.makeRightYIncrement(p1[10], p2[10], dy, frac);
            }
            if (this.interpolateA) {
                this.aaa.makeRightYIncrement(p1[11], p2[11], dy, frac);
            }
            if (this.interpolateUV) {
                this.uuu.makeRightYIncrement(p1[12], p2[12], dy, frac);
                this.vvv.makeRightYIncrement(p1[13], p2[13], dy, frac);
            }
            if (this.interpolateNormals) {
                this.nnx.makeRightYIncrement(p1[14], p2[14], dy, frac);
                this.nny.makeRightYIncrement(p1[15], p2[15], dy, frac);
                this.nnz.makeRightYIncrement(p1[16], p2[16], dy, frac);
            }
        }
    }

    private final void scanline(int y) {
        int rx;
        int lx;
        boolean lr;
        double l = this.xxx.leftValue;
        double r = this.xxx.rightValue;
        boolean bl = lr = l < r;
        if (lr) {
            lx = (int)Math.ceil(l - 0.5);
            rx = (int)Math.floor(r - 0.5);
            if (lx < this.xmin) {
                lx = this.xmin;
            }
            if (rx >= this.xmax) {
                rx = this.xmax - 1;
            }
            if (lx > rx) {
                return;
            }
        } else {
            lx = (int)Math.floor(l - 0.5);
            rx = (int)Math.ceil(r - 0.5);
            if (rx < this.xmin) {
                rx = this.xmin;
            }
            if (lx >= this.xmax) {
                lx = this.xmax - 1;
            }
            if (rx > lx) {
                return;
            }
        }
        this.makeXincrement(lx);
        int inc = lr ? 1 : -1;
        int posOff = y * this.w;
        this.colorize(lx + posOff);
        int x = lx + inc + posOff;
        while (lr ? x <= rx + posOff : x >= rx + posOff) {
            if (this.interpolateFullX) {
                this.xxx.incrementX();
            }
            if (this.interpolateY) {
                this.yyy.incrementX();
            }
            this.zzz.incrementX();
            if (this.interpolateW) {
                this.www.incrementX();
            }
            if (this.interpolateColor) {
                this.rrr.incrementX();
                this.ggg.incrementX();
                this.bbb.incrementX();
            }
            if (this.interpolateA) {
                this.aaa.incrementX();
            }
            if (this.interpolateUV) {
                this.uuu.incrementX();
                this.vvv.incrementX();
            }
            if (this.interpolateNormals) {
                this.nnx.incrementX();
                this.nny.incrementX();
                this.nnz.incrementX();
            }
            this.colorize(x);
            x += inc;
        }
    }

    private final void blur(int i, int j) {
        int k = i + j;
        if (k < 0 | k >= this.zBuffer.length) {
            return;
        }
        if (this.zBuffer[k] - this.zBuffer[i] > 0.0) {
            int sample = this.pixels[i];
            int sample2 = this.pixels[k];
            int sb = sample & 0xFF;
            int sg = sample >> 8 & 0xFF;
            int sr = sample >> 16 & 0xFF;
            int sa = sample >> 24 & 0xFF;
            int sb2 = sample2 & 0xFF;
            int sg2 = sample2 >> 8 & 0xFF;
            int sr2 = sample2 >> 16 & 0xFF;
            int sa2 = sample2 >> 24 & 0xFF;
            int a = (sa2 + sa) / 2;
            int r = (sr2 + sr) / 2;
            int g = (sg2 + sg) / 2;
            int b = (sb2 + sb) / 2;
            this.pixels[k] = a << 24 | r << 16 | g << 8 | b;
        }
    }

    private final void makeXincrement(int leftBound) {
        double dx = 1.0 / Math.max(1.0, Math.abs(this.xxx.rightValue - this.xxx.leftValue));
        double frac = Math.abs((double)leftBound + 0.5 - this.xxx.leftValue);
        if (this.interpolateFullX) {
            this.xxx.makeXIncrement(dx, frac);
        }
        if (this.interpolateY) {
            this.yyy.makeXIncrement(dx, frac);
        }
        this.zzz.makeXIncrement(dx, frac);
        if (this.interpolateW) {
            this.www.makeXIncrement(dx, frac);
        }
        if (this.interpolateColor) {
            this.rrr.makeXIncrement(dx, frac);
            this.ggg.makeXIncrement(dx, frac);
            this.bbb.makeXIncrement(dx, frac);
        }
        if (this.interpolateA) {
            this.aaa.makeXIncrement(dx, frac);
        }
        if (this.interpolateUV) {
            this.uuu.makeXIncrement(dx, frac);
            this.vvv.makeXIncrement(dx, frac);
        }
        if (this.interpolateNormals) {
            this.nnx.makeXIncrement(dx, frac);
            this.nny.makeXIncrement(dx, frac);
            this.nnz.makeXIncrement(dx, frac);
        }
    }

    private final void colorize(int pos) {
        double z = this.zzz.value;
        if (z >= this.zBuffer[pos]) {
            return;
        }
        double ww = this.www.value;
        double factor = this.interpolateColor ? 255.0 / ww : 255.0;
        double r = this.rrr.value * factor;
        double g = this.ggg.value * factor;
        double b = this.bbb.value * factor;
        double omt = 1.0 - this.transparency;
        if (this.interpolateA) {
            omt = omt * this.aaa.value / ww;
        }
        if (this.interpolateUV) {
            double WW = 1.0 / ww;
            this.color[0] = r;
            this.color[1] = g;
            this.color[2] = b;
            this.color[3] = omt * 255.0;
            if (this.interpolateNormals) {
                this.texture.getColor(this.uuu.value * WW, this.vvv.value * WW, this.nnx.value * WW, this.nny.value * WW, this.nnz.value * WW, pos % this.w, pos / this.w, this.color);
            } else {
                this.texture.getColor(this.uuu.value * WW, this.vvv.value * WW, 0.0, 0.0, 0.0, pos % this.w, pos / this.w, this.color);
            }
            omt = this.color[3] / 255.0;
            r = this.color[0];
            g = this.color[1];
            b = this.color[2];
        }
        if (omt <= 0.0) {
            return;
        }
        if (this.transparencyEnabled && omt < 1.0) {
            int sample = this.pixels[pos];
            double t = 1.0 - omt;
            int sb = sample & 0xFF;
            int sg = sample >> 8 & 0xFF;
            int sr = sample >> 16 & 0xFF;
            r = r * omt + t * (double)sr;
            g = g * omt + t * (double)sg;
            b = b * omt + t * (double)sb;
        }
        this.pixels[pos] = 0xFF000000 | (int)r << 16 | (int)g << 8 | (int)b;
        this.zBuffer[pos] = z;
    }

    private final void line(double x1, double y1, double z1, double x2, double y2, double z2, int xmin, int xmax, int ymin, int ymax) {
        double dirX = x2 - x1;
        double dirY = y2 - y1;
        double dirZ = z2 - z1;
        double l = dirX * dirX + dirY * dirY;
        if ((l = Math.sqrt(l) / 4.0) < 1.0) {
            return;
        }
        double zz1 = z1 - (dirZ /= l) + -1.0E-4;
        double zz2 = z2 + dirZ + -1.0E-4;
        this.scanPolygon(new double[][]{{x1 - (dirX /= l) - (dirY /= l), y1 - dirY + dirX, zz1, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {x1 - dirX + dirY, y1 - dirY - dirX, zz1, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {x2 + dirX + dirY, y2 + dirY - dirX, zz2, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}});
        this.scanPolygon(new double[][]{{x1 - dirX - dirY, y1 - dirY + dirX, zz1, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {x2 + dirX + dirY, y2 + dirY - dirX, zz2, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {x2 + dirX - dirY, y2 + dirY + dirX, zz2, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}});
    }

    public final void setWindow(int xmin, int xmax, int ymin, int ymax) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
        int nw = xmax - xmin;
        int nh = ymax - ymin;
        if (nw != this.w || nh != this.h) {
            this.w = nw;
            this.h = nh;
            int numPx = this.w * this.h;
            this.zBuffer = new double[numPx];
            if (this.backgroundArray != null) {
                this.makeBackgroundArray();
            }
        }
    }

    public final void setSize(double width, double height) {
        this.wh = width / 2.0;
        this.hh = height / 2.0;
        this.minDim = Math.min(this.wh, this.hh);
        this.maxDim = Math.max(this.wh, this.hh);
    }

    public void setBackground(int argb) {
        this.background = argb;
    }

    public int getBackground() {
        return this.background;
    }

    public final void clear(boolean clearBackground) {
        Arrays.fill(this.zBuffer, Double.MAX_VALUE);
        if (clearBackground) {
            if (this.backgroundArray != null) {
                System.arraycopy(this.backgroundArray, 0, this.pixels, 0, this.pixels.length);
            } else {
                Arrays.fill(this.pixels, this.background);
            }
        }
    }

    public final void start() {
    }

    public final void stop() {
        if (this.imager != null) {
            this.imager.process(this.pixels, this.zBuffer, this.w, this.h);
        }
    }

    public boolean isInterpolateUV() {
        return this.interpolateUV;
    }

    public void setBackgroundColors(Color[] colors) {
        if (colors == null) {
            this.backgroundArray = null;
            return;
        }
        int lu = colors[0].getRGB();
        int ru = colors[1].getRGB();
        int ld = colors[2].getRGB();
        int rd = colors[3].getRGB();
        if (lu != this.leftupper || ru != this.rightupper || ld != this.leftlower || rd != this.rightlower) {
            this.leftupper = lu;
            this.rightupper = ru;
            this.leftlower = ld;
            this.rightlower = rd;
            this.makeBackgroundArray();
        }
    }

    private void makeBackgroundArray() {
        this.backgroundArray = new int[this.w * this.h];
        for (int i = 0; i < this.w; ++i) {
            double l = (double)i / (double)this.w;
            for (int j = 0; j < this.h; ++j) {
                double m = (double)j / (double)this.h;
                double r = (1.0 - m) * (l * (double)(0xFF & this.leftupper >> 16) + (1.0 - l) * (double)(0xFF & this.rightupper >> 16)) + m * (l * (double)(0xFF & this.leftlower >> 16) + (1.0 - l) * (double)(0xFF & this.rightlower >> 16));
                double g = (1.0 - m) * (l * (double)(0xFF & this.leftupper >> 8) + (1.0 - l) * (double)(0xFF & this.rightupper >> 8)) + m * (l * (double)(0xFF & this.leftlower >> 8) + (1.0 - l) * (double)(0xFF & this.rightlower >> 8));
                double b = (1.0 - m) * (l * (double)(0xFF & this.leftupper >> 0) + (1.0 - l) * (double)(0xFF & this.rightupper >> 0)) + m * (l * (double)(0xFF & this.leftlower >> 0) + (1.0 - l) * (double)(0xFF & this.rightlower >> 0));
                this.backgroundArray[i + this.w * j] = -16777216 + ((int)r << 16) + ((int)g << 8) + (int)b;
            }
        }
    }

    public void setTransparencyEnabled(boolean transparencyEnabled) {
        this.transparencyEnabled = transparencyEnabled;
    }

    public double getMinDim() {
        return 2.0 * this.minDim;
    }

    public static abstract class Colorizer {
        public abstract void colorize(int[] var1, double[] var2, int var3, double[] var4, boolean var5);
    }

    private final class Quantity {
        double leftValue;
        double leftYIncrement;
        double rightValue;
        double rightYIncrement;
        double value;
        double xIncrement;

        Quantity() {
        }

        final void makeXIncrement(double dx, double frac) {
            this.xIncrement = (this.rightValue - this.leftValue) * dx;
            this.value = this.leftValue + this.xIncrement * frac;
        }

        final void makeLeftYIncrement(double start, double end, double dy, double frac) {
            this.leftYIncrement = (end - start) * dy;
            this.leftValue = start + this.leftYIncrement * frac;
        }

        final void makeRightYIncrement(double start, double end, double dy, double frac) {
            this.rightYIncrement = (end - start) * dy;
            this.rightValue = start + this.rightYIncrement * frac;
        }

        final void incrementY() {
            this.leftValue += this.leftYIncrement;
            this.rightValue += this.rightYIncrement;
        }

        final void incrementX() {
            this.value += this.xIncrement;
        }

        public void dump() {
            System.out.println("dump:");
            System.out.println("value      :" + this.value);
            System.out.println("xIncr      :" + this.xIncrement);
            System.out.println("leftValue  :" + this.leftValue);
            System.out.println("leftIncr   :" + this.leftYIncrement);
            System.out.println("rightValue :" + this.rightValue);
            System.out.println("rightIncr  :" + this.rightYIncrement);
        }
    }
}

