/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.soft;

import de.jreality.backends.label.LabelUtility;
import de.jreality.scene.Appearance;
import de.jreality.scene.Cylinder;
import de.jreality.scene.DirectionalLight;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.PointLight;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.Sphere;
import de.jreality.scene.SpotLight;
import de.jreality.scene.Transformation;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.AttributeEntityUtility;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.data.DoubleArrayArray;
import de.jreality.scene.data.IntArray;
import de.jreality.scene.data.IntArrayArray;
import de.jreality.shader.DefaultTextShader;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.ImageData;
import de.jreality.shader.ShaderUtility;
import de.jreality.soft.DefaultPolygonShader;
import de.jreality.soft.DirectionalLightSoft;
import de.jreality.soft.Environment;
import de.jreality.soft.FlatPolygonShader;
import de.jreality.soft.Geometries;
import de.jreality.soft.LineShader;
import de.jreality.soft.PointShader;
import de.jreality.soft.PolygonPipeline;
import de.jreality.soft.PolygonShader;
import de.jreality.soft.ShaderLookup;
import de.jreality.soft.SimpleTexture;
import de.jreality.soft.SpotLightSoft;
import de.jreality.soft.VecMat;
import java.awt.Color;
import java.awt.Font;
import java.util.Arrays;
import java.util.logging.Logger;

public class RenderTraversal
extends SceneGraphVisitor {
    private static final String FACE_SHADER = "polygonShader";
    private boolean shaderUptodate;
    protected Environment environment = new Environment();
    protected EffectiveAppearance eAppearance;
    double[] initialTrafo;
    double[] currentTrafo;
    private Transformation initialTransformation;
    protected LineShader lineShader;
    protected PolygonPipeline pipeline;
    protected PointShader pointShader;
    protected PolygonShader polygonShader;
    protected RenderTraversal reclaimableSubcontext;
    private int[] fni = new int[13];
    private IntArray fnia = new IntArray(this.fni);
    private final SceneGraphComponent labelComp = new SceneGraphComponent();

    public RenderTraversal() {
        this.eAppearance = EffectiveAppearance.create();
    }

    protected RenderTraversal(RenderTraversal parentContext) {
        this.eAppearance = parentContext.eAppearance;
        this.initializeFromParentContext(parentContext);
    }

    public PolygonPipeline getPipeline() {
        return this.pipeline;
    }

    public void setPipeline(PolygonPipeline pipeline) {
        if (this.pipeline != null) {
            this.pipeline.setEnvironment(null);
        }
        this.pipeline = pipeline;
        pipeline.setEnvironment(this.environment);
    }

    protected void initializeFromParentContext(RenderTraversal parentContext) {
        RenderTraversal p = parentContext;
        this.environment = p.environment;
        this.eAppearance = parentContext.eAppearance;
        this.pipeline = p.pipeline;
        this.polygonShader = p.polygonShader;
        this.pipeline.setFaceShader(this.polygonShader);
        this.lineShader = p.lineShader;
        this.pipeline.setLineShader(this.lineShader);
        this.pointShader = p.pointShader;
        this.pipeline.setPointShader(this.pointShader);
        this.shaderUptodate = p.shaderUptodate;
        this.initialTrafo = parentContext.currentTrafo;
        this.currentTrafo = parentContext.currentTrafo;
        this.pipeline.setMatrix(this.currentTrafo);
    }

    public void setInitialTransformation(Transformation initialTransformation) {
        this.initialTransformation = initialTransformation;
        this.environment.setInitialTransformation(initialTransformation);
    }

    RenderTraversal subContext() {
        if (this.reclaimableSubcontext != null) {
            this.reclaimableSubcontext.initializeFromParentContext(this);
            return this.reclaimableSubcontext;
        }
        this.reclaimableSubcontext = new RenderTraversal(this);
        return this.reclaimableSubcontext;
    }

    public void traverse(SceneGraphComponent root) {
        this.environment.removeAll();
        if (this.initialTrafo == null) {
            this.initialTrafo = new double[16];
        }
        if (this.initialTransformation != null) {
            this.initialTransformation.getMatrix(this.initialTrafo);
        } else {
            VecMat.assignIdentity(this.initialTrafo);
        }
        this.currentTrafo = this.initialTrafo;
        this.environment.traverse(root);
        root.accept(this);
        this.pipeline.setMatrix(this.initialTrafo);
    }

    public void visit(SceneGraphComponent c) {
        if (c.isVisible()) {
            c.childrenAccept(this.subContext());
        }
    }

    public void visit(Transformation t) {
        if (this.initialTrafo == this.currentTrafo) {
            this.currentTrafo = new double[16];
        }
        VecMat.copyMatrix(this.initialTrafo, this.currentTrafo);
        VecMat.multiplyFromRight(this.currentTrafo, t.getMatrix());
        this.pipeline.setMatrix(this.currentTrafo);
    }

    public void visit(Appearance app) {
        this.eAppearance = this.eAppearance.create(app);
        this.shaderUptodate = false;
    }

    private void setupShader() {
        String geomShaderName;
        if (!this.eAppearance.getAttribute("geometryShader", "default").equals("default")) {
            Logger.getLogger("de.jreality").warning("unsupported geometry shader");
        }
        if (this.eAppearance.getAttribute(ShaderUtility.nameSpace(geomShaderName = (String)this.eAppearance.getAttribute("geometryShader.name", ""), "showFaces"), true)) {
            PolygonShader fs;
            this.polygonShader = fs = ShaderLookup.getPolygonShaderAttr(this.eAppearance, geomShaderName, FACE_SHADER);
            this.pipeline.setFaceShader(this.polygonShader);
        } else {
            this.polygonShader = null;
            this.pipeline.setFaceShader(null);
        }
        if (this.eAppearance.getAttribute(ShaderUtility.nameSpace(geomShaderName, "showLines"), true)) {
            LineShader ls;
            this.lineShader = ls = ShaderLookup.getLineShaderAttr(this.eAppearance, geomShaderName, "lineShader");
            this.pipeline.setLineShader(this.lineShader);
        } else {
            this.lineShader = null;
            this.pipeline.setLineShader(null);
        }
        if (this.eAppearance.getAttribute(ShaderUtility.nameSpace(geomShaderName, "showPoints"), true)) {
            PointShader ps;
            this.pointShader = ps = ShaderLookup.getPointShaderAttr(this.eAppearance, geomShaderName, "pointShader");
            this.pipeline.setPointShader(this.pointShader);
        } else {
            this.pointShader = null;
            this.pipeline.setPointShader(null);
        }
        this.shaderUptodate = true;
    }

    public void visit(IndexedLineSet g) {
        if (!this.shaderUptodate) {
            this.setupShader();
        }
        DataList dl = g.getEdgeAttributes(Attribute.INDICES);
        if (this.lineShader != null && dl != null) {
            IntArrayArray edgeIndices = dl.toIntArrayArray();
            DoubleArrayArray vertices = g.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray();
            this.pipeline.startGeometry(g);
            int n = edgeIndices.size();
            for (int i = 0; i < n; ++i) {
                IntArray edge = edgeIndices.item(i).toIntArray();
                for (int j = 0; j < edge.getLength() - 1; ++j) {
                    DoubleArray p1 = vertices.item(edge.getValueAt(j)).toDoubleArray();
                    DoubleArray p2 = vertices.item(edge.getValueAt(j + 1)).toDoubleArray();
                    this.pipeline.processPseudoTube(p1, p2);
                }
            }
            if (g.getEdgeAttributes(Attribute.LABELS) != null) {
                Class shaderType = (Class)this.eAppearance.getAttribute(ShaderUtility.nameSpace("lineShader", "textShader"), DefaultTextShader.class);
                DefaultTextShader ts = (DefaultTextShader)AttributeEntityUtility.createAttributeEntity(shaderType, ShaderUtility.nameSpace("lineShader", "textShader"), this.eAppearance);
                Font font = ts.getFont();
                Color c = ts.getDiffuseColor();
                double scale = ts.getScale();
                double[] offset = ts.getOffset();
                int alignment = ts.getAlignment();
                int textdirection = ts.getTextdirection();
                this.renderLabels(scale, offset, alignment, textdirection, LabelUtility.createEdgeImages(g, font, c), g.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray(), g.getEdgeAttributes(Attribute.INDICES).toIntArrayArray());
            }
        }
        this.visit((PointSet)g);
    }

    public void visit(IndexedFaceSet ifs) {
        if (!this.shaderUptodate) {
            this.setupShader();
        }
        if (this.polygonShader != null) {
            DataList indices = ifs.getFaceAttributes(Attribute.INDICES);
            if (indices != null) {
                DoubleArrayArray points = ifs.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray();
                DoubleArrayArray normals = null;
                DataList vndl = ifs.getVertexAttributes(Attribute.NORMALS);
                if (vndl != null) {
                    normals = vndl.toDoubleArrayArray();
                }
                DataList texCoords = ifs.getVertexAttributes(Attribute.TEXTURE_COORDINATES);
                this.pipeline.startGeometry(ifs);
                if (normals == null || this.polygonShader instanceof FlatPolygonShader) {
                    DoubleArrayArray faceNormals = null;
                    DataList fndl = ifs.getFaceAttributes(Attribute.NORMALS);
                    if (fndl != null) {
                        faceNormals = fndl.toDoubleArrayArray();
                    }
                    for (int i = 0; i < ifs.getNumFaces(); ++i) {
                        IntArray faceIndices = indices.item(i).toIntArray();
                        Arrays.fill(this.fni, i);
                        this.pipeline.processPolygon(points, faceIndices, faceNormals, this.fnia, texCoords);
                    }
                } else {
                    for (int i = 0; i < ifs.getNumFaces(); ++i) {
                        IntArray faceIndices = indices.item(i).toIntArray();
                        this.pipeline.processPolygon(points, faceIndices, normals, faceIndices, texCoords);
                    }
                }
            }
            if (ifs.getEdgeAttributes(Attribute.LABELS) != null) {
                Class shaderType = (Class)this.eAppearance.getAttribute(ShaderUtility.nameSpace(FACE_SHADER, "textShader"), DefaultTextShader.class);
                DefaultTextShader ts = (DefaultTextShader)AttributeEntityUtility.createAttributeEntity(shaderType, ShaderUtility.nameSpace(FACE_SHADER, "textShader"), this.eAppearance);
                Font font = ts.getFont();
                Color c = ts.getDiffuseColor();
                double scale = ts.getScale();
                double[] offset = ts.getOffset();
                int alignment = ts.getAlignment();
                int textdirection = ts.getTextdirection();
                this.renderLabels(scale, offset, alignment, textdirection, LabelUtility.createFaceImages(ifs, font, c), ifs.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray(), ifs.getFaceAttributes(Attribute.INDICES).toIntArrayArray());
            }
        }
        this.visit((IndexedLineSet)ifs);
    }

    public void visit(PointSet p) {
        if (!this.shaderUptodate) {
            this.setupShader();
        }
        DoubleArrayArray a = null;
        int n = p.getNumPoints();
        if (this.pointShader != null) {
            a = p.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray();
            if (a == null) {
                return;
            }
            this.pipeline.startGeometry(p);
            for (int i = 0; i < n; ++i) {
                this.pipeline.processPoint(a, i);
            }
            if (p.getVertexAttributes(Attribute.LABELS) != null) {
                Class shaderType = (Class)this.eAppearance.getAttribute(ShaderUtility.nameSpace("pointShader", "textShader"), DefaultTextShader.class);
                DefaultTextShader ts = (DefaultTextShader)AttributeEntityUtility.createAttributeEntity(shaderType, ShaderUtility.nameSpace("pointShader", "textShader"), this.eAppearance);
                Font font = ts.getFont();
                Color c = ts.getDiffuseColor();
                double scale = ts.getScale();
                double[] offset = ts.getOffset();
                int alignment = ts.getAlignment();
                int textdirection = ts.getTextdirection();
                this.renderLabels(scale, offset, alignment, textdirection, LabelUtility.createPointImages(p, font, c), a, null);
            }
        }
    }

    private void renderLabels(double scale, double[] offset, int alignment, int textdirection, ImageData[] imgs, DoubleArrayArray vertices, IntArrayArray indices) {
        if (imgs == null) {
            return;
        }
        double[] storeMatrix = (double[])this.currentTrafo.clone();
        PolygonShader storePS = this.polygonShader;
        PointShader storePtS = this.pointShader;
        LineShader storeLS = this.lineShader;
        DefaultPolygonShader labelShader = new DefaultPolygonShader();
        this.polygonShader = labelShader;
        this.pipeline.setFaceShader(this.polygonShader);
        this.pointShader = null;
        this.pipeline.setPointShader(null);
        this.lineShader = null;
        this.pipeline.setLineShader(null);
        EffectiveAppearance storeEA = this.eAppearance;
        this.eAppearance = EffectiveAppearance.create();
        double[] m = new double[16];
        VecMat.invert(this.currentTrafo, m);
        int max = imgs.length;
        for (int i = 0; i < max; ++i) {
            ImageData img = imgs[i];
            SceneGraphComponent sgc = LabelUtility.sceneGraphForLabel(this.labelComp, (double)img.getWidth() * scale, (double)img.getHeight() * scale, offset, alignment, textdirection, m, LabelUtility.positionFor(i, vertices, indices));
            labelShader = new DefaultPolygonShader();
            labelShader.texture = new SimpleTexture(img);
            this.polygonShader = labelShader;
            this.pipeline.setFaceShader(this.polygonShader);
            sgc.accept(this);
        }
        this.polygonShader = storePS;
        this.pipeline.setFaceShader(this.polygonShader);
        this.pointShader = storePtS;
        this.pipeline.setPointShader(this.pointShader);
        this.lineShader = storeLS;
        this.pipeline.setLineShader(this.lineShader);
        this.eAppearance = storeEA;
        this.currentTrafo = storeMatrix;
        this.pipeline.setMatrix(storeMatrix);
    }

    public void visit(Sphere s) {
        if (!this.shaderUptodate) {
            this.setupShader();
        }
        this.pipeline.startGeometry(s);
        Geometries.unitSphere().apply(this.pipeline);
    }

    public void visit(Cylinder c) {
        if (!this.shaderUptodate) {
            this.setupShader();
        }
        this.pipeline.startGeometry(c);
        Geometries.cylinder().apply(this.pipeline);
    }

    public void visit(DirectionalLight l) {
        super.visit(l);
        if (l.isGlobal()) {
            return;
        }
        float[] color = l.getColor().getRGBColorComponents(null);
        double[] direction = new double[3];
        VecMat.transformNormal(this.currentTrafo, 0.0, 0.0, 1.0, direction);
        VecMat.normalize(direction);
        this.environment.addDirectionalLight(new DirectionalLightSoft(color[0], color[1], color[2], l.getIntensity(), direction));
    }

    public void visit(PointLight l) {
        super.visit(l);
        if (l.isGlobal()) {
            return;
        }
        float[] color = l.getColor().getRGBColorComponents(null);
        double[] direction = new double[3];
        VecMat.transformNormal(this.currentTrafo, 0.0, 0.0, -1.0, direction);
        VecMat.normalize(direction);
        double[] src = new double[3];
        VecMat.transform(this.currentTrafo, 0.0, 0.0, 0.0, src);
        this.environment.addSpotLight(new SpotLightSoft(color[0], color[1], color[2], l.getIntensity(), direction, src, Math.PI, 0.0, l.getFalloffA0(), l.getFalloffA1(), l.getFalloffA2()));
    }

    public void visit(SpotLight l) {
        if (l.isGlobal()) {
            return;
        }
        float[] color = l.getColor().getRGBColorComponents(null);
        double[] direction = new double[3];
        VecMat.transformNormal(this.currentTrafo, 0.0, 0.0, -1.0, direction);
        VecMat.normalize(direction);
        double[] src = new double[3];
        VecMat.transform(this.currentTrafo, 0.0, 0.0, 0.0, src);
        this.environment.addSpotLight(new SpotLightSoft(color[0], color[1], color[2], l.getIntensity(), direction, src, l.getConeAngle(), l.getConeDeltaAngle(), l.getFalloffA0(), l.getFalloffA1(), l.getFalloffA2()));
    }
}

