/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.soft;

import de.jreality.soft.Polygon;
import de.jreality.soft.PolygonRasterizer;
import de.jreality.soft.SkyboxPolygonShader;
import de.jreality.soft.Texture;

public abstract class ModularDoublePolygonRasterizer
implements PolygonRasterizer {
    private int xmin = 0;
    private int xmax = 0;
    private int ymin = 0;
    private int ymax = 0;
    private double wh;
    private double hh;
    private double mh;
    private int pLength = 0;
    private double[][] polygon = new double[Polygon.MAXPOLYVERTEX][13];
    protected double transparency = 0.0;
    protected double oneMinusTransparency = 255.0;
    private Texture texture = null;
    private boolean interpolateColor = true;
    private boolean interpolateTexture = false;
    private static final boolean correctInterpolation = false;
    private double alsx;
    private double alsy;
    private double alsz;
    private double alr;
    private double alg;
    private double alb;
    private double alu;
    private double alv;
    private double alw;
    private double adlsx;
    private double adlsy;
    private double adlsz;
    private double adlr;
    private double adlg;
    private double adlb;
    private double adlu;
    private double adlv;
    private double adlw;
    private double arsx;
    private double arsy;
    private double arsz;
    private double arr;
    private double arg;
    private double arb;
    private double aru;
    private double arv;
    private double arw;
    private double adrsx;
    private double adrsy;
    private double adrsz;
    private double adrr;
    private double adrg;
    private double adrb;
    private double adru;
    private double adrv;
    private double adrw;
    protected double apsx;
    protected double apsy;
    protected double apsz;
    protected double apr;
    protected double apg;
    protected double apb;
    protected double apu;
    protected double apv;
    protected double apw;
    private double adpsx;
    private double adpsy;
    private double adpsz;
    private double adpr;
    private double adpg;
    private double adpb;
    private double adpu;
    private double adpv;
    private double adpw;
    private int[] color = new int[4];
    private static final double ZEPS = -1.0E-4;

    protected abstract void setPixel(int var1, int var2, double var3, double var5, double var7, double var9, double var11);

    public final void renderPolygon(Polygon p, double[] vertexData, boolean outline) {
        this.transparency = p.getShader().getVertexShader().getTransparency();
        this.oneMinusTransparency = 1.0 - this.transparency;
        this.pLength = p.length;
        for (int i = 0; i < this.pLength; ++i) {
            int pos = p.vertices[i];
            double[] pi = this.polygon[i];
            double w = 1.0 / vertexData[pos + 3];
            double wxy = w * this.mh;
            pi[0] = this.wh + vertexData[pos + 0] * wxy;
            pi[1] = this.hh - vertexData[pos + 1] * wxy;
            pi[2] = vertexData[pos + 2] * w;
            if (p.getShader() instanceof SkyboxPolygonShader) {
                pi[2] = 1.0;
            }
            this.interpolateColor = p.getShader().interpolateColor();
            pi[8] = vertexData[pos + 8];
            pi[9] = vertexData[pos + 9];
            if (this.transparency == 0.0) {
                pi[4] = vertexData[pos + 4] > 1.0 ? 255.0 : 255.0 * vertexData[pos + 4];
                pi[5] = vertexData[pos + 5] > 1.0 ? 255.0 : 255.0 * vertexData[pos + 5];
                pi[6] = vertexData[pos + 6] > 1.0 ? 255.0 : 255.0 * vertexData[pos + 6];
                continue;
            }
            pi[4] = this.oneMinusTransparency * (vertexData[pos + 4] > 1.0 ? 255.0 : 255.0 * vertexData[pos + 4]);
            pi[5] = this.oneMinusTransparency * (vertexData[pos + 5] > 1.0 ? 255.0 : 255.0 * vertexData[pos + 5]);
            pi[6] = this.oneMinusTransparency * (vertexData[pos + 6] > 1.0 ? 255.0 : 255.0 * vertexData[pos + 6]);
        }
        if (outline) {
            this.transparency = 0.0;
            for (int j = 0; j < this.pLength - 1; ++j) {
                this.line(this.polygon[j][0], this.polygon[j][1], this.polygon[j][2], this.polygon[j + 1][0], this.polygon[j + 1][1], this.polygon[j + 1][2], this.xmin, this.xmax, this.ymin, this.ymax);
            }
            this.line(this.polygon[this.pLength - 1][0], this.polygon[this.pLength - 1][1], this.polygon[this.pLength - 1][2], this.polygon[0][0], this.polygon[0][1], this.polygon[0][2], this.xmin, this.xmax, this.ymin, this.ymax);
        }
        this.transparency = p.getShader().getVertexShader().getTransparency();
        this.texture = p.getShader().getTexture();
        this.interpolateColor = p.getShader().interpolateColor();
        this.interpolateTexture = this.texture != null;
        this.scanPoly(this.polygon, this.pLength, this.xmin, this.xmax - 1, this.ymin, this.ymax - 1);
    }

    private final void scanPoly(double[][] p, int plength, int wxmin, int wxmax, int wymin, int wymax) {
        int ry;
        int ri;
        int i;
        int top = 0;
        if (plength > Polygon.MAXPOLYVERTEX) {
            System.err.println("scanPoly: polygon had to many vertices: " + plength);
            return;
        }
        if (!this.interpolateColor) {
            this.apr = p[0][4];
            this.apg = p[0][5];
            this.apb = p[0][6];
        }
        double ymin = Double.MAX_VALUE;
        for (i = 0; i < plength; ++i) {
            if (!(p[i][1] < ymin)) continue;
            ymin = p[i][1];
            top = i;
        }
        int li = ri = top;
        int rem = plength;
        int y = (int)Math.ceil(ymin - 0.5);
        int ly = ry = y - 1;
        while (rem > 0) {
            while (ly <= y && rem > 0) {
                --rem;
                i = li - 1;
                if (i < 0) {
                    i = plength - 1;
                }
                this.incrementalizeYldl(p[li], p[i], y);
                ly = (int)Math.floor(p[i][1] + 0.5);
                li = i;
            }
            while (ry <= y && rem > 0) {
                --rem;
                i = ri + 1;
                if (i >= plength) {
                    i = 0;
                }
                this.incrementalizeYrdr(p[ri], p[i], y);
                ry = (int)Math.floor(p[i][1] + 0.5);
                ri = i;
            }
            while (y < ly && y < ry) {
                if (y >= wymin && y <= wymax) {
                    if (this.alsx <= this.arsx) {
                        this.scanlinelr(y, wxmin, wxmax, wymin, wymax);
                    } else {
                        this.scanlinerl(y, wxmin, wxmax, wymin, wymax);
                    }
                }
                ++y;
                this.incrementldl();
                this.incrementrdr();
            }
        }
    }

    private final void incrementldl() {
        this.alsx += this.adlsx;
        this.alsz += this.adlsz;
        if (this.interpolateColor) {
            this.alr += this.adlr;
            this.alg += this.adlg;
            this.alb += this.adlb;
        }
        if (this.interpolateTexture) {
            this.alu += this.adlu;
            this.alv += this.adlv;
        }
    }

    private final void incrementrdr() {
        this.arsx += this.adrsx;
        this.arsz += this.adrsz;
        if (this.interpolateColor) {
            this.arr += this.adrr;
            this.arg += this.adrg;
            this.arb += this.adrb;
        }
        if (this.interpolateTexture) {
            this.aru += this.adru;
            this.arv += this.adrv;
        }
    }

    private final void incrementpdp() {
        this.apsz += this.adpsz;
        if (this.interpolateColor) {
            this.apr += this.adpr;
            this.apg += this.adpg;
            this.apb += this.adpb;
        }
        if (this.interpolateTexture) {
            this.apu += this.adpu;
            this.apv += this.adpv;
        }
    }

    private final void scanlinelr(int y, int wxmin, int wxmax, int wymin, int wymax) {
        int x = 0;
        int lx = 0;
        int rx = 0;
        lx = (int)Math.ceil(this.alsx - 0.5);
        if (lx < wxmin) {
            lx = wxmin;
        }
        if ((rx = (int)Math.floor(this.arsx - 0.5)) > wxmax) {
            rx = wxmax;
        }
        if (lx > rx) {
            return;
        }
        this.incrementalizeXlrpdp(lx);
        for (x = lx; x <= rx; ++x) {
            this.colorize(x, y);
            this.incrementpdp();
        }
    }

    private final void scanlinerl(int y, int wxmin, int wxmax, int wymin, int wymax) {
        int x = 0;
        int lx = 0;
        int rx = 0;
        lx = (int)Math.ceil(this.arsx - 0.5);
        if (lx < wxmin) {
            lx = wxmin;
        }
        if ((rx = (int)Math.floor(this.alsx - 0.5)) > wxmax) {
            rx = wxmax;
        }
        if (lx > rx) {
            return;
        }
        this.incrementalizeXrlpdp(lx);
        for (x = lx; x <= rx; ++x) {
            this.colorize(x, y);
            this.incrementpdp();
        }
    }

    private final void incrementalizeXrlpdp(int x) {
        double dx = this.alsx - this.arsx;
        if (dx == 0.0) {
            dx = 1.0;
        }
        double dxInv = 1.0 / dx;
        double frac = (double)x + 0.5 - this.arsx;
        this.adpsz = (this.alsz - this.arsz) * dxInv;
        this.apsz = this.arsz + this.adpsz * frac;
        if (this.interpolateColor) {
            this.adpr = (this.alr - this.arr) * dxInv;
            this.apr = this.arr + this.adpr * frac;
            this.adpg = (this.alg - this.arg) * dxInv;
            this.apg = this.arg + this.adpg * frac;
            this.adpb = (this.alb - this.arb) * dxInv;
            this.apb = this.arb + this.adpb * frac;
        }
        if (this.interpolateTexture) {
            this.adpu = (this.alu - this.aru) * dxInv;
            this.apu = this.aru + this.adpu * frac;
            this.adpv = (this.alv - this.arv) * dxInv;
            this.apv = this.arv + this.adpv * frac;
        }
    }

    private final void incrementalizeXlrpdp(int x) {
        double dx = this.arsx - this.alsx;
        if (dx == 0.0) {
            dx = 1.0;
        }
        double frac = (double)x + 0.5 - this.alsx;
        double dxInv = 1.0 / dx;
        this.adpsz = (this.arsz - this.alsz) * dxInv;
        this.apsz = this.alsz + this.adpsz * frac;
        if (this.interpolateColor) {
            this.adpr = (this.arr - this.alr) * dxInv;
            this.apr = this.alr + this.adpr * frac;
            this.adpg = (this.arg - this.alg) * dxInv;
            this.apg = this.alg + this.adpg * frac;
            this.adpb = (this.arb - this.alb) * dxInv;
            this.apb = this.alb + this.adpb * frac;
        }
        if (this.interpolateTexture) {
            this.adpu = (this.aru - this.alu) * dxInv;
            this.apu = this.alu + this.adpu * frac;
            this.adpv = (this.arv - this.alv) * dxInv;
            this.apv = this.alv + this.adpv * frac;
        }
    }

    private final void incrementalizeYldl(double[] p1, double[] p2, int y) {
        double dy = p2[1] - p1[1];
        if (dy == 0.0) {
            dy = 1.0;
        }
        double frac = (double)y + 0.5 - p1[1];
        this.adlsx = (p2[0] - p1[0]) / dy;
        this.alsx = p1[0] + this.adlsx * frac;
        this.adlsz = (p2[2] - p1[2]) / dy;
        this.alsz = p1[2] + this.adlsz * frac;
        if (this.interpolateColor) {
            this.adlr = (p2[4] - p1[4]) / dy;
            this.alr = p1[4] + this.adlr * frac;
            this.adlg = (p2[5] - p1[5]) / dy;
            this.alg = p1[5] + this.adlg * frac;
            this.adlb = (p2[6] - p1[6]) / dy;
            this.alb = p1[6] + this.adlb * frac;
        }
        if (this.interpolateTexture) {
            this.adlu = (p2[8] - p1[8]) / dy;
            this.alu = p1[8] + this.adlu * frac;
            this.adlv = (p2[9] - p1[9]) / dy;
            this.alv = p1[9] + this.adlv * frac;
        }
    }

    private final void incrementalizeYrdr(double[] p1, double[] p2, int y) {
        double dy = p2[1] - p1[1];
        if (dy == 0.0) {
            dy = 1.0;
        }
        double frac = (double)y + 0.5 - p1[1];
        this.adrsx = (p2[0] - p1[0]) / dy;
        this.arsx = p1[0] + this.adrsx * frac;
        this.adrsz = (p2[2] - p1[2]) / dy;
        this.arsz = p1[2] + this.adrsz * frac;
        if (this.interpolateColor) {
            this.adrr = (p2[4] - p1[4]) / dy;
            this.arr = p1[4] + this.adrr * frac;
            this.adrg = (p2[5] - p1[5]) / dy;
            this.arg = p1[5] + this.adrg * frac;
            this.adrb = (p2[6] - p1[6]) / dy;
            this.arb = p1[6] + this.adrb * frac;
        }
        if (this.interpolateTexture) {
            this.adru = (p2[8] - p1[8]) / dy;
            this.aru = p1[8] + this.adru * frac;
            this.adrv = (p2[9] - p1[9]) / dy;
            this.arv = p1[9] + this.adrv * frac;
        }
    }

    private final void colorize(int x, int y) {
        if (this.interpolateTexture) {
            this.texture.getColor(this.apu, this.apv, x, y, this.color);
            double t = (double)(0xFF & this.color[3]) / 255.0;
            double d = 0.00392156862745098;
            if (this.color[3] < 255) {
                this.setPixel(x, y, this.apsz, this.apr * ((double)this.color[0] * t) * d, this.apg * ((double)this.color[1] * t) * d, this.apb * ((double)this.color[2] * t) * d, 1.0 - t);
            } else {
                this.setPixel(x, y, this.apsz, this.apr * (double)this.color[0] * d, this.apg * (double)this.color[1] * d, this.apb * (double)this.color[2] * d, this.transparency);
            }
        } else {
            this.setPixel(x, y, this.apsz, this.apr, this.apg, this.apb, this.transparency);
        }
    }

    private final void line(double x1, double y1, double z1, double x2, double y2, double z2, int xmin, int xmax, int ymin, int ymax) {
        double dirX = x2 - x1;
        double dirY = y2 - y1;
        double dirZ = z2 - z1;
        double l = dirX * dirX + dirY * dirY;
        if ((l = Math.sqrt(l)) < 1.0) {
            return;
        }
        double zz1 = z1 - (dirZ /= l) + -1.0E-4;
        double zz2 = z2 + dirZ + -1.0E-4;
        this.interpolateColor = false;
        this.interpolateTexture = false;
        this.scanPoly(new double[][]{{x1 - dirX - (dirY /= l), y1 - dirY + (dirX /= l), zz1, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {x1 - dirX + dirY, y1 - dirY - dirX, zz1, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {x2 + dirX + dirY, y2 + dirY - dirX, zz2, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {x2 + dirX - dirY, y2 + dirY + dirX, zz2, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}}, 4, xmin, xmax - 1, ymin, ymax - 1);
    }

    public void setWindow(int xmin, int xmax, int ymin, int ymax) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
    }

    public void setSize(double width, double height) {
        this.wh = width / 2.0;
        this.hh = height / 2.0;
        this.mh = Math.min(this.wh, this.hh);
    }

    public abstract void setBackground(int var1);
}

