/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.soft;

import de.jreality.scene.Geometry;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.ShaderUtility;
import de.jreality.soft.ConstantVertexShader;
import de.jreality.soft.DefaultVertexShader;
import de.jreality.soft.Environment;
import de.jreality.soft.Polygon;
import de.jreality.soft.PolygonShader;
import de.jreality.soft.ShaderLookup;
import de.jreality.soft.Texture;
import de.jreality.soft.VertexShader;

public class ImplodePolygonShader
implements PolygonShader {
    private VertexShader vertexShader;
    private boolean outline;
    double implodeFactor;
    private boolean interpolateColor;
    private Texture texture;

    public ImplodePolygonShader() {
        this(new DefaultVertexShader(), 0.8, false);
    }

    public ImplodePolygonShader(VertexShader v, double implodeFactor, boolean outline) {
        this.vertexShader = v;
        this.implodeFactor = implodeFactor;
        this.setOutline(outline);
    }

    public final void shadePolygon(Polygon p, double[] vertexData, Environment environment) {
        double centerX = 0.0;
        double centerY = 0.0;
        double centerZ = 0.0;
        for (int i = 0; i < p.length; ++i) {
            int pos = p.vertices[i];
            centerX += vertexData[pos + 0];
            centerY += vertexData[pos + 1];
            centerZ += vertexData[pos + 2];
        }
        double oml = (1.0 - this.implodeFactor) / (double)p.length;
        centerX *= oml;
        centerY *= oml;
        centerZ *= oml;
        for (int i = 0; i < p.length; ++i) {
            int pos = p.vertices[i];
            vertexData[pos + 0] = this.implodeFactor * vertexData[pos + 0] + centerX;
            vertexData[pos + 1] = this.implodeFactor * vertexData[pos + 1] + centerY;
            vertexData[pos + 2] = this.implodeFactor * vertexData[pos + 2] + centerZ;
            this.vertexShader.shadeVertex(vertexData, p.vertices[i], environment);
        }
    }

    public final VertexShader getVertexShader() {
        return this.vertexShader;
    }

    public final void setVertexShader(VertexShader s) {
        if (this.vertexShader != s) {
            this.vertexShader = s;
            this.interpolateColor = !(s instanceof ConstantVertexShader);
        }
    }

    public final boolean interpolateColor() {
        return this.interpolateColor;
    }

    public boolean interpolateAlpha() {
        return this.vertexShader.interpolateAlpha();
    }

    public boolean isOutline() {
        return this.outline;
    }

    public void setOutline(boolean outline) {
        this.outline = outline;
    }

    public void setup(EffectiveAppearance eAppearance, String name) {
        this.outline = eAppearance.getAttribute(ShaderUtility.nameSpace(name, "outline"), this.outline);
        this.implodeFactor = eAppearance.getAttribute(ShaderUtility.nameSpace(name, "implodeFactor"), this.implodeFactor);
        this.setVertexShader(ShaderLookup.getVertexShaderAttr(eAppearance, name, "vertexShader"));
        this.texture = (Texture)eAppearance.getAttribute(ShaderUtility.nameSpace(name, "texture"), null, Texture.class);
    }

    public Texture getTexture() {
        return this.texture;
    }

    public boolean hasTexture() {
        return this.texture != null;
    }

    public void startGeometry(Geometry geom) {
        if (this.vertexShader != null) {
            this.vertexShader.startGeometry(geom);
        }
    }

    public boolean needsSorting() {
        return this.getVertexShader().getTransparency() != 0.0 || this.hasTexture() || this.interpolateAlpha();
    }
}

