/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.shader;

import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.shader.Texture2D;
import de.jtem.beans.ChoiceEditor;
import de.jtem.beans.DoubleEditor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;

public class Texture2DBeanInfo
extends SimpleBeanInfo {
    public PropertyDescriptor[] getPropertyDescriptors() {
        Class<Texture2D> beanClass = Texture2D.class;
        try {
            PropertyDescriptor applyMode = new PropertyDescriptor("applyMode", beanClass);
            applyMode.setPropertyEditorClass(ApplyModeEditor.class);
            PropertyDescriptor image = new PropertyDescriptor("image", beanClass);
            PropertyDescriptor magFilter = new PropertyDescriptor("magFilter", beanClass);
            PropertyDescriptor minFilter = new PropertyDescriptor("minFilter", beanClass);
            PropertyDescriptor blendColor = new PropertyDescriptor("blendColor", beanClass);
            PropertyDescriptor combineMode = new PropertyDescriptor("combineMode", beanClass);
            PropertyDescriptor textureMatrix = new PropertyDescriptor("textureMatrix", beanClass);
            textureMatrix.setPropertyEditorClass(TextureMatrixEditor.class);
            textureMatrix.setDisplayName("scale");
            PropertyDescriptor repeatS = new PropertyDescriptor("repeatS", beanClass);
            repeatS.setPropertyEditorClass(RepeatModeEditor.class);
            PropertyDescriptor repeatT = new PropertyDescriptor("repeatT", beanClass);
            repeatT.setPropertyEditorClass(RepeatModeEditor.class);
            PropertyDescriptor[] rv = new PropertyDescriptor[]{minFilter, magFilter, image, blendColor, textureMatrix, repeatS, repeatT, applyMode, combineMode};
            return rv;
        }
        catch (IntrospectionException e) {
            throw new Error(e.toString());
        }
    }

    public static class TextureMatrixEditor
    extends DoubleEditor {
        private Matrix unit = MatrixBuilder.euclidean().getMatrix();
        private double d = 1.0;

        public TextureMatrixEditor() {
            this.setValue(this.unit);
        }

        public String getAsText() {
            return String.valueOf(this.d);
        }

        public void setAsText(String text) {
            if (text == null) {
                this.setValue(this.unit);
            } else {
                try {
                    this.d = Double.parseDouble(text);
                    this.setValue(MatrixBuilder.euclidean().scale(this.d).getMatrix());
                }
                catch (NumberFormatException nfe) {
                    this.setValue(this.unit);
                }
            }
        }
    }

    public static class RepeatModeEditor
    extends ChoiceEditor {
        protected void defineValuesToStrings() {
            this.valuesToStrings.put(new Integer(10497), "repeat");
            this.valuesToStrings.put(new Integer(10496), "clamp");
            this.valuesToStrings.put(new Integer(33071), "clamp to edge");
        }

        protected String getNameOfNull() {
            return "inherit";
        }
    }

    public static class ApplyModeEditor
    extends ChoiceEditor {
        protected void defineValuesToStrings() {
            this.valuesToStrings.put(new Integer(8448), "modulate");
            this.valuesToStrings.put(new Integer(34160), "combine");
            this.valuesToStrings.put(new Integer(7681), "replace");
            this.valuesToStrings.put(new Integer(8449), "decal");
        }

        protected String getNameOfNull() {
            return "inherit";
        }
    }
}

