/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.tool;

import java.io.Serializable;

public final class AxisState
implements Serializable {
    public static final AxisState PRESSED = new AxisState(Integer.MAX_VALUE);
    public static final AxisState ORIGIN = new AxisState(0);
    private int state;
    private static final int MINUS_PRESSED = -2147483647;

    public AxisState(double value) {
        if (value < -1.0 || value > 1.0) {
            value = value < 0.0 ? -1.0 : 1.0;
        }
        this.state = (int)(value * 2.147483647E9);
    }

    public AxisState(int value) {
        this.state = value;
    }

    public int intValue() {
        return this.state;
    }

    public double doubleValue() {
        return (double)this.state / 2.147483647E9;
    }

    public boolean isPressed() {
        return this.state == Integer.MAX_VALUE || this.state == -2147483647;
    }

    public boolean isReleased() {
        return this.state == 0;
    }

    public String toString() {
        switch (this.state) {
            case 0: {
                return "AxisState=ORIGIN";
            }
            case 0x7FFFFFFF: {
                return "AxisState=PRESSED";
            }
            case -2147483647: {
                return "AxisState=MINUS_PRESSED";
            }
        }
        return "AxisState=" + this.state + " [" + (double)((int)(this.doubleValue() * 100.0)) / 100.0 + "]";
    }
}

