/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.proxy.tree;

import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.event.SceneGraphComponentEvent;
import de.jreality.scene.event.SceneGraphComponentListener;
import de.jreality.scene.proxy.tree.EntityFactory;
import de.jreality.scene.proxy.tree.SceneGraphNodeEntity;
import de.jreality.scene.proxy.tree.SceneProxyTreeBuilder;
import de.jreality.scene.proxy.tree.SceneTreeNode;
import de.jreality.util.LoggingSystem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.logging.Level;

public class UpToDateSceneProxyBuilder
extends SceneProxyTreeBuilder
implements SceneGraphComponentListener {
    private final Object mutex = new Object();
    private IdentityHashMap<SceneGraphNode, SceneGraphNodeEntity> nodeEntityMap = new IdentityHashMap();
    private EntityFactory entityFactory;
    protected final Level loglevel = Level.FINE;
    protected SceneGraphVisitor attatchListeners = new SceneGraphVisitor(){

        public void visit(SceneGraphComponent c) {
            c.addSceneGraphComponentListener(UpToDateSceneProxyBuilder.this);
        }
    };
    protected SceneGraphVisitor detatchListeners = new SceneGraphVisitor(){

        public void visit(SceneGraphComponent c) {
            c.removeSceneGraphComponentListener(UpToDateSceneProxyBuilder.this);
        }
    };

    public UpToDateSceneProxyBuilder(SceneGraphComponent root) {
        super(root);
    }

    public SceneTreeNode createProxyTree() {
        if (this.entityFactory == null) {
            this.entityFactory = new EntityFactory();
        }
        return super.createProxyTree();
    }

    protected void postCreate(SceneTreeNode proxy2) {
        SceneGraphNode node = proxy2.getNode();
        SceneGraphNodeEntity sge = this.nodeEntityMap.get(node);
        if (sge == null) {
            sge = this.entityFactory.createEntity(node);
            this.nodeEntityMap.put(node, sge);
            node.accept(this.attatchListeners);
            LoggingSystem.getLogger(this).log(this.loglevel, "adding entity+listener for {0}", node.getName());
        }
        sge.addTreeNode(proxy2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void childAdded(SceneGraphComponentEvent ev) {
        Object object = this.mutex;
        synchronized (object) {
            SceneGraphComponent parent = ev.getSceneGraphComponent();
            SceneGraphNode newChild = ev.getNewChildElement();
            LoggingSystem.getLogger(this).log(this.loglevel, "handling add event: {0} added to {1} [ {2} ]", new Object[]{newChild.getName(), parent.getName(), ev.getSourceNode().getName()});
            SceneGraphNodeEntity sge = this.nodeEntityMap.get(parent);
            if (sge == null) {
                LoggingSystem.getLogger(this).warning("entity for registered component is null -> was disposed by other thread...");
                return;
            }
            if (sge.isEmpty()) {
                throw new IllegalStateException("empty entity node");
            }
            Iterator<SceneTreeNode> i$ = sge.getTreeNodes().iterator();
            while (i$.hasNext()) {
                SceneTreeNode node;
                this.traversal.proxyParent = node = i$.next();
                LoggingSystem.getLogger(this).log(this.loglevel, "attatching child {0} to {1}", new Object[]{newChild.getName(), parent.getName()});
                ev.getNewChildElement().accept(this.traversal);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void childRemoved(SceneGraphComponentEvent ev) {
        Object object = this.mutex;
        synchronized (object) {
            SceneGraphComponent parent = ev.getSceneGraphComponent();
            SceneGraphNode prevChild = ev.getOldChildElement();
            SceneGraphNodeEntity parentEntity = this.nodeEntityMap.get(parent);
            LoggingSystem.getLogger(this).log(this.loglevel, "handling remove event: {0} removed from {1}", new Object[]{prevChild.getName(), parent.getName()});
            if (parentEntity == null) {
                throw new Error("event from unknown container");
            }
            ArrayList<SceneGraphNodeEntity> disposedEntities = new ArrayList<SceneGraphNodeEntity>();
            for (SceneTreeNode node : parentEntity.getTreeNodes()) {
                SceneTreeNode deleted = node.removeChildForNode(prevChild);
                deleted.dispose(disposedEntities);
            }
            for (SceneGraphNodeEntity entity : disposedEntities) {
                this.disposeEntity(entity, true);
            }
        }
    }

    private void disposeEntity(SceneGraphNodeEntity entity, boolean assertEmpty) {
        if (assertEmpty && !entity.isEmpty()) {
            throw new IllegalStateException("not empty");
        }
        LoggingSystem.getLogger(this).log(this.loglevel, "disposing entity+listener for removed child {0}", new Object[]{entity.getNode().getName()});
        this.nodeEntityMap.remove(entity.getNode());
        entity.getNode().accept(this.detatchListeners);
        this.entityFactory.disposeEntity(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void childReplaced(SceneGraphComponentEvent ev) {
        Object object = this.mutex;
        synchronized (object) {
            this.childRemoved(ev);
            this.childAdded(ev);
        }
    }

    public EntityFactory getEntityFactory() {
        return this.entityFactory;
    }

    public void setEntityFactory(EntityFactory ef) {
        if (this.treeRoot != null) {
            throw new IllegalStateException("can't change policy after proxy creation");
        }
        this.entityFactory = ef;
    }

    public void visibilityChanged(SceneGraphComponentEvent ev) {
    }

    public void dispose() {
        SceneGraphVisitor disposeVisitor = new SceneGraphVisitor(){
            final HashSet<SceneGraphNode> encountered = new HashSet();

            public void visit(SceneGraphNode n) {
                if (this.encountered.add(n)) {
                    this.dispose(n);
                }
            }

            public void visit(SceneGraphComponent c) {
                if (this.encountered.add(c)) {
                    this.dispose(c);
                    c.childrenAccept(this);
                }
            }

            private void dispose(SceneGraphNode n) {
                SceneGraphNodeEntity entity = (SceneGraphNodeEntity)UpToDateSceneProxyBuilder.this.nodeEntityMap.get(n);
                UpToDateSceneProxyBuilder.this.disposeEntity(entity, false);
            }
        };
        this.root.accept(disposeVisitor);
    }
}

