/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.proxy.tree;

import de.jreality.scene.Appearance;
import de.jreality.scene.AudioSource;
import de.jreality.scene.Camera;
import de.jreality.scene.Geometry;
import de.jreality.scene.Light;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Transformation;
import de.jreality.scene.proxy.tree.ProxyConnector;
import de.jreality.scene.proxy.tree.SceneGraphNodeEntity;
import de.jreality.util.LoggingSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SceneTreeNode {
    private SceneTreeNode parent = null;
    private SceneGraphNode node;
    private IdentityHashMap<SceneGraphNode, SceneTreeNode> childrenMap = new IdentityHashMap();
    private List<SceneTreeNode> childList = Collections.emptyList();
    private List<SceneTreeNode> childrenRO = Collections.unmodifiableList(this.childList);
    private ProxyConnector connector;
    private Object proxy;
    private SceneGraphNodeEntity entity;
    protected final boolean isComponent;
    private boolean hasTrafo;
    private boolean hasApp;
    private boolean hasCam;
    private boolean hasLight;
    private boolean hasGeom;
    private boolean hasAudio;

    protected SceneTreeNode(SceneGraphNode node) {
        this.node = node;
        this.isComponent = node instanceof SceneGraphComponent;
        if (this.isComponent) {
            this.childList = new ArrayList<SceneTreeNode>(((SceneGraphComponent)node).getChildComponentCount() + 5);
            this.childrenRO = Collections.unmodifiableList(this.childList);
        }
    }

    private void setParent(SceneTreeNode parent) {
        if (this.parent != null) {
            throw new IllegalStateException("parent already set!");
        }
        this.parent = parent;
    }

    public boolean isLeaf() {
        return this.childrenMap.isEmpty();
    }

    public List<SceneTreeNode> getChildren() {
        return this.childrenRO;
    }

    public SceneGraphNode getNode() {
        return this.node;
    }

    public SceneTreeNode getParent() {
        return this.parent;
    }

    public Object getProxy() {
        return this.proxy;
    }

    public void setProxy(Object proxy) {
        this.proxy = proxy;
    }

    SceneTreeNode findNodeForPath(Iterator i) {
        if (!i.hasNext()) {
            return this;
        }
        Object nextSGN = i.next();
        if (!this.isComponent || !this.childrenMap.containsKey(nextSGN)) {
            throw new IllegalStateException("path doesn't match!");
        }
        return this.childrenMap.get(nextSGN).findNodeForPath(i);
    }

    public int addChild(SceneTreeNode child) {
        int idx = 0;
        this.childrenMap.put(child.getNode(), child);
        child.setParent(this);
        if (child.getNode() instanceof SceneGraphComponent) {
            this.childList.add(child);
            idx = this.childList.size() - 1;
        } else {
            SceneGraphNode ch = child.getNode();
            if (ch instanceof Transformation) {
                if (this.hasTrafo) {
                    this.childList.set(idx, child);
                } else {
                    this.childList.add(idx, child);
                }
                this.hasTrafo = true;
            } else if (ch instanceof Appearance) {
                if (this.hasTrafo) {
                    ++idx;
                }
                if (this.hasApp) {
                    this.childList.set(idx, child);
                } else {
                    this.childList.add(idx, child);
                }
                this.hasApp = true;
            } else if (ch instanceof Camera) {
                if (this.hasTrafo) {
                    ++idx;
                }
                if (this.hasApp) {
                    ++idx;
                }
                if (this.hasCam) {
                    this.childList.set(idx, child);
                } else {
                    this.childList.add(idx, child);
                }
                this.hasCam = true;
            } else if (ch instanceof Light) {
                if (this.hasTrafo) {
                    ++idx;
                }
                if (this.hasApp) {
                    ++idx;
                }
                if (this.hasCam) {
                    ++idx;
                }
                if (this.hasLight) {
                    this.childList.set(idx, child);
                } else {
                    this.childList.add(idx, child);
                }
                this.hasLight = true;
            } else if (ch instanceof Geometry) {
                if (this.hasTrafo) {
                    ++idx;
                }
                if (this.hasApp) {
                    ++idx;
                }
                if (this.hasCam) {
                    ++idx;
                }
                if (this.hasLight) {
                    ++idx;
                }
                if (this.hasGeom) {
                    this.childList.set(idx, child);
                } else {
                    this.childList.add(idx, child);
                }
                this.hasGeom = true;
            } else if (ch instanceof AudioSource) {
                if (this.hasTrafo) {
                    ++idx;
                }
                if (this.hasApp) {
                    ++idx;
                }
                if (this.hasCam) {
                    ++idx;
                }
                if (this.hasLight) {
                    ++idx;
                }
                if (this.hasGeom) {
                    ++idx;
                }
                if (this.hasAudio) {
                    this.childList.set(idx, child);
                } else {
                    this.childList.add(idx, child);
                }
                this.hasAudio = true;
            }
        }
        this.connector.add(this.getProxy(), child.getProxy());
        return idx;
    }

    public SceneGraphPath toPath() {
        LinkedList<SceneGraphNode> ll = new LinkedList<SceneGraphNode>();
        ll.add(this.getNode());
        SceneTreeNode n = this;
        while (n.getParent() != null) {
            ll.add(n.getParent().getNode());
            n = n.getParent();
        }
        ArrayList<SceneGraphNode> al = new ArrayList<SceneGraphNode>(ll.size());
        ListIterator litar = ll.listIterator(ll.size());
        int i = 0;
        while (litar.hasPrevious()) {
            al.add(i, (SceneGraphNode)litar.previous());
            ++i;
        }
        return SceneGraphPath.fromList(al);
    }

    void setConnector(ProxyConnector connector) {
        this.connector = connector;
    }

    public SceneGraphNodeEntity getEntity() {
        return this.entity;
    }

    void setEntity(SceneGraphNodeEntity entity) {
        this.entity = entity;
    }

    SceneTreeNode removeChildForNode(SceneGraphNode prevChild) {
        if (!this.childrenMap.containsKey(prevChild)) {
            throw new IllegalStateException("unknown child!");
        }
        SceneTreeNode ret = this.getTreeNodeForChild(prevChild);
        this.removeChild(ret);
        if (prevChild instanceof Transformation) {
            this.hasTrafo = false;
        }
        if (prevChild instanceof Appearance) {
            this.hasApp = false;
        }
        if (prevChild instanceof Camera) {
            this.hasCam = false;
        }
        if (prevChild instanceof Light) {
            this.hasLight = false;
        }
        if (prevChild instanceof Geometry) {
            this.hasGeom = false;
        }
        if (prevChild instanceof AudioSource) {
            this.hasAudio = false;
        }
        return ret;
    }

    protected int removeChild(SceneTreeNode prevChild) {
        int ret = this.childList.indexOf(prevChild);
        SceneTreeNode fromMap = this.childrenMap.remove(prevChild.getNode());
        SceneTreeNode fromList = this.childList.remove(ret);
        assert (fromMap == prevChild && fromList == prevChild);
        return ret;
    }

    public SceneTreeNode getTreeNodeForChild(SceneGraphNode prevChild) {
        SceneTreeNode ret = this.childrenMap.get(prevChild);
        return ret;
    }

    public SceneTreeNode getTransformationTreeNode() {
        if (!this.isComponent) {
            throw new UnsupportedOperationException("no component");
        }
        return this.getTreeNodeForChild(((SceneGraphComponent)this.node).getTransformation());
    }

    public SceneTreeNode getAppearanceTreeNode() {
        if (!this.isComponent) {
            throw new UnsupportedOperationException("no component");
        }
        return this.getTreeNodeForChild(((SceneGraphComponent)this.node).getAppearance());
    }

    public SceneTreeNode getGeometryTreeNode() {
        if (!this.isComponent) {
            throw new UnsupportedOperationException("no component");
        }
        return this.getTreeNodeForChild(((SceneGraphComponent)this.node).getGeometry());
    }

    protected void dispose(ArrayList<SceneGraphNodeEntity> disposedEntities) {
        for (SceneTreeNode node : this.getChildren()) {
            node.dispose(disposedEntities);
        }
        int prevSize = this.getEntity().size();
        this.getEntity().removeTreeNode(this);
        LoggingSystem.getLogger(this).log(Level.FINE, "entity size: prev=" + prevSize + " new=" + this.getEntity().size());
        if (this.getEntity().isEmpty()) {
            disposedEntities.add(this.getEntity());
        }
    }
}

