/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.proxy;

import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.proxy.ProxyFactory;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;

public class SceneProxyBuilder {
    protected IdentityHashMap proxies = new IdentityHashMap();
    ProxyFactory proxyFactory;
    Traversal traversal = new Traversal();

    protected SceneProxyBuilder() {
    }

    public ProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    public void setProxyFactory(ProxyFactory factory) {
        this.proxyFactory = factory;
    }

    protected Object getProxyImpl(SceneGraphNode target) {
        Object proxy = this.proxies.get(target);
        if (proxy == null) {
            target.accept(this.proxyFactory);
            proxy = this.proxyFactory.getProxy();
            this.proxies.put(target, proxy);
        }
        return proxy;
    }

    public void add(Object parentProxy, Object childProxy) {
    }

    public Object createProxyScene(SceneGraphNode node) {
        if (this.proxyFactory == null) {
            throw new IllegalStateException("no proxy factory set");
        }
        boolean traverse = !this.proxies.containsKey(node) && node instanceof SceneGraphComponent;
        Object proxy = this.getProxyImpl(node);
        if (traverse) {
            this.traversal.proxyParent = proxy;
            ((SceneGraphComponent)node).childrenAccept(this.traversal);
        }
        return proxy;
    }

    public Object getProxy(Object local) {
        return this.proxies.get(local);
    }

    public List getProxies(List l) {
        ArrayList ret = new ArrayList(l.size());
        for (int i = 0; i < l.size(); ++i) {
            ret.add(this.proxies.get(l.get(i)));
        }
        System.out.println("[SceneProxyBuilder] converted " + ret.size() + " proxies.");
        return ret;
    }

    public void disposeProxy(SceneGraphComponent root) {
        root.accept(new DisposeTraversal());
    }

    protected void disposeProxyImpl(SceneGraphNode target) {
        this.proxies.remove(target);
    }

    class DisposeTraversal
    extends SceneGraphVisitor {
        Object proxy;
        Object proxyParent;

        DisposeTraversal() {
        }

        public void visit(SceneGraphComponent c) {
            boolean stopTraversing = SceneProxyBuilder.this.proxies.containsKey(c);
            super.visit(c);
            if (stopTraversing) {
                return;
            }
            Object old = this.proxyParent;
            this.proxyParent = this.proxy;
            c.childrenAccept(this);
            this.proxy = this.proxyParent;
            this.proxyParent = old;
        }

        public void visit(SceneGraphNode m) {
            if (SceneProxyBuilder.this.proxies.containsKey(m)) {
                SceneProxyBuilder.this.disposeProxyImpl(m);
            }
        }
    }

    class Traversal
    extends SceneGraphVisitor {
        Object proxy;
        Object proxyParent;

        Traversal() {
        }

        public void visit(SceneGraphComponent c) {
            boolean stopTraversing = SceneProxyBuilder.this.proxies.containsKey(c);
            super.visit(c);
            if (stopTraversing) {
                return;
            }
            Object old = this.proxyParent;
            this.proxyParent = this.proxy;
            c.childrenAccept(this);
            this.proxy = this.proxyParent;
            this.proxyParent = old;
        }

        public void visit(SceneGraphNode m) {
            this.proxy = SceneProxyBuilder.this.getProxyImpl(m);
            SceneProxyBuilder.this.add(this.proxyParent, this.proxy);
        }
    }
}

