/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.pick;

import de.jreality.math.Matrix;
import de.jreality.math.P3;
import de.jreality.math.Pn;
import de.jreality.math.Rn;
import de.jreality.scene.Appearance;
import de.jreality.scene.Camera;
import de.jreality.scene.Cylinder;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.Sphere;
import de.jreality.scene.Viewer;
import de.jreality.scene.pick.AABBTree;
import de.jreality.scene.pick.BruteForcePicking;
import de.jreality.scene.pick.Graphics3D;
import de.jreality.scene.pick.Hit;
import de.jreality.scene.pick.HitFilter;
import de.jreality.scene.pick.PickResult;
import de.jreality.scene.pick.PickSystem;
import de.jreality.util.CameraUtility;
import de.jreality.util.PickUtility;
import de.jreality.util.Secure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AABBPickSystem
implements PickSystem {
    private Impl impl;
    private SceneGraphComponent root;
    private ArrayList<Hit> hits = new ArrayList();
    private HashMap<IndexedFaceSet, AABBTree> aabbTreeExists = new HashMap();
    private HashMap<Geometry, Boolean> isPickableMap = new HashMap();
    private Comparator<Hit> cmp = new Hit.HitComparator();
    private double[] from;
    private double[] to;
    private double radiusFactor = 1.0;
    private int metric;
    static boolean isPortal = false;

    @Override
    public void setSceneRoot(SceneGraphComponent root) {
        this.impl = new Impl();
        this.root = root;
    }

    @Override
    public List<PickResult> computePick(double[] f, double[] t) {
        this.from = (double[])f.clone();
        this.to = (double[])t.clone();
        this.hits.clear();
        if (this.root.getAppearance() != null) {
            Object sig = this.root.getAppearance().getAttribute("metric", Integer.class);
            if (sig instanceof Integer) {
                this.metric = (Integer)sig;
            }
        } else {
            this.metric = 0;
        }
        this.impl.visit();
        if (this.hits.isEmpty()) {
            return Collections.emptyList();
        }
        Collections.sort(this.hits, this.cmp);
        return new ArrayList<PickResult>(this.hits);
    }

    public static void getFrustumInterval(double[] from, double[] to, Viewer viewer) {
        if (!CameraUtility.getCamera(viewer).isPerspective() || isPortal) {
            return;
        }
        double[] c2w = viewer.getCameraPath().getMatrix(null);
        Camera cam = CameraUtility.getCamera(viewer);
        double[] eyeW = Rn.matrixTimesVector(null, c2w, cam.isPerspective() ? P3.originP3 : Pn.zDirectionP3);
        Graphics3D gc = new Graphics3D(viewer);
        double[] w2ndc = gc.getWorldToNDC();
        double[] fromndc = Rn.matrixTimesVector(null, w2ndc, from);
        Pn.dehomogenize(fromndc, fromndc);
        double[] tondc = Rn.matrixTimesVector(null, w2ndc, to);
        Pn.dehomogenize(tondc, tondc);
        double[] v = Rn.subtract(null, tondc, fromndc);
        double zto = v[2];
        tondc = Rn.linearCombination(null, zto, fromndc, 2.0, v);
        double[] ndc2w = gc.getNDCToWorld();
        Pn.dehomogenize(to, Rn.matrixTimesVector(null, ndc2w, tondc));
        double[] weights = P3.barycentricCoordinates(null, from, to, eyeW);
        if (weights[0] * weights[1] > 0.0) {
            Rn.times(to, -1.0, to);
        }
    }

    public static void filterList(HitFilter hf, double[] from, double[] to, List<PickResult> list) {
        ArrayList<PickResult> rejected = new ArrayList<PickResult>();
        for (PickResult h : list) {
            if (hf.accept(from, to, h)) continue;
            rejected.add(h);
        }
        list.removeAll(rejected);
    }

    public void dispose() {
        this.aabbTreeExists.clear();
        this.isPickableMap.clear();
    }

    static {
        String foo = Secure.getProperty("de.jreality.viewerapp.env");
        if (foo != null && foo.indexOf("portal") != -1) {
            isPortal = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Impl
    extends SceneGraphVisitor {
        private Stack<PickInfo> appStack = new Stack();
        private PickInfo currentPI;
        private SceneGraphPath path = new SceneGraphPath();
        private ArrayList<Hit> localHits = new ArrayList();
        private Matrix m = new Matrix();
        private Matrix mInv = new Matrix();
        private Matrix[] matrixStack = new Matrix[256];
        int stackCounter = 0;

        Impl() {
            this.currentPI = new PickInfo(null, null);
            this.appStack.push(this.currentPI);
        }

        @Override
        public void visit(SceneGraphComponent c) {
            if (!c.isVisible() || !c.isPickable()) {
                return;
            }
            PickInfo pickInfo = null;
            if (c.getTransformation() != null) {
                if (this.matrixStack[this.stackCounter + 1] == null) {
                    this.matrixStack[this.stackCounter + 1] = new Matrix();
                }
                Rn.times(this.matrixStack[this.stackCounter + 1].getArray(), this.matrixStack[this.stackCounter].getArray(), c.getTransformation().getMatrix());
                ++this.stackCounter;
                this.m = this.matrixStack[this.stackCounter];
                this.mInv = this.m.getInverse();
            }
            if (c.getAppearance() != null) {
                Object foo = c.getAppearance().getAttribute("pickable");
                if (foo instanceof Boolean && !((Boolean)foo).booleanValue()) {
                    return;
                }
                pickInfo = new PickInfo(this.currentPI, c.getAppearance());
                if (pickInfo.hasNewPickInfo) {
                    this.currentPI = pickInfo;
                    this.appStack.push(this.currentPI);
                }
                if (pickInfo.radiiWorldCoords) {
                    double[] o2w = this.path.getMatrix(null);
                    AABBPickSystem.this.radiusFactor = CameraUtility.getScalingFactor(o2w, pickInfo.metric);
                    AABBPickSystem.this.radiusFactor = 1.0 / AABBPickSystem.this.radiusFactor;
                }
            }
            this.path.push(c);
            c.childrenAccept(this);
            this.path.pop();
            if (c.getAppearance() != null && pickInfo.hasNewPickInfo) {
                this.appStack.pop();
                this.currentPI = (PickInfo)this.appStack.elementAt(this.appStack.size() - 1);
            }
            if (c.getTransformation() != null) {
                --this.stackCounter;
                this.m = this.matrixStack[this.stackCounter];
                this.mInv = this.m.getInverse();
            }
        }

        private boolean isPickable(Geometry g) {
            Boolean boo = (Boolean)AABBPickSystem.this.isPickableMap.get(g);
            if (boo == null) {
                Object o = g.getGeometryAttributes("pickable");
                boo = o == null || !o.equals(Boolean.FALSE);
                AABBPickSystem.this.isPickableMap.put(g, boo);
            }
            return boo;
        }

        public void visit() {
            this.stackCounter = 0;
            this.matrixStack[0] = new Matrix();
            AABBPickSystem.this.aabbTreeExists.clear();
            AABBPickSystem.this.isPickableMap.clear();
            this.path.clear();
            this.visit(AABBPickSystem.this.root);
        }

        @Override
        public void visit(Sphere s) {
            if (!this.currentPI.pickFaces || !this.isPickable(s)) {
                return;
            }
            this.localHits.clear();
            BruteForcePicking.intersectSphere(s, AABBPickSystem.this.metric, this.path, this.m, this.mInv, AABBPickSystem.this.from, AABBPickSystem.this.to, this.localHits);
            this.extractHits(this.localHits);
        }

        @Override
        public void visit(Cylinder c) {
            if (!this.currentPI.pickFaces || !this.isPickable(c)) {
                return;
            }
            this.localHits.clear();
            BruteForcePicking.intersectCylinder(c, AABBPickSystem.this.metric, this.path, this.m, this.mInv, AABBPickSystem.this.from, AABBPickSystem.this.to, this.localHits);
            this.extractHits(this.localHits);
        }

        @Override
        public void visit(IndexedFaceSet ifs) {
            if (!this.isPickable(ifs)) {
                return;
            }
            this.visit((IndexedLineSet)ifs);
            if (!this.currentPI.pickFaces) {
                return;
            }
            AABBTree tree = (AABBTree)AABBPickSystem.this.aabbTreeExists.get(ifs);
            if (tree == null) {
                tree = (AABBTree)ifs.getGeometryAttributes(PickUtility.AABB_TREE);
                if (tree == null) {
                    tree = AABBTree.nullTree;
                }
                AABBPickSystem.this.aabbTreeExists.put(ifs, tree);
            }
            this.localHits.clear();
            if (tree == AABBTree.nullTree) {
                BruteForcePicking.intersectPolygons(ifs, AABBPickSystem.this.metric, this.path, this.m, this.mInv, AABBPickSystem.this.from, AABBPickSystem.this.to, this.localHits);
            } else {
                tree.intersect(ifs, AABBPickSystem.this.metric, this.path, this.m, this.mInv, AABBPickSystem.this.from, AABBPickSystem.this.to, this.localHits);
            }
            this.extractHits(this.localHits);
        }

        @Override
        public void visit(IndexedLineSet ils) {
            if (!this.isPickable(ils)) {
                return;
            }
            this.visit((PointSet)ils);
            if (!this.currentPI.pickEdges) {
                return;
            }
            this.localHits.clear();
            BruteForcePicking.intersectEdges(ils, AABBPickSystem.this.metric, this.path, this.m, this.mInv, AABBPickSystem.this.from, AABBPickSystem.this.to, this.currentPI.tubeRadius * AABBPickSystem.this.radiusFactor, this.localHits);
            this.extractHits(this.localHits);
        }

        @Override
        public void visit(PointSet ps) {
            if (!this.currentPI.pickPoints || !this.isPickable(ps)) {
                return;
            }
            this.localHits.clear();
            BruteForcePicking.intersectPoints(ps, AABBPickSystem.this.metric, this.path, this.m, this.mInv, AABBPickSystem.this.from, AABBPickSystem.this.to, this.currentPI.pointRadius * AABBPickSystem.this.radiusFactor, this.localHits);
            this.extractHits(this.localHits);
        }

        private void extractHits(List<Hit> l) {
            for (Hit h : l) {
                if (h.affineCoordinate < 0.0) continue;
                AABBPickSystem.this.hits.add(h);
            }
        }

        private class PickInfo {
            private boolean pickPoints = true;
            private boolean drawVertices = true;
            private boolean pickEdges = true;
            private boolean drawEdges = true;
            private boolean pickFaces = true;
            private boolean drawFaces = true;
            private boolean radiiWorldCoords = false;
            private boolean hasNewPickInfo = false;
            private double tubeRadius = 0.025;
            private double pointRadius = 0.025;
            int metric;

            PickInfo(PickInfo old, Appearance ap) {
                this.metric = AABBPickSystem.this.metric;
                if (old != null) {
                    this.drawVertices = old.drawVertices;
                    this.drawEdges = old.drawEdges;
                    this.drawFaces = old.drawFaces;
                    this.pickPoints = old.pickPoints;
                    this.pickEdges = old.pickEdges;
                    this.pickFaces = old.pickFaces;
                    this.tubeRadius = old.tubeRadius;
                    this.pointRadius = old.pointRadius;
                    this.metric = old.metric;
                }
                if (ap == null) {
                    return;
                }
                Object foo = ap.getAttribute("showPoints", Boolean.class);
                if (foo != Appearance.INHERITED) {
                    this.hasNewPickInfo = true;
                    this.pickPoints = this.drawVertices = ((Boolean)foo).booleanValue();
                }
                if (this.drawVertices && (foo = ap.getAttribute("pointShader.pickable", Boolean.class)) != Appearance.INHERITED) {
                    this.hasNewPickInfo = true;
                    this.pickPoints = (Boolean)foo;
                }
                if ((foo = ap.getAttribute("showLines", Boolean.class)) != Appearance.INHERITED) {
                    this.hasNewPickInfo = true;
                    this.pickEdges = this.drawEdges = ((Boolean)foo).booleanValue();
                }
                if (this.drawEdges && (foo = ap.getAttribute("lineShader.pickable", Boolean.class)) != Appearance.INHERITED) {
                    this.hasNewPickInfo = true;
                    this.pickEdges = (Boolean)foo;
                }
                if ((foo = ap.getAttribute("showFaces", Boolean.class)) != Appearance.INHERITED) {
                    this.hasNewPickInfo = true;
                    this.pickFaces = this.drawFaces = ((Boolean)foo).booleanValue();
                }
                if (this.drawFaces && (foo = ap.getAttribute("polygonShader.pickable", Boolean.class)) != Appearance.INHERITED) {
                    this.hasNewPickInfo = true;
                    this.pickFaces = (Boolean)foo;
                }
                if ((foo = ap.getAttribute("pointShader.pointRadius", Double.class)) != Appearance.INHERITED) {
                    this.hasNewPickInfo = true;
                    this.pointRadius = (Double)foo;
                } else {
                    foo = ap.getAttribute("pointRadius", Double.class);
                    if (foo != Appearance.INHERITED) {
                        this.hasNewPickInfo = true;
                        this.pointRadius = (Double)foo;
                    }
                }
                foo = ap.getAttribute("lineShader.tubeRadius", Double.class);
                if (foo != Appearance.INHERITED) {
                    this.hasNewPickInfo = true;
                    this.tubeRadius = (Double)foo;
                } else {
                    foo = ap.getAttribute("tubeRadius", Double.class);
                    if (foo != Appearance.INHERITED) {
                        this.hasNewPickInfo = true;
                        this.tubeRadius = (Double)foo;
                    }
                }
                foo = ap.getAttribute("metric", Integer.class);
                if (foo != Appearance.INHERITED) {
                    this.hasNewPickInfo = true;
                    this.metric = (Integer)foo;
                }
                if ((foo = ap.getAttribute("radiiWorldCoordinates", Boolean.class)) != Appearance.INHERITED) {
                    this.hasNewPickInfo = true;
                    this.radiiWorldCoords = (Boolean)foo;
                }
            }

            public String toString() {
                return "Pick vef = " + this.pickPoints + " " + this.pickEdges + " " + this.pickFaces + " " + this.pointRadius + " " + this.tubeRadius;
            }

            public boolean hasNewPickInfo() {
                return this.hasNewPickInfo;
            }
        }
    }
}

