/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.data;

import de.jreality.scene.data.DataItem;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.StorageModel;
import de.jreality.scene.data.StringArray;
import java.io.ObjectStreamException;

final class StringArrayStorage
extends StorageModel {
    StringArrayStorage() {
        super("String[]");
    }

    public Object getAsObject(Object data, int index) {
        String[] a = (String[])data;
        return a == null ? null : a[index];
    }

    public int getLength(Object data) {
        return ((String[])data).length;
    }

    public void setAsObject(Object data, int index, Object value) {
        String[] a = (String[])data;
        a[index] = value.toString();
    }

    public Object create(int size) {
        return new String[size];
    }

    public int getNumberOfDimensions() {
        return 1;
    }

    public int[] getDimensions(int[] dim, int d) {
        return dim;
    }

    public boolean isArray() {
        return true;
    }

    public StorageModel getComponentModel() {
        return StorageModel.ObjectType.STRING;
    }

    public void toStringImpl(Object data, int index, StringBuffer target) {
        String[] a = (String[])data;
        target.append(a[index]);
    }

    public DataList createReadOnly(Object data, int off, int len) {
        return new StringArray((String[])data, off, len);
    }

    void copy(Object from, int srcOff, StorageModel toFmt, Object to, int dstOff, int len) {
        String[] source = (String[])from;
        if (toFmt == this) {
            String[] target = (String[])to;
            int src = srcOff;
            for (int dst = 0; dst < len; ++dst) {
                target[dst + dstOff] = source[src];
                ++src;
            }
        } else {
            super.copy(from, srcOff, toFmt, to, dstOff, len);
        }
    }

    public DataItem item(Object data, int i) {
        final String[] iarray = (String[])data;
        return new DataItem(iarray, i){

            public StorageModel getStorageModel() {
                return StorageModel.ObjectType.STRING;
            }

            public Object get(int arg0) {
                return iarray[this.offset];
            }

            public int size() {
                return 1;
            }
        };
    }

    public StorageModel inlined(int numPerEntry) {
        if (numPerEntry < 1) {
            throw new IllegalArgumentException();
        }
        if (this.inlined != null && this.inlined.length > numPerEntry && this.inlined[numPerEntry] != null) {
            return this.inlined[numPerEntry];
        }
        return new StorageModel.SAI(numPerEntry);
    }

    public StorageModel array(int numPerEntry) {
        if (this.arrayof != null && this.arrayof.length > numPerEntry && this.arrayof[numPerEntry] != null) {
            return this.arrayof[numPerEntry];
        }
        return new StorageModel.SAA(numPerEntry);
    }

    public StorageModel array() {
        StorageModel sm = this.arrayof != null ? this.arrayof[0] : null;
        return sm != null ? sm : new StorageModel.SAA();
    }

    Object readResolve() throws ObjectStreamException {
        return StorageModel.STRING_ARRAY;
    }
}

