/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.data;

import de.jreality.scene.data.DataItem;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.IntArray;
import de.jreality.scene.data.StorageModel;
import java.io.ObjectStreamException;

final class IntArrayStorage
extends StorageModel {
    IntArrayStorage() {
        super("int[]");
    }

    public Object getAsObject(Object data, int index) {
        int[] a = (int[])data;
        return a == null ? null : new Integer(a[index]);
    }

    public int getLength(Object data) {
        return ((int[])data).length;
    }

    public void setAsObject(Object data, int index, Object value) {
        int[] a = (int[])data;
        a[index] = ((Number)value).intValue();
    }

    public Object create(int size) {
        return new int[size];
    }

    public int getNumberOfDimensions() {
        return 1;
    }

    public int[] getDimensions(int[] dim, int d) {
        return dim;
    }

    public boolean isArray() {
        return true;
    }

    public StorageModel getComponentModel() {
        return StorageModel.Primitive.INT;
    }

    public void toStringImpl(Object data, int index, StringBuffer target) {
        int[] a = (int[])data;
        target.append(a[index]);
    }

    public DataList createReadOnly(Object data, int off, int len) {
        return new IntArray((int[])data, off, len);
    }

    void copy(Object from, int srcOff, StorageModel toFmt, Object to, int dstOff, int len) {
        int[] source = (int[])from;
        if (toFmt == this) {
            int[] target = (int[])to;
            int src = srcOff;
            for (int dst = 0; dst < len; ++dst) {
                target[dst + dstOff] = source[src];
                ++src;
            }
        } else if (toFmt == DOUBLE_ARRAY) {
            double[] target = (double[])to;
            int src = srcOff;
            for (int dst = 0; dst < len; ++dst) {
                target[dst + dstOff] = source[src];
                ++src;
            }
        } else {
            super.copy(from, srcOff, toFmt, to, dstOff, len);
        }
    }

    public DataItem item(Object data, int i) {
        final int[] iarray = (int[])data;
        return new DataItem(iarray, i){

            public StorageModel getStorageModel() {
                return StorageModel.Primitive.INT;
            }

            public Object get(int arg0) {
                return new Integer(iarray[this.offset]);
            }

            public int size() {
                return 1;
            }
        };
    }

    public StorageModel inlined(int numPerEntry) {
        if (numPerEntry < 1) {
            throw new IllegalArgumentException();
        }
        if (this.inlined != null && this.inlined.length > numPerEntry && this.inlined[numPerEntry] != null) {
            return this.inlined[numPerEntry];
        }
        return new StorageModel.IAI(numPerEntry);
    }

    public StorageModel array(int numPerEntry) {
        if (this.arrayof != null && this.arrayof.length > numPerEntry && this.arrayof[numPerEntry] != null) {
            return this.arrayof[numPerEntry];
        }
        return new StorageModel.IAA(numPerEntry);
    }

    public StorageModel array() {
        StorageModel sm = this.arrayof != null ? this.arrayof[0] : null;
        return sm != null ? sm : new StorageModel.IAA();
    }

    Object readResolve() throws ObjectStreamException {
        return StorageModel.INT_ARRAY;
    }
}

