/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.data;

import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataItem;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.StorageModel;
import de.jreality.scene.data.WritableDataList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataListSet
implements Serializable {
    private int dataSize;
    protected Map<Attribute, DataList> attr2attrDataList = new HashMap<Attribute, DataList>();
    protected transient Set<Attribute> keySet = Collections.unmodifiableSet(this.attr2attrDataList.keySet());

    public DataListSet(int numDataItems) {
        if (numDataItems < 0) {
            throw new IllegalArgumentException("numDataItems " + numDataItems);
        }
        this.dataSize = numDataItems;
    }

    public void reset(int numDataItems) {
        if (numDataItems < 0) {
            throw new IllegalArgumentException("numDataItems " + numDataItems);
        }
        this.attr2attrDataList.clear();
        this.dataSize = numDataItems;
    }

    public void remove(Attribute a) {
        this.attr2attrDataList.remove(a);
    }

    public WritableDataList addWritable(Attribute a, StorageModel sm) {
        return this.addWritable(a, sm, sm.create(this.dataSize));
    }

    public WritableDataList addWritable(Attribute a, StorageModel sm, Object data) {
        WritableDataList wList = sm.createWritableDataList(data);
        this.attr2attrDataList.put(a, wList);
        return wList;
    }

    public void addReadOnly(Attribute a, StorageModel sm, Object data) {
        if (sm.getLength(data) != this.dataSize) {
            throw new IllegalArgumentException("incompatible sizes");
        }
        this.attr2attrDataList.put(a, sm.createReadOnly(data));
    }

    public boolean containsAttribute(Attribute attr) {
        return this.attr2attrDataList.containsKey(attr);
    }

    public DataList getList(Attribute attr) {
        DataList list = this.attr2attrDataList.get(attr);
        return list != null ? list.readOnlyList() : null;
    }

    public WritableDataList getWritableList(Attribute attr) {
        try {
            return (WritableDataList)this.attr2attrDataList.get(attr);
        }
        catch (ClassCastException ex) {
            throw new IllegalStateException("readOnly");
        }
    }

    public DataItem get(Attribute attr, int index) {
        return this.getList(attr).item(index);
    }

    public Object set(Attribute attr, int index, Object value) {
        return this.getWritableList(attr).set(index, value);
    }

    public String toString() {
        return this.attr2attrDataList.toString();
    }

    public int getListLength() {
        return this.dataSize;
    }

    public int getNumAttributes() {
        return this.attr2attrDataList.size();
    }

    public Set<Attribute> storedAttributes() {
        return this.keySet;
    }

    public DataListSet readOnly() {
        return new RO(this);
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        this.keySet = Collections.unmodifiableSet(this.attr2attrDataList.keySet());
    }

    static final class RO
    extends DataListSet {
        final DataListSet source;

        RO(DataListSet src) {
            super(src.getListLength());
            this.source = src;
            this.attr2attrDataList = Collections.unmodifiableMap(src.attr2attrDataList);
            this.keySet = src.keySet;
        }

        public int getListLength() {
            return this.source.getListLength();
        }

        public WritableDataList getWritableList(Attribute attr) {
            throw new IllegalStateException("readOnly");
        }

        public WritableDataList addWritable(Attribute a, StorageModel sm, Object data) {
            throw new IllegalStateException("readOnly");
        }

        public DataListSet readOnly() {
            return this;
        }
    }
}

