/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.data;

import de.jreality.scene.data.ByteBufferList;
import de.jreality.scene.data.DataItem;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.StorageModel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class ByteBufferStorage
extends StorageModel {
    public static final ByteBufferStorage MODEL = new ByteBufferStorage();

    ByteBufferStorage() {
        super("<buf>");
    }

    Object create(int size) {
        return ByteBuffer.allocateDirect(size).order(ByteOrder.nativeOrder());
    }

    public DataList createReadOnly(Object v, int start, int length) {
        return new ByteBufferList((ByteBuffer)v, start, length);
    }

    void copy(StorageModel fromFmt, Object from, int srcOff, Object to, int dstOff, int len) {
        if (fromFmt == DOUBLE_ARRAY) {
            ((DoubleBuffer)((ByteBuffer)to).asDoubleBuffer().position(dstOff)).put((double[])from, srcOff, len);
        } else if (fromFmt == INT_ARRAY) {
            ((IntBuffer)((ByteBuffer)to).asIntBuffer().position(dstOff)).put((int[])from, srcOff, len);
        } else if (fromFmt instanceof StorageModel.ArrayOf) {
            Object[] array = (Object[])from;
            int sLen = ((StorageModel.ArrayOf)fromFmt).numPerEntry;
            if (sLen == -1) {
                throw new UnsupportedOperationException("inline dynamic size");
            }
            StorageModel csm = fromFmt.getComponentModel();
            int idOff = dstOff * sLen;
            int alen = array.length;
            for (int ix = 0; ix < alen; ++ix) {
                this.copy(csm, array[ix], 0, to, idOff, sLen);
                idOff += sLen;
            }
        } else if (fromFmt instanceof StorageModel.InlinedArray) {
            int sLen = ((StorageModel.InlinedArray)fromFmt).numPerEntry;
            StorageModel csm = fromFmt.getComponentModel();
            this.copy(csm, from, srcOff * sLen, to, dstOff, len * sLen);
        } else {
            super.copy(fromFmt, from, srcOff, to, dstOff, len);
        }
    }

    void copy(Object from, int srcOff, StorageModel toFmt, Object to, int dstOff, int len) {
        if (toFmt == DOUBLE_ARRAY) {
            ((DoubleBuffer)((ByteBuffer)from).asDoubleBuffer().position(srcOff)).get((double[])to, dstOff, len >> 3);
        } else if (toFmt == INT_ARRAY) {
            ((IntBuffer)((ByteBuffer)from).asIntBuffer().position(srcOff)).get((int[])to, dstOff, len >> 2);
        } else if (toFmt instanceof StorageModel.InlinedArray) {
            int sLen = ((StorageModel.InlinedArray)toFmt).numPerEntry;
            StorageModel csm = toFmt.getComponentModel();
            this.copy(from, srcOff, csm, to, dstOff * sLen, len);
        } else if (toFmt instanceof StorageModel.ArrayOf) {
            int factor = 1;
            if (toFmt instanceof StorageModel.DAA) {
                factor = 8;
            }
            if (toFmt instanceof StorageModel.IAA) {
                factor = 4;
            }
            Object[] array = (Object[])to;
            int sLen = ((StorageModel.ArrayOf)toFmt).numPerEntry;
            if (sLen == -1) {
                throw new UnsupportedOperationException("extract dynamic size");
            }
            StorageModel csm = toFmt.getComponentModel();
            int idOff = srcOff * sLen;
            for (Object sub : array) {
                if (sub == null) {
                    sub = array[ix] = csm.create(sLen);
                }
                this.copy(from, idOff, csm, sub, 0, sLen * factor);
                idOff += sLen;
            }
        } else {
            System.err.println("Warning: unhandled format: " + toFmt);
            super.copy(from, srcOff, toFmt, to, dstOff, len);
        }
    }

    static int numBytes(StorageModel fromFmt, Object from, int len) {
        if (len == 0) {
            return 0;
        }
        if (fromFmt == DOUBLE_ARRAY) {
            return len << 3;
        }
        if (fromFmt == INT_ARRAY) {
            return len << 2;
        }
        if (fromFmt instanceof StorageModel.ArrayOf) {
            Object[] array = (Object[])from;
            int sLen = ((StorageModel.ArrayOf)fromFmt).numPerEntry;
            if (sLen == -1) {
                throw new UnsupportedOperationException("inline dynamic size");
            }
            StorageModel csm = fromFmt.getComponentModel();
            return ByteBufferStorage.numBytes(csm, array[0], sLen) * fromFmt.getLength(array);
        }
        if (fromFmt instanceof StorageModel.InlinedArray) {
            int sLen = ((StorageModel.InlinedArray)fromFmt).numPerEntry;
            StorageModel csm = fromFmt.getComponentModel();
            return ByteBufferStorage.numBytes(csm, from, sLen) * fromFmt.getLength(from);
        }
        throw new IllegalStateException("unknown data format " + fromFmt);
    }

    Object getAsObject(Object data, int index) {
        return new Byte(((ByteBuffer)data).get(index));
    }

    public int getLength(Object data) {
        return ((ByteBuffer)data).remaining();
    }

    public DataItem item(Object data, int i) {
        final ByteBuffer darray = (ByteBuffer)data;
        return new DataItem(data, i){

            public StorageModel getStorageModel() {
                return StorageModel.Primitive.DOUBLE;
            }

            public Object get(int arg0) {
                return new Byte(darray.get(this.offset));
            }

            public int size() {
                return 1;
            }
        };
    }

    void exportData(ObjectOutputStream stream, DataList list) throws IOException {
        ByteBuffer bb = (ByteBuffer)list.data;
        bb.position(list.offset).limit(list.length);
        stream.writeInt(list.length);
        WritableByteChannel ch = Channels.newChannel(stream);
        while (bb.hasRemaining()) {
            ch.write(bb);
        }
        bb.position(list.offset).limit(list.length);
    }

    Object importData(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int length = stream.readInt();
        ByteBuffer bb = ByteBufferList.BufferPool.getBuffer(length);
        bb.position(0).limit(length);
        ReadableByteChannel ch = Channels.newChannel(stream);
        while (bb.hasRemaining()) {
            ch.read(bb);
        }
        bb.position(0).limit(length);
        return bb;
    }
}

