/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene;

import de.jreality.scene.Appearance;
import de.jreality.scene.AudioSource;
import de.jreality.scene.Camera;
import de.jreality.scene.Geometry;
import de.jreality.scene.Light;
import de.jreality.scene.SceneGraphLoopException;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.Transformation;
import de.jreality.scene.event.SceneEvent;
import de.jreality.scene.event.SceneGraphComponentEvent;
import de.jreality.scene.event.SceneGraphComponentEventMulticaster;
import de.jreality.scene.event.SceneGraphComponentListener;
import de.jreality.scene.event.ToolEvent;
import de.jreality.scene.event.ToolEventMulticaster;
import de.jreality.scene.event.ToolListener;
import de.jreality.scene.tool.Tool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SceneGraphComponent
extends SceneGraphNode {
    private Transformation transformation;
    private Appearance appearance;
    private Camera camera;
    private Light light;
    private Geometry geometry;
    private AudioSource audioSource;
    private boolean visible = true;
    private boolean pickable = true;
    protected List<SceneGraphComponent> children = Collections.emptyList();
    protected List<Tool> tools = Collections.emptyList();
    private transient ToolListener toolListener;
    private transient SceneGraphComponentListener containerListener;
    private transient List<SceneEvent> cachedEvents = new LinkedList<SceneEvent>();
    private static int UNNAMED_ID;

    public SceneGraphComponent(String name) {
        super(name);
    }

    public SceneGraphComponent() {
        this("sgc " + UNNAMED_ID++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SceneGraphNode> getChildNodes() {
        this.startReader();
        try {
            ArrayList<SceneGraphNode> list = new ArrayList<SceneGraphNode>();
            if (this.transformation != null) {
                list.add(this.transformation);
            }
            if (this.appearance != null) {
                list.add(this.appearance);
            }
            if (this.camera != null) {
                list.add(this.camera);
            }
            if (this.light != null) {
                list.add(this.light);
            }
            if (this.geometry != null) {
                list.add(this.geometry);
            }
            if (this.audioSource != null) {
                list.add(this.audioSource);
            }
            list.addAll(this.children);
            ArrayList<SceneGraphNode> arrayList = list.isEmpty() ? Collections.EMPTY_LIST : list;
            return arrayList;
        }
        finally {
            this.finishReader();
        }
    }

    public void addChild(SceneGraphComponent sgc) {
        this.checkReadOnly();
        if (sgc == this) {
            throw new SceneGraphLoopException();
        }
        this.startWriter();
        try {
            class CheckLoop
            extends SceneGraphVisitor {
                final HashSet<SceneGraphComponent> encountered = new HashSet();

                CheckLoop() {
                }

                public void visit(SceneGraphComponent c) {
                    if (c == SceneGraphComponent.this) {
                        throw new SceneGraphLoopException();
                    }
                    if (this.encountered.add(c)) {
                        c.childrenAccept(this);
                    }
                }
            }
            sgc.childrenAccept(new CheckLoop());
        }
        catch (SceneGraphLoopException ex) {
            this.finishWriter();
            ex.fillInStackTrace();
            throw ex;
        }
        if (this.children == Collections.EMPTY_LIST) {
            this.children = new ArrayList<SceneGraphComponent>();
        }
        int index = this.children.size();
        this.children.add(sgc);
        this.fireSceneGraphElementAdded(sgc, 3, index);
        this.finishWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildren(SceneGraphComponent ... sgcList) {
        this.startWriter();
        try {
            for (SceneGraphComponent sgc : sgcList) {
                this.addChild(sgc);
            }
        }
        finally {
            this.finishWriter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SceneGraphComponent getChildComponent(int index) {
        this.startReader();
        try {
            SceneGraphComponent sceneGraphComponent = this.children.get(index);
            return sceneGraphComponent;
        }
        finally {
            this.finishReader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SceneGraphComponent> getChildComponents() {
        this.startReader();
        try {
            List<SceneGraphComponent> list = Collections.unmodifiableList(this.children);
            return list;
        }
        finally {
            this.finishReader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildComponentCount() {
        this.startReader();
        try {
            int n = this.children.size();
            return n;
        }
        finally {
            this.finishReader();
        }
    }

    public boolean removeChild(SceneGraphComponent sgc) {
        this.checkReadOnly();
        this.startWriter();
        int index = this.children.indexOf(sgc);
        if (index == -1) {
            this.finishWriter();
            return false;
        }
        this.children.remove(index);
        this.fireSceneGraphElementRemoved(sgc, 3, index);
        this.finishWriter();
        return true;
    }

    public void setAppearance(Appearance newApp) {
        this.checkReadOnly();
        this.startWriter();
        Appearance old = this.appearance;
        this.appearance = newApp;
        this.fireSceneGraphElementSet(old, newApp, 1);
        this.finishWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Appearance getAppearance() {
        this.startReader();
        try {
            Appearance appearance = this.appearance;
            return appearance;
        }
        finally {
            this.finishReader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Camera getCamera() {
        this.startReader();
        try {
            Camera camera = this.camera;
            return camera;
        }
        finally {
            this.finishReader();
        }
    }

    public void setCamera(Camera newCamera) {
        this.checkReadOnly();
        this.startWriter();
        Camera old = this.camera;
        this.camera = newCamera;
        this.fireSceneGraphElementSet(old, newCamera, 2);
        this.finishWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Geometry getGeometry() {
        this.startReader();
        try {
            Geometry geometry = this.geometry;
            return geometry;
        }
        finally {
            this.finishReader();
        }
    }

    public void setGeometry(Geometry g) {
        this.checkReadOnly();
        this.startWriter();
        Geometry old = this.geometry;
        this.geometry = g;
        this.fireSceneGraphElementSet(old, g, 4);
        this.finishWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioSource getAudioSource() {
        this.startReader();
        try {
            AudioSource audioSource = this.audioSource;
            return audioSource;
        }
        finally {
            this.finishReader();
        }
    }

    public void setAudioSource(AudioSource a) {
        this.checkReadOnly();
        this.startWriter();
        AudioSource old = this.audioSource;
        this.audioSource = a;
        this.fireSceneGraphElementSet(old, a, 9);
        this.finishWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Light getLight() {
        this.startReader();
        try {
            Light light = this.light;
            return light;
        }
        finally {
            this.finishReader();
        }
    }

    public void setLight(Light newLight) {
        this.checkReadOnly();
        this.startWriter();
        Light old = this.light;
        this.light = newLight;
        this.fireSceneGraphElementSet(old, newLight, 5);
        this.finishWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transformation getTransformation() {
        this.startReader();
        try {
            Transformation transformation = this.transformation;
            return transformation;
        }
        finally {
            this.finishReader();
        }
    }

    public void setTransformation(Transformation newTrans) {
        this.checkReadOnly();
        this.startWriter();
        Transformation oldTrans = this.transformation;
        this.transformation = newTrans;
        this.fireSceneGraphElementSet(oldTrans, newTrans, 7);
        this.finishWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirectAncestor(SceneGraphNode child) {
        this.startReader();
        try {
            boolean bl = this.transformation == child || this.appearance == child || this.camera == child || this.light == child || this.geometry == child || this.children.contains(child);
            return bl;
        }
        finally {
            this.finishReader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(SceneGraphVisitor v) {
        this.startReader();
        try {
            v.visit(this);
        }
        finally {
            this.finishReader();
        }
    }

    static void superAccept(SceneGraphComponent c, SceneGraphVisitor v) {
        c.superAccept(v);
    }

    private void superAccept(SceneGraphVisitor v) {
        super.accept(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void childrenAccept(SceneGraphVisitor v) {
        this.startReader();
        try {
            if (this.transformation != null) {
                this.transformation.accept(v);
            }
            if (this.appearance != null) {
                this.appearance.accept(v);
            }
            if (this.camera != null) {
                this.camera.accept(v);
            }
            if (this.light != null) {
                this.light.accept(v);
            }
            if (this.geometry != null) {
                this.geometry.accept(v);
            }
            if (this.audioSource != null) {
                this.audioSource.accept(v);
            }
            for (SceneGraphComponent c : this.children) {
                c.accept(v);
            }
        }
        finally {
            this.finishReader();
        }
    }

    public void childrenWriteAccept(SceneGraphVisitor v, boolean writeTransformation, boolean writeAppearance, boolean writeCamera, boolean writeLight, boolean writeGeometry, boolean writeChildren) {
        this.childrenWriteAccept(v, writeTransformation, writeAppearance, writeCamera, writeLight, writeGeometry, writeChildren, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void childrenWriteAccept(SceneGraphVisitor v, boolean writeTransformation, boolean writeAppearance, boolean writeCamera, boolean writeLight, boolean writeGeometry, boolean writeChildren, boolean writeAudio) {
        this.startReader();
        try {
            if (this.transformation != null) {
                if (writeTransformation) {
                    this.transformation.startWriter();
                }
                try {
                    this.transformation.accept(v);
                }
                finally {
                    if (writeTransformation) {
                        this.transformation.finishWriter();
                    }
                }
            }
            if (this.appearance != null) {
                if (writeAppearance) {
                    this.appearance.startWriter();
                }
                try {
                    this.appearance.accept(v);
                }
                finally {
                    if (writeAppearance) {
                        this.appearance.finishWriter();
                    }
                }
            }
            if (this.camera != null) {
                if (writeCamera) {
                    this.camera.startWriter();
                }
                try {
                    this.camera.accept(v);
                }
                finally {
                    if (writeCamera) {
                        this.camera.finishWriter();
                    }
                }
            }
            if (this.light != null) {
                if (writeLight) {
                    this.light.startWriter();
                }
                try {
                    this.light.accept(v);
                }
                finally {
                    if (writeLight) {
                        this.light.finishWriter();
                    }
                }
            }
            if (this.geometry != null) {
                if (writeGeometry) {
                    this.geometry.startWriter();
                }
                try {
                    this.geometry.accept(v);
                }
                finally {
                    if (writeGeometry) {
                        this.geometry.finishWriter();
                    }
                }
            }
            if (this.audioSource != null) {
                if (writeAudio) {
                    this.audioSource.startWriter();
                }
                try {
                    this.audioSource.accept(v);
                }
                finally {
                    if (writeAudio) {
                        this.audioSource.finishWriter();
                    }
                }
            }
            for (SceneGraphComponent c : this.children) {
                if (writeChildren) {
                    c.startWriter();
                }
                try {
                    c.accept(v);
                }
                finally {
                    if (!writeChildren) continue;
                    c.finishWriter();
                }
            }
        }
        finally {
            this.finishReader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTool(Tool tool) {
        this.startWriter();
        try {
            if (this.tools == Collections.EMPTY_LIST) {
                this.tools = new ArrayList<Tool>();
            }
            if (this.tools.contains(tool)) {
                return;
            }
            this.tools.add(tool);
            this.fireToolAdded(tool);
        }
        finally {
            this.finishWriter();
        }
    }

    public boolean removeTool(Tool tool) {
        this.startWriter();
        int toolIndex = this.tools.indexOf(tool);
        if (toolIndex == -1) {
            this.finishWriter();
            return false;
        }
        this.tools.remove(toolIndex);
        this.fireToolRemoved(tool);
        this.finishWriter();
        return true;
    }

    private void fireToolAdded(Tool tool) {
        if (this.toolListener == null) {
            return;
        }
        ToolEvent event = new ToolEvent(this, tool, 0);
        this.cachedEvents.add(event);
    }

    private void fireToolRemoved(Tool tool) {
        if (this.toolListener == null) {
            return;
        }
        ToolEvent event = new ToolEvent(this, tool, 2);
        this.cachedEvents.add(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tool> getTools() {
        this.startReader();
        try {
            List<Tool> list = Collections.unmodifiableList(this.tools);
            return list;
        }
        finally {
            this.finishReader();
        }
    }

    public void addToolListener(ToolListener listener) {
        this.startReader();
        this.toolListener = ToolEventMulticaster.add(this.toolListener, listener);
        this.finishReader();
    }

    public void removeToolListener(ToolListener listener) {
        this.startReader();
        this.toolListener = ToolEventMulticaster.remove(this.toolListener, listener);
        this.finishReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVisible() {
        this.startReader();
        try {
            boolean bl = this.visible;
            return bl;
        }
        finally {
            this.finishReader();
        }
    }

    public void setVisible(boolean newVisibleState) {
        this.checkReadOnly();
        this.startWriter();
        if (this.visible != newVisibleState) {
            this.visible = newVisibleState;
            this.fireVisibilityChanged();
        }
        this.finishWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPickable() {
        this.startReader();
        try {
            boolean bl = this.pickable;
            return bl;
        }
        finally {
            this.finishReader();
        }
    }

    public void setPickable(boolean newPickableState) {
        this.checkReadOnly();
        this.startWriter();
        if (this.pickable != newPickableState) {
            this.pickable = newPickableState;
            this.firePickabilityChanged();
        }
        this.finishWriter();
    }

    public void addSceneGraphComponentListener(SceneGraphComponentListener listener) {
        this.startReader();
        this.containerListener = SceneGraphComponentEventMulticaster.add(this.containerListener, listener);
        this.finishReader();
    }

    public void removeSceneGraphComponentListener(SceneGraphComponentListener listener) {
        this.startReader();
        this.containerListener = SceneGraphComponentEventMulticaster.remove(this.containerListener, listener);
        this.finishReader();
    }

    void fireSceneGraphElementAdded(SceneGraphNode child, int type, int index) {
        if (this.containerListener == null) {
            return;
        }
        SceneGraphComponentEvent event = new SceneGraphComponentEvent(this, 21, type, null, child, index);
        this.cachedEvents.add(event);
    }

    void fireSceneGraphElementRemoved(SceneGraphNode child, int type, int index) {
        if (this.containerListener == null) {
            return;
        }
        SceneGraphComponentEvent event = new SceneGraphComponentEvent(this, 22, type, child, null, index);
        this.cachedEvents.add(event);
    }

    void fireSceneGraphElementReplaced(SceneGraphNode old, SceneGraphNode _new, int type, int index) {
        if (this.containerListener == null) {
            return;
        }
        SceneGraphComponentEvent event = new SceneGraphComponentEvent(this, 23, type, old, _new, index);
        this.cachedEvents.add(event);
    }

    void fireSceneGraphElementSet(SceneGraphNode old, SceneGraphNode _new, int type) {
        if (old == _new) {
            return;
        }
        if (old == null) {
            this.fireSceneGraphElementAdded(_new, type, 0);
        } else if (_new == null) {
            this.fireSceneGraphElementRemoved(old, type, 0);
        } else {
            this.fireSceneGraphElementReplaced(old, _new, type, 0);
        }
    }

    void fireVisibilityChanged() {
        if (this.containerListener == null) {
            return;
        }
        SceneGraphComponentEvent event = new SceneGraphComponentEvent(this, 24);
        this.cachedEvents.add(event);
    }

    void firePickabilityChanged() {
        if (this.containerListener == null) {
            return;
        }
        SceneGraphComponentEvent event = new SceneGraphComponentEvent(this, 25);
        this.cachedEvents.add(event);
    }

    private void fire(SceneGraphComponentEvent event) {
        switch (event.getEventType()) {
            case 21: {
                this.containerListener.childAdded(event);
                return;
            }
            case 22: {
                this.containerListener.childRemoved(event);
                return;
            }
            case 23: {
                this.containerListener.childReplaced(event);
                return;
            }
            case 24: {
                this.containerListener.visibilityChanged(event);
            }
        }
    }

    private void fire(ToolEvent event) {
        switch (event.getEventType()) {
            case 0: {
                this.toolListener.toolAdded(event);
                return;
            }
            case 2: {
                this.toolListener.toolRemoved(event);
                return;
            }
        }
    }

    private void fire(SceneEvent event) {
        if (event instanceof ToolEvent) {
            this.fire((ToolEvent)event);
        } else {
            this.fire((SceneGraphComponentEvent)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writingFinished() {
        try {
            for (SceneEvent event : this.cachedEvents) {
                this.fire(event);
            }
        }
        finally {
            this.cachedEvents.clear();
        }
    }
}

