/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.renderman.shader;

import de.jreality.math.Matrix;
import de.jreality.math.Rn;
import de.jreality.renderman.RIBHelper;
import de.jreality.renderman.RIBVisitor;
import de.jreality.renderman.shader.AbstractRendermanShader;
import de.jreality.renderman.shader.SLShader;
import de.jreality.scene.Appearance;
import de.jreality.shader.CubeMap;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.ShaderUtility;
import de.jreality.shader.Texture2D;
import java.io.File;
import java.util.Map;

public class DefaultPolygonShader
extends AbstractRendermanShader {
    CubeMap reflectionMap;
    static int count = 0;
    de.jreality.shader.DefaultPolygonShader attent;

    public DefaultPolygonShader(de.jreality.shader.DefaultPolygonShader attent) {
        this.attent = attent;
    }

    public Map getAttributes() {
        return this.map;
    }

    public void setFromEffectiveAppearance(RIBVisitor ribv, EffectiveAppearance eap, String name) {
        this.setFromEffectiveAppearance(ribv, eap, name, "");
    }

    public void setFromEffectiveAppearance(RIBVisitor ribv, EffectiveAppearance eap, String name, String side) {
        this.map.clear();
        int metric = eap.getAttribute("metric", 0);
        boolean lighting = eap.getAttribute("lightingEnabled", true);
        this.map.put("float roughness" + side, new Float(1.0f / this.attent.getSpecularExponent().floatValue()));
        this.map.put("float Ks" + side, new Float(this.attent.getSpecularCoefficient()));
        this.map.put("float Kd" + side, new Float(this.attent.getDiffuseCoefficient()));
        this.map.put("float Ka" + side, new Float(this.attent.getAmbientCoefficient()));
        this.map.put("color specularcolor" + side, this.attent.getSpecularColor());
        this.map.put("float lighting" + side, new Float(lighting ? 1.0f : 0.0f));
        boolean transp = eap.getAttribute("transparencyEnabled", false);
        this.map.put("float transparencyenabled" + side, new Float(transp ? 1.0f : 0.0f));
        if (metric != 0) {
            this.map.put("float signature", metric);
            this.map.put("float[16] objectToCamera", RIBHelper.fTranspose(ribv.getCurrentObjectToCamera()));
            this.shaderName = "noneuclideanpolygonshader";
        } else {
            this.shaderName = "defaultpolygonshader";
        }
        boolean ignoreTexture2d = eap.getAttribute(ShaderUtility.nameSpace(name, "ignoreTexture2d"), false);
        if (!ignoreTexture2d && this.attent.getTexture2d() != null) {
            Texture2D tex = this.attent.getTexture2d();
            String fname = null;
            fname = (String)eap.getAttribute("rendermanTexFile", "");
            if (fname == "") {
                fname = null;
            }
            if (fname == null) {
                fname = new File(ribv.writeTexture(tex)).getName();
            }
            this.map.put("string texturename" + side, fname);
            Matrix textureMatrix = tex.getTextureMatrix();
            double[] mat = textureMatrix.getArray();
            if (mat != null && !Rn.isIdentityMatrix(mat, 1.0E-7)) {
                this.map.put("float[16] tm" + side, RIBHelper.fTranspose(mat));
            }
        }
        if (this.attent.getReflectionMap() != null) {
            this.reflectionMap = this.attent.getReflectionMap();
            if (eap.getAttribute("rendermanRayTracingReflectionsEnabled", false)) {
                this.map.put("float raytracedreflections", new Float(1.0f));
            } else {
                this.map.put("float raytracedreflections", new Float(0.0f));
                String fname = (String)eap.getAttribute("rendermanReflectionmapFile", "");
                if (fname == "") {
                    fname = null;
                }
                if (fname == null) {
                    fname = new File(ribv.writeCubeMap(this.reflectionMap)).getName();
                }
                this.map.put("string reflectionmap" + side, fname);
            }
            this.map.put("float reflectionBlend" + side, new Float((double)this.reflectionMap.getBlendColor().getAlpha() / 255.0));
        }
        Object obj1 = eap.getAttribute("rendermanVolumeInteriorShader", Appearance.INHERITED, SLShader.class);
        Object obj2 = eap.getAttribute("rendermanVolumeExteriorShader", Appearance.INHERITED, SLShader.class);
        if (obj1 != Appearance.INHERITED && eap.getAttribute("rendermanRayTracingVolumesEnabled", false) || obj2 != Appearance.INHERITED) {
            this.map.put("float raytracedvolumes", new Float(1.0f));
        }
    }

    public String getType() {
        return "Surface";
    }
}

