/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.reader;

import de.jreality.geometry.IndexedFaceSetUtility;
import de.jreality.geometry.QuadMeshFactory;
import de.jreality.reader.AbstractReader;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.util.Input;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Stack;

public class ReaderMESH
extends AbstractReader {
    Stack stack = new Stack();

    public void setInput(Input input) throws IOException {
        super.setInput(input);
        this.stack.push(new ArrayList());
        this.load();
        System.out.println(this.stack.size());
        ArrayList rows = (ArrayList)this.stack.peek();
        rows = (ArrayList)rows.get(0);
        int m = rows.size();
        ArrayList col0 = (ArrayList)rows.get(0);
        int n = col0.size();
        System.out.println("m=" + m);
        System.out.println("n=" + n);
        double[][][] coords = new double[m][n][3];
        double[][][] texCoords = new double[m][n][2];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                ArrayList r = (ArrayList)rows.get(i);
                ArrayList p = (ArrayList)r.get(j);
                coords[i][j][0] = (Double)p.get(0);
                coords[i][j][1] = (Double)p.get(1);
                coords[i][j][2] = (Double)p.get(2);
                if (p.size() <= 3) continue;
                texCoords[i][j][0] = (Double)p.get(3);
                texCoords[i][j][1] = (Double)p.get(4);
            }
        }
        QuadMeshFactory qmf = new QuadMeshFactory();
        qmf.setGenerateTextureCoordinates(false);
        qmf.setVLineCount(m);
        qmf.setULineCount(n);
        qmf.setVertexCoordinates(coords);
        qmf.setVertexTextureCoordinates(texCoords);
        qmf.setGenerateFaceNormals(true);
        qmf.setGenerateVertexNormals(true);
        qmf.setGenerateEdgesFromFaces(true);
        qmf.update();
        IndexedFaceSet fs = qmf.getIndexedFaceSet();
        IndexedFaceSetUtility.assignSmoothVertexNormals(fs, 6);
        this.root = new SceneGraphComponent();
        this.root.setGeometry(qmf.getIndexedFaceSet());
    }

    private StreamTokenizer globalSyntax(StreamTokenizer st) {
        st.resetSyntax();
        st.eolIsSignificant(false);
        st.wordChars(123, 123);
        st.wordChars(125, 125);
        st.ordinaryChar(45);
        st.wordChars(160, 255);
        st.whitespaceChars(0, 32);
        st.commentChar(35);
        st.ordinaryChar(47);
        st.parseNumbers();
        return st;
    }

    private void load() throws IOException {
        StreamTokenizer st = new StreamTokenizer(this.input.getReader());
        this.globalSyntax(st);
        while (st.nextToken() != -1) {
            if (st.ttype == -3) {
                String word = st.sval;
                System.out.println("word=" + st.sval);
                for (int i = 0; i < word.length(); ++i) {
                    if (word.charAt(i) != '{' && word.charAt(i) != '}') {
                        this.number(Double.parseDouble(word.substring(i)));
                        break;
                    }
                    this.bracket(word.charAt(i));
                }
            }
            if (st.ttype != -2) continue;
            System.out.println("number=" + st.nval);
            this.number(st.nval);
        }
    }

    private void bracket(char c) {
        if (c == '{') {
            ArrayList p = (ArrayList)this.stack.peek();
            ArrayList cl = new ArrayList();
            p.add(cl);
            this.stack.push(cl);
        } else {
            this.stack.pop();
        }
    }

    private void number(double nval) {
        ArrayList p = (ArrayList)this.stack.peek();
        p.add(nval);
    }
}

