/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.reader;

import de.jreality.geometry.IndexedFaceSetUtility;
import de.jreality.math.MatrixBuilder;
import de.jreality.math.Rn;
import de.jreality.reader.AbstractReader;
import de.jreality.scene.Appearance;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DoubleArrayArray;
import de.jreality.scene.data.IntArrayArray;
import de.jreality.scene.data.StorageModel;
import de.jreality.shader.ImageData;
import de.jreality.shader.Texture2D;
import de.jreality.shader.TextureUtility;
import de.jreality.util.Input;
import java.awt.Color;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Reader3DS
extends AbstractReader {
    static final int ID_3DS_FILE = 19789;
    static final int ID_EDIT3DS = 15677;
    static final int ID_MATERIAL = 45055;
    static final int ID_MATERIAL_NAME = 40960;
    static final int ID_MATERIAL_AMBIENT = 40976;
    static final int ID_MATERIAL_DIFFUSE = 40992;
    static final int ID_MATERIAL_SPECULAR = 41008;
    static final int ID_MATERIAL_SHININESS = 41024;
    static final int ID_MATERIAL_TEXTURE = 41472;
    static final int ID_MATERIAL_TEXTUREFILE = 41728;
    static final int ID_MAT_SHININESS_STRENGTH = 41025;
    static final int ID_MATERIAL_TRANSPARENCY = 41040;
    static final int ID_NAMED_OBJECT = 16384;
    static final int ID_TRIANGLE_SET = 16640;
    static final int ID_POINT_LIST = 16656;
    static final int ID_FACE_LIST = 16672;
    static final int ID_FACE_MATERIAL = 16688;
    static final int ID_MAPPING_COORDINATES_LIST = 16704;
    static final int ID_SMOOTH_GROUP = 16720;
    static final int ID_MESH_MATRIX = 16736;
    static final int ID_TEXTURE_COORDINATES = 16704;
    static final int ID_COLOR_FLOAT = 16;
    static final int ID_COLOR_24 = 17;
    static final int ID_COLOR_LIN_24 = 18;
    static final int ID_COLOR_LIN_FLOAT = 19;
    static final int ID_INT_PERCENTAGE = 48;
    static final int ID_FLOAT_PERCENTAGE = 49;
    private Appearance defaultAppearance = null;
    private SceneGraphComponent mRootGroupNode;
    private double globalScale = 1.0;
    private Appearance mMaterialRootNode;
    Hashtable mAppearanceHash;
    private Appearance mCurrentApperance;
    private SceneGraphComponent mCurretSceneNode;
    private IndexedFaceSet mCurrentIFS;
    private float[] color = new float[3];
    private float shininess;
    private boolean removeNode = false;
    private int lastPointCount = 0;

    public Reader3DS() {
        this.setRootGroupNode(new SceneGraphComponent());
        this.setApperanceHash(new Hashtable());
        this.setCurrentSceneNode(null);
        this.setCurrentApperance(null);
        this.defaultAppearance = new Appearance();
    }

    private void setRootGroupNode(SceneGraphComponent node) {
        this.mRootGroupNode = node;
    }

    public SceneGraphComponent getRootGroupNode() {
        return this.mRootGroupNode;
    }

    private void setApperanceHash(Hashtable root) {
        this.mAppearanceHash = root;
    }

    private Hashtable getAppearanceHash() {
        return this.mAppearanceHash;
    }

    private void addAppearanceByName(Appearance matNode) {
        this.getAppearanceHash().put(matNode.getName(), matNode);
    }

    private Appearance getApperanceByName(String name) {
        if (name == null) {
            return null;
        }
        return (Appearance)this.getAppearanceHash().get(name);
    }

    private void setCurrentApperance(Appearance node) {
        this.mCurrentApperance = node;
    }

    private Appearance getCurrentApperance() {
        return this.mCurrentApperance;
    }

    private void setCurrentSceneNode(SceneGraphComponent node) {
        this.mCurretSceneNode = node;
    }

    private SceneGraphComponent getCurrentSceneNode() {
        return this.mCurretSceneNode;
    }

    private void setCurrentIndexFaceSet(IndexedFaceSet ifs) {
        this.mCurrentIFS = ifs;
    }

    private IndexedFaceSet getCurrentIndexedFaceSet() {
        return this.mCurrentIFS;
    }

    public void setInput(Input input) throws IOException {
        Object result = null;
        this.load(input.getInputStream());
        this.root = this.getRootGroupNode();
    }

    private boolean load(InputStream inputStream) {
        try {
            DataInputStream dataIn = new DataInputStream(inputStream);
            while (true) {
                int id = this.readUnsignedShort(dataIn);
                int len = this.readInt(dataIn);
                this.readChunk(dataIn, id, len);
            }
        }
        catch (EOFException eofe) {
        }
        catch (IOException ioe) {
            Logger.getLogger("de.jreality").log(Level.WARNING, "Parser3DS.load");
            Logger.getLogger("de.jreality").log(Level.WARNING, "\tIOException");
            return false;
        }
        return true;
    }

    private void readChunk(DataInputStream dataIn, int id, int len) throws IOException {
        switch (id) {
            case 19789: {
                Logger.getLogger("de.jreality").log(Level.FINER, "ID_3DS_FILE");
                return;
            }
            case 15677: {
                Logger.getLogger("de.jreality").log(Level.FINER, "ID_EDIT3DS");
                break;
            }
            case 45055: {
                Logger.getLogger("de.jreality").log(Level.FINER, "ID_MATERIAL");
                Appearance matNode = new Appearance();
                this.setCurrentApperance(matNode);
                break;
            }
            case 40960: {
                Logger.getLogger("de.jreality").log(Level.FINER, "ID_MATERIAL_NAME");
                String matName = this.readString(dataIn);
                Logger.getLogger("de.jreality").log(Level.FINER, "\tname = " + matName);
                this.getCurrentApperance().setName(matName);
                this.addAppearanceByName(this.getCurrentApperance());
                break;
            }
            case 40976: {
                this.readColor(dataIn, this.color);
                Logger.getLogger("de.jreality").log(Level.FINER, "ID_MATERIAL_AMBIENT = (" + this.color[0] + ", " + this.color[1] + ", " + this.color[2] + ")");
                this.getCurrentApperance().setAttribute("polygonShader.ambientColor", new Color(this.color[0], this.color[1], this.color[2]));
                break;
            }
            case 40992: {
                this.readColor(dataIn, this.color);
                Logger.getLogger("de.jreality").log(Level.FINER, "ID_MATERIAL_DIFFUSE = (" + this.color[0] + ", " + this.color[1] + ", " + this.color[2] + ")");
                this.getCurrentApperance().setAttribute("polygonShader.diffuseColor", new Color(this.color[0], this.color[1], this.color[2]));
                break;
            }
            case 41472: {
                break;
            }
            case 41728: {
                String textName = this.readString(dataIn);
                if (textName.equals("")) break;
                Texture2D tex2d = null;
                try {
                    ImageData imgData = ImageData.load(this.input.resolveInput(textName));
                    if (imgData != null) {
                        tex2d = TextureUtility.createTexture(this.getCurrentApperance(), "polygonShader", imgData, false);
                        tex2d.setTextureMatrix(MatrixBuilder.euclidean().scale(1.0, -1.0, 0.0).getMatrix());
                    }
                }
                catch (Exception e) {
                    Logger.getLogger("de.jreality").log(Level.WARNING, "Could not find the Texture " + textName);
                    break;
                }
            }
            case 41008: {
                this.readColor(dataIn, this.color);
                Logger.getLogger("de.jreality").log(Level.FINER, "ID_MATERIAL_SPECULAR = (" + this.color[0] + ", " + this.color[1] + ", " + this.color[2] + ")");
                this.getCurrentApperance().setAttribute("polygonShader.specularColor", new Color(this.color[0], this.color[1], this.color[2]));
                break;
            }
            case 41024: {
                this.shininess = this.readPercentage(dataIn);
                Logger.getLogger("de.jreality").log(Level.FINER, "ID_MATERIAL_SHININESS = " + this.shininess);
                break;
            }
            case 41025: {
                float shininessStrength = this.readPercentage(dataIn);
                Logger.getLogger("de.jreality").log(Level.FINER, "ID_MATERIAL_SHININESS_STRENGTH = " + shininessStrength);
                float matShiness = (1.0f - (this.shininess + shininessStrength) / 2.0f) * 128.0f;
                Logger.getLogger("de.jreality").log(Level.FINER, "\tshininess = " + matShiness);
                break;
            }
            case 41040: {
                float trans = this.readPercentage(dataIn);
                break;
            }
            case 16384: {
                IndexedFaceSet ifs;
                Logger.getLogger("de.jreality").log(Level.FINER, "ID_NAMED_OBJECT");
                String objName = this.readString(dataIn);
                Logger.getLogger("de.jreality").log(Level.FINER, "\tname = " + objName);
                SceneGraphComponent shapeNode = new SceneGraphComponent();
                shapeNode.setName(objName);
                this.getRootGroupNode().addChild(shapeNode);
                if (this.getCurrentSceneNode() != null && (ifs = (IndexedFaceSet)this.getCurrentSceneNode().getGeometry()) != null) {
                    this.getCurrentSceneNode().setGeometry(ifs);
                }
                this.setCurrentSceneNode(shapeNode);
                this.defaultAppearance = new Appearance();
                shapeNode.setAppearance(this.defaultAppearance);
                break;
            }
            case 16640: {
                Logger.getLogger("de.jreality").log(Level.FINER, "ID_TRIANGLE_SET");
                IndexedFaceSet idxFaceSetNode = new IndexedFaceSet(0, 0);
                this.setCurrentIndexFaceSet(idxFaceSetNode);
                this.getCurrentSceneNode().setGeometry(idxFaceSetNode);
                this.removeNode = false;
                int[][] empty = new int[0][0];
                idxFaceSetNode.setFaceCountAndAttributes(Attribute.INDICES, new IntArrayArray.Array(empty));
                break;
            }
            case 16704: {
                int nPoints = this.readUnsignedShort(dataIn);
                if (nPoints <= 0) break;
                IndexedFaceSet idxFaceSetNode = this.getCurrentIndexedFaceSet();
                double[][] texCoords = new double[nPoints][2];
                for (int n = 0; n < nPoints; ++n) {
                    double d = this.readFloat(dataIn);
                    texCoords[n][0] = d;
                    double x = d;
                    double d2 = this.readFloat(dataIn);
                    texCoords[n][1] = d2;
                    double y = d2;
                }
                idxFaceSetNode.setVertexAttributes(Attribute.TEXTURE_COORDINATES, StorageModel.DOUBLE_ARRAY.array(2).createReadOnly(texCoords));
                break;
            }
            case 16656: {
                Logger.getLogger("de.jreality").log(Level.FINER, "ID_POINT_LIST");
                int nPoints = this.readUnsignedShort(dataIn);
                Logger.getLogger("de.jreality").log(Level.FINER, "\tnPoints = " + nPoints);
                this.lastPointCount = nPoints - 1;
                if (nPoints == 0) {
                    this.removeNode = true;
                }
                if (nPoints <= 0) break;
                IndexedFaceSet idxFaceSetNode = this.getCurrentIndexedFaceSet();
                double[][] points = new double[nPoints][3];
                for (int n = 0; n < nPoints; ++n) {
                    double d = this.readFloat(dataIn);
                    points[n][0] = d;
                    double x = d;
                    double d3 = this.readFloat(dataIn);
                    points[n][1] = d3;
                    double y = d3;
                    double d4 = this.readFloat(dataIn);
                    points[n][2] = d4;
                    double z = d4;
                }
                idxFaceSetNode.setVertexCountAndAttributes(Attribute.COORDINATES, StorageModel.DOUBLE_ARRAY.array(3).createReadOnly(points));
                break;
            }
            case 16672: {
                Logger.getLogger("de.jreality").log(Level.FINER, "ID_FACE_LIST");
                int nIndices = this.readUnsignedShort(dataIn);
                Logger.getLogger("de.jreality").log(Level.FINER, "\tnIndices = " + nIndices);
                if (nIndices <= 0) break;
                IndexedFaceSet idxFaceSetNode = this.getCurrentIndexedFaceSet();
                int[][] faces = new int[nIndices][3];
                double[][] faceNormals = new double[nIndices][3];
                double[][] verts = idxFaceSetNode.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray(null);
                for (int n = 0; n < nIndices; ++n) {
                    int n2 = this.readUnsignedShort(dataIn);
                    faces[n][0] = n2;
                    int idx1 = n2;
                    int n3 = this.readUnsignedShort(dataIn);
                    faces[n][1] = n3;
                    int idx2 = n3;
                    int n4 = this.readUnsignedShort(dataIn);
                    faces[n][2] = n4;
                    int idx3 = n4;
                    double[] v1 = new double[3];
                    double[] v2 = new double[3];
                    Rn.subtract(v1, verts[idx2], verts[idx3]);
                    Rn.subtract(v2, verts[idx2], verts[idx1]);
                    Rn.crossProduct(faceNormals[n], v1, v2);
                    Rn.normalize(faceNormals[n], faceNormals[n]);
                    if (idx1 > this.lastPointCount || idx2 > this.lastPointCount || idx3 > this.lastPointCount) {
                        Logger.getLogger("de.jreality").log(Level.WARNING, "reference to undefined vertex! removing node!");
                        this.removeNode = true;
                    }
                    int idx4 = this.readUnsignedShort(dataIn);
                }
                idxFaceSetNode.setFaceCountAndAttributes(Attribute.INDICES, new IntArrayArray.Array(faces));
                idxFaceSetNode.setFaceAttributes(Attribute.NORMALS, new DoubleArrayArray.Array(faceNormals));
                IndexedFaceSetUtility.calculateAndSetEdgesFromFaces(idxFaceSetNode);
                break;
            }
            case 16688: {
                Logger.getLogger("de.jreality").log(Level.FINER, "ID_FACE_MATERIAL");
                String matName = this.readString(dataIn);
                Logger.getLogger("de.jreality").log(Level.FINER, "\tname = " + matName);
                Appearance appearance = this.getApperanceByName(matName);
                if (appearance != null) {
                    this.getCurrentSceneNode().setAppearance(appearance);
                } else {
                    this.getCurrentSceneNode().setAppearance(this.defaultAppearance);
                }
                if (this.removeNode) {
                    this.getRootGroupNode().removeChild(this.getCurrentSceneNode());
                    Logger.getLogger("de.jreality").log(Level.FINER, "\tremoved node " + this.getCurrentSceneNode().getName());
                }
                int nCounts = this.readUnsignedShort(dataIn);
                for (int n = 0; n < nCounts; ++n) {
                    this.readUnsignedShort(dataIn);
                }
                break;
            }
            default: {
                Logger.getLogger("de.jreality").log(Level.FINE, "UNKOWN CHUNK! ID : 0x" + Integer.toHexString(id) + "  LEN : " + len);
                this.skipChunk(dataIn, len);
            }
        }
    }

    private int readUnsignedByte(DataInputStream dataIn) throws IOException {
        return dataIn.readUnsignedByte();
    }

    private int readUnsignedShort(DataInputStream dataIn) throws IOException {
        int value = dataIn.readUnsignedShort();
        return value << 8 & 0xFF00 | value >> 8 & 0xFF;
    }

    private int readInt(DataInputStream dataIn) throws IOException {
        int value = dataIn.readInt();
        return value << 24 & 0xFF000000 | value << 8 & 0xFF0000 | value >> 8 & 0xFF00 | value >> 24 & 0xFF;
    }

    private float readFloat(DataInputStream dataIn) throws IOException {
        return Float.intBitsToFloat(this.readInt(dataIn));
    }

    private String readString(DataInputStream dataIn) throws IOException {
        StringBuffer sb = new StringBuffer();
        byte c = dataIn.readByte();
        while (c != 0) {
            sb.append((char)c);
            c = dataIn.readByte();
        }
        return sb.toString();
    }

    private void readColor(DataInputStream dataIn, float[] color) throws IOException {
        int type = this.readUnsignedShort(dataIn);
        int len = this.readInt(dataIn);
        switch (type) {
            case 16: {
                color[0] = this.readFloat(dataIn);
                color[1] = this.readFloat(dataIn);
                color[2] = this.readFloat(dataIn);
                break;
            }
            case 17: {
                color[0] = (float)this.readUnsignedByte(dataIn) / 255.0f;
                color[1] = (float)this.readUnsignedByte(dataIn) / 255.0f;
                color[2] = (float)this.readUnsignedByte(dataIn) / 255.0f;
                break;
            }
            default: {
                Logger.getLogger("de.jreality").log(Level.WARNING, "Unknown Color Type : 0x" + Integer.toHexString(type));
            }
        }
    }

    private float readPercentage(DataInputStream dataIn) throws IOException {
        int type = this.readUnsignedShort(dataIn);
        int len = this.readInt(dataIn);
        switch (type) {
            case 48: {
                return (float)this.readUnsignedShort(dataIn) / 100.0f;
            }
            case 49: {
                return this.readFloat(dataIn);
            }
        }
        Logger.getLogger("de.jreality").log(Level.WARNING, "Unknown Percentage Type : 0x" + Integer.toHexString(type));
        return 0.0f;
    }

    private void skipChunk(DataInputStream dataIn, int len) throws IOException {
        int nSkipBytes = len - 6;
        if (0 < nSkipBytes) {
            dataIn.skipBytes(nSkipBytes);
        }
    }

    public void setGlobalScale(double globalScale) {
        this.globalScale = globalScale;
    }
}

