/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.reader;

import java.util.concurrent.ArrayBlockingQueue;

class PointOctree {
    private Node root = null;
    private int size = 0;

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    public Node insert(double x, double y, double z) {
        if (this.isEmpty()) {
            this.root = new Node(x, y, z);
            ++this.size;
            return this.root;
        }
        Node node = this.root;
        while (!node.equals(x, y, z)) {
            int sector = 0;
            if (x < node.x) {
                sector += 4;
            }
            if (y < node.y) {
                sector += 2;
            }
            if (z < node.z) {
                ++sector;
            }
            if (node.children[sector] == null) {
                ((Node)node).children[sector] = new Node(x, y, z, this.size++);
                return node;
            }
            node = node.children[sector];
        }
        return null;
    }

    public Node find(double x, double y, double z) {
        Node node = this.root;
        if (node == null) {
            return null;
        }
        while (!node.equals(x, y, z)) {
            int sector = 0;
            if (x < node.x) {
                sector += 4;
            }
            if (y < node.y) {
                sector += 2;
            }
            if (z < node.z) {
                ++sector;
            }
            if (node.children[sector] == null) {
                return null;
            }
            node = node.children[sector];
        }
        return node;
    }

    public Node[] dump() throws Exception {
        if (this.size == 0) {
            return null;
        }
        int cnt = 0;
        Node[] nodeArray = new Node[this.size];
        ArrayBlockingQueue<Node> queue = new ArrayBlockingQueue<Node>(this.size);
        queue.add(this.root);
        while (!queue.isEmpty()) {
            Node n = (Node)queue.poll();
            nodeArray[cnt++] = n;
            for (int i = 0; i < 8; ++i) {
                if (n.children[i] == null) continue;
                queue.add(n.children[i]);
            }
        }
        if (cnt != this.size) {
            throw new Exception("Error: dumped not all nodes!");
        }
        return nodeArray;
    }

    class Node {
        private double x;
        private double y;
        private double z;
        private int index = 0;
        private Node[] children = new Node[8];

        public Node(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Node(double x, double y, double z, int node_index) {
            this(x, y, z);
            this.index = node_index;
        }

        public boolean equals(Node n) {
            return this.equals(n.x, n.y, n.z);
        }

        public int index() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public Node(Node n) {
            this(n.x, n.y, n.z);
        }

        public boolean equals(double x, double y, double z) {
            return x == this.x && y == this.y && z == this.z;
        }
    }
}

