/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl.shader;

import de.jreality.jogl.JOGLRenderer;
import de.jreality.jogl.JOGLRenderingState;
import de.jreality.shader.CommonAttributes;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.ShaderUtility;
import java.awt.Color;
import javax.media.opengl.GL;

public class DefaultVertexShader {
    public Color ambientColor;
    public Color diffuseColor;
    public Color specularColor;
    public double specularExponent;
    public double ambientCoefficient;
    public double diffuseCoefficient;
    public double specularCoefficient;
    public double transparency;
    public float[] specularColorAsFloat;
    public float[] ambientColorAsFloat;
    public float[] diffuseColorAsFloat;

    public void setFromEffectiveAppearance(EffectiveAppearance eap, String name) {
        this.specularExponent = eap.getAttribute(ShaderUtility.nameSpace(name, "specularExponent"), 60.0);
        this.ambientCoefficient = eap.getAttribute(ShaderUtility.nameSpace(name, "ambientCoefficient"), 0.0);
        this.diffuseCoefficient = eap.getAttribute(ShaderUtility.nameSpace(name, "diffuseCoefficient"), 1.0);
        this.specularCoefficient = eap.getAttribute(ShaderUtility.nameSpace(name, "specularCoefficient"), 0.7);
        this.ambientColor = (Color)eap.getAttribute(ShaderUtility.nameSpace(name, "ambientColor"), CommonAttributes.AMBIENT_COLOR_DEFAULT);
        this.ambientColorAsFloat = this.ambientColor.getRGBComponents(null);
        this.diffuseColor = (Color)eap.getAttribute(ShaderUtility.nameSpace(name, "diffuseColor"), CommonAttributes.DIFFUSE_COLOR_DEFAULT);
        this.transparency = eap.getAttribute(ShaderUtility.nameSpace(name, "transparency"), 0.0);
        this.diffuseColor = ShaderUtility.combineDiffuseColorWithTransparency(this.diffuseColor, this.transparency, JOGLRenderingState.useOldTransparency);
        this.diffuseColorAsFloat = this.diffuseColor.getRGBComponents(null);
        this.specularColor = (Color)eap.getAttribute(ShaderUtility.nameSpace(name, "specularColor"), CommonAttributes.SPECULAR_COLOR_DEFAULT);
        this.specularColorAsFloat = this.specularColor.getRGBComponents(null);
        int i = 0;
        while (i < 3) {
            int n = i;
            this.ambientColorAsFloat[n] = this.ambientColorAsFloat[n] * (float)this.ambientCoefficient;
            int n2 = i;
            this.diffuseColorAsFloat[n2] = this.diffuseColorAsFloat[n2] * (float)this.diffuseCoefficient;
            int n3 = i++;
            this.specularColorAsFloat[n3] = this.specularColorAsFloat[n3] * (float)this.specularCoefficient;
        }
    }

    public void render(JOGLRenderingState jrs) {
        JOGLRenderer jr = jrs.renderer;
        GL gl = jr.globalGL;
        int frontBack = jrs.frontBack;
        gl.glColorMaterial(frontBack, 4609);
        if (jr.renderingState.transparencyEnabled || (double)this.diffuseColorAsFloat[3] == 0.0) {
            gl.glColor4fv(this.diffuseColorAsFloat, 0);
        } else {
            gl.glColor3fv(this.diffuseColorAsFloat, 0);
        }
        System.arraycopy(this.diffuseColorAsFloat, 0, jr.renderingState.diffuseColor, 0, 4);
        jrs.currentAlpha = jrs.diffuseColor[3];
        gl.glMaterialfv(frontBack, 4608, this.ambientColorAsFloat, 0);
        gl.glMaterialfv(frontBack, 4610, this.specularColorAsFloat, 0);
        gl.glMaterialf(frontBack, 5633, (float)this.specularExponent);
    }

    public void postRender(JOGLRenderingState jrs) {
    }
}

