/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl.plugin;

import com.sun.opengl.util.GLUT;
import de.jreality.jogl.AbstractViewer;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.glu.GLU;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfoOverlay
implements GLEventListener {
    InfoProvider infoProvider = null;
    AbstractViewer viewer;
    public int position = 0;
    private boolean visible = false;
    private GLUT glut = new GLUT();
    private static final int CHAR_HEIGHT = 12;
    private static final int OFFSET = 15;
    private static final int INDENT = 3;
    private List info;
    public static final int UPPER_LEFT = 0;
    public static final int LOWER_LEFT = 1;
    public static final int UPPER_RIGHT = 2;
    public static final int LOWER_RIGHT = 3;
    static List<InfoOverlay> infoOverlays = new Vector<InfoOverlay>();
    public static boolean together = true;

    public void setInfoProvider(InfoProvider ip) {
        this.infoProvider = ip;
    }

    static void setAllVisible(boolean b) {
        for (InfoOverlay io : infoOverlays) {
            io.visible = b;
        }
    }

    public InfoOverlay(AbstractViewer v) {
        this.viewer = v;
        this.viewer.getDrawable().addGLEventListener((GLEventListener)this);
        infoOverlays.add(this);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        if (together) {
            InfoOverlay.setAllVisible(visible);
        } else {
            this.visible = visible;
        }
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setInfoStrings(List s) {
        this.info = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display(GLAutoDrawable glDrawable) {
        if (!this.visible) {
            return;
        }
        if (this.infoProvider != null) {
            this.infoProvider.updateInfoStrings(this);
        }
        if (this.info == null || this.info.size() == 0) {
            return;
        }
        GL gl = glDrawable.getGL();
        GLU glu = new GLU();
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glMatrixMode(5889);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        Dimension size = new Dimension(glDrawable.getWidth(), glDrawable.getHeight());
        gl.glViewport(0, 0, size.width, size.height);
        gl.glPushAttrib(8192);
        gl.glDisable(3042);
        gl.glDisable(2896);
        gl.glDisable(3553);
        gl.glDisable(2929);
        for (int i = 0; i < 6; ++i) {
            gl.glDisable(i + 12288);
        }
        int[] viewPort = new int[4];
        gl.glGetIntegerv(2978, viewPort, 0);
        try {
            glu.gluOrtho2D(0.0, (double)viewPort[2], (double)viewPort[3], 0.0);
        }
        catch (GLException e) {
            return;
        }
        gl.glColor3f(1.0f, 1.0f, 1.0f);
        int offset = this.position == 1 || this.position == 3 ? -15 : 15;
        int x = this.position == 3 || this.position == 2 ? viewPort[2] / 2 : 15;
        x += 3;
        int maxx = 0;
        int y = this.position == 1 || this.position == 3 ? viewPort[3] - 12 : 12;
        y += offset;
        if (this.info != null && this.info.size() > 0) {
            gl.glRasterPos2i(x, y);
            y += offset;
            x += 3;
            for (int i = 0; i < this.info.size(); ++i) {
                gl.glRasterPos2f((float)x, (float)y);
                String text = null;
                List list = this.info;
                synchronized (list) {
                    text = (String)this.info.get(i);
                }
                this.glut.glutBitmapString(7, text);
                maxx = Math.max(maxx, 15 + this.glut.glutBitmapLength(7, text));
                y += offset;
            }
        }
        gl.glPopAttrib();
        gl.glPopMatrix();
        gl.glMatrixMode(5888);
        gl.glPopMatrix();
    }

    public void displayChanged(GLAutoDrawable glDrawable, boolean b, boolean b1) {
    }

    public void init(GLAutoDrawable glDrawable) {
    }

    public void reshape(GLAutoDrawable glDrawable, int i, int i1, int i2, int i3) {
    }

    public static InfoOverlay perfInfoOverlayFor(final AbstractViewer v) {
        final InfoOverlay perfInfo = new InfoOverlay(v);
        final Vector infoStrings = new Vector();
        perfInfo.setPosition(3);
        perfInfo.setInfoProvider(new InfoProvider(){

            public void updateInfoStrings(InfoOverlay io) {
                InfoOverlay.updateInfoStrings(v, infoStrings, perfInfo);
            }
        });
        return perfInfo;
    }

    public static void updateInfoStrings(AbstractViewer v, List<String> s, InfoOverlay io) {
        if (s != null) {
            s.clear();
        } else {
            s = new ArrayList<String>();
        }
        s.add("Real FPS: " + v.getRenderer().getFramerate());
        s.add("Clock FPS: " + v.getRenderer().getClockrate());
        s.add("Polygon Count:" + v.getRenderer().getPolygonCount());
        s.add(InfoOverlay.getMemoryUsage());
        io.setInfoStrings(s);
    }

    public static String getMemoryUsage() {
        Runtime r = Runtime.getRuntime();
        int block = 1024;
        return "Memory usage: " + (r.totalMemory() / (long)block - r.freeMemory() / (long)block) + " kB";
    }

    public static interface InfoProvider {
        public void updateInfoStrings(InfoOverlay var1);
    }
}

