/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl;

import de.jreality.jogl.JOGLConfiguration;
import de.jreality.jogl.JOGLRenderer;
import de.jreality.jogl.SwtQueue;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Viewer;
import de.jreality.util.SceneGraphUtility;
import java.awt.Dimension;
import java.util.logging.Level;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.opengl.GLCanvas;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class SwtViewer
implements Viewer,
Runnable {
    protected SceneGraphComponent sceneRoot;
    SceneGraphComponent auxiliaryRoot;
    SceneGraphPath cameraPath;
    JOGLRenderer renderer;
    public static final int CROSS_EYED_STEREO = 0;
    public static final int RED_BLUE_STEREO = 1;
    public static final int RED_GREEN_STEREO = 2;
    public static final int RED_CYAN_STEREO = 3;
    public static final int HARDWARE_BUFFER_STEREO = 4;
    public static final int STEREO_TYPES = 5;
    int stereoType = 0;
    GLCanvas canvas;
    private int metric;
    private Dimension myDimension = new Dimension();
    private boolean pendingUpdate;
    private final Object renderLock = new Object();
    boolean autoSwapBuffers = true;
    private GLContext context;
    boolean init = true;
    int rot = 0;

    public SwtViewer(GLCanvas canvas) {
        this(null, null, canvas);
    }

    public SwtViewer(SceneGraphPath camPath, SceneGraphComponent root, GLCanvas canvas) {
        this.canvas = canvas;
        this.setAuxiliaryRoot(SceneGraphUtility.createFullSceneGraphComponent("AuxiliaryRoot"));
        this.initializeFrom(root, camPath);
        this.init();
    }

    public SceneGraphComponent getSceneRoot() {
        return this.sceneRoot;
    }

    public void setSceneRoot(SceneGraphComponent r) {
        if (r == null) {
            JOGLConfiguration.getLogger().log(Level.WARNING, "Null scene root, not setting.");
            return;
        }
        this.sceneRoot = r;
    }

    public SceneGraphComponent getAuxiliaryRoot() {
        return this.auxiliaryRoot;
    }

    public void setAuxiliaryRoot(SceneGraphComponent auxiliaryRoot) {
        this.auxiliaryRoot = auxiliaryRoot;
        if (this.renderer != null) {
            this.renderer.setAuxiliaryRoot(auxiliaryRoot);
        }
    }

    public SceneGraphPath getCameraPath() {
        return this.cameraPath;
    }

    public void setCameraPath(SceneGraphPath p) {
        this.cameraPath = p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderAsync() {
        Object object = this.renderLock;
        synchronized (object) {
            if (!this.pendingUpdate) {
                if (this.canvas.isDisposed()) {
                    return;
                }
                if (Thread.currentThread() == this.canvas.getDisplay().getThread()) {
                    this.run();
                } else {
                    this.canvas.getDisplay().asyncExec((Runnable)this);
                    this.pendingUpdate = true;
                }
            }
        }
    }

    public boolean hasViewingComponent() {
        return false;
    }

    public Object getViewingComponent() {
        return this.canvas;
    }

    public void initializeFrom(Viewer v) {
        this.initializeFrom(v.getSceneRoot(), v.getCameraPath());
    }

    public int getMetric() {
        return this.metric;
    }

    public void setMetric(int metric) {
        this.metric = metric;
        SceneGraphUtility.setMetric(this.sceneRoot, metric);
    }

    public void setStereoType(int type) {
        this.renderer.setStereoType(type);
    }

    public int getStereoType() {
        return this.renderer.getStereoType();
    }

    public JOGLRenderer getRenderer() {
        return this.renderer;
    }

    public void addAuxiliaryComponent(SceneGraphComponent aux) {
        if (this.auxiliaryRoot == null) {
            this.setAuxiliaryRoot(SceneGraphUtility.createFullSceneGraphComponent("AuxiliaryRoot"));
        }
        if (!this.auxiliaryRoot.isDirectAncestor(aux)) {
            this.auxiliaryRoot.addChild(aux);
        }
    }

    public void removeAuxiliaryComponent(SceneGraphComponent aux) {
        if (this.auxiliaryRoot == null) {
            return;
        }
        if (!this.auxiliaryRoot.isDirectAncestor(aux)) {
            return;
        }
        this.auxiliaryRoot.removeChild(aux);
    }

    private void initializeFrom(SceneGraphComponent r, SceneGraphPath p) {
        this.setSceneRoot(r);
        this.setCameraPath(p);
        this.renderer = new JOGLRenderer(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRendering() {
        Object object = this.renderLock;
        synchronized (object) {
            return this.pendingUpdate;
        }
    }

    public void init() {
        System.err.println("SwtViewer init");
        this.canvas.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Rectangle bounds = SwtViewer.this.canvas.getBounds();
                ((SwtViewer)SwtViewer.this).myDimension.width = bounds.width;
                ((SwtViewer)SwtViewer.this).myDimension.height = bounds.height;
                System.err.println("GLCanvas resize to " + SwtViewer.this.myDimension);
                SwtViewer.this.renderer.setSize(((SwtViewer)SwtViewer.this).myDimension.width, ((SwtViewer)SwtViewer.this).myDimension.height);
            }
        });
        this.canvas.setCurrent();
        this.context = GLDrawableFactory.getFactory().createExternalGLContext();
        Rectangle bounds = this.canvas.getBounds();
        this.myDimension.width = bounds.width;
        this.myDimension.height = bounds.height;
        this.renderer.setSize(this.myDimension.width, this.myDimension.height);
        this.canvas.setCurrent();
        this.context.makeCurrent();
        GL gl = this.context.getGL();
        this.renderer.init(gl);
        this.context.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.canvas.isDisposed()) {
            return;
        }
        if (Thread.currentThread() != this.canvas.getDisplay().getThread()) {
            throw new IllegalStateException();
        }
        Object object = this.renderLock;
        synchronized (object) {
            this.pendingUpdate = false;
            this.canvas.setCurrent();
            this.context.makeCurrent();
            GL gl = this.context.getGL();
            System.err.println("Call renderer");
            this.renderer.display(gl);
            this.canvas.swapBuffers();
            this.context.release();
            this.renderLock.notifyAll();
        }
    }

    public GLCanvas getGLCanvas() {
        return this.canvas;
    }

    public double getAspectRatio() {
        return this.renderer.getAspectRatio();
    }

    public Dimension getViewingComponentSize() {
        return new Dimension(this.myDimension);
    }

    public boolean canRenderAsync() {
        return true;
    }

    public void render() {
        SwtQueue.getInstance().waitFor(this);
    }
}

