/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl;

import de.jreality.geometry.SphereUtility;
import de.jreality.jogl.JOGLConfiguration;
import de.jreality.jogl.JOGLRenderer;
import de.jreality.jogl.JOGLRendererHelper;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.util.CameraUtility;
import java.util.WeakHashMap;
import java.util.logging.Level;
import javax.media.opengl.GL;

public class JOGLSphereHelper
extends SphereUtility {
    static boolean sharedDisplayLists;
    static WeakHashMap<GL, int[]> sphereDListsTable;
    static int[] globalSharedSphereDisplayLists;
    static double[] lodLevels;

    public static void setupSphereDLists(JOGLRenderer jr) {
        sharedDisplayLists = JOGLConfiguration.sharedContexts;
        int[] dlists = null;
        GL gl = jr.globalGL;
        int n = SphereUtility.tessellatedCubes.length;
        dlists = null;
        dlists = new int[n];
        for (int i = 0; i < n; ++i) {
            SceneGraphComponent tcs = JOGLSphereHelper.tessellatedCubeSphere(i, false);
            dlists[i] = gl.glGenLists(1);
            gl.glNewList(dlists[i], 4864);
            IndexedFaceSet qms = (IndexedFaceSet)tcs.getChildComponent(0).getGeometry();
            for (int j = 0; j < tcs.getChildComponentCount(); ++j) {
                gl.glPushMatrix();
                gl.glMultTransposeMatrixd(tcs.getChildComponent(j).getTransformation().getMatrix(), 0);
                JOGLRendererHelper.drawFaces(jr, qms, true, 1.0);
                gl.glPopMatrix();
            }
            gl.glEndList();
        }
        if (!sharedDisplayLists) {
            sphereDListsTable.put(jr.globalGL, dlists);
        } else {
            globalSharedSphereDisplayLists = dlists;
        }
    }

    public static int getSphereDLists(int i, JOGLRenderer jr) {
        int[] dlists = JOGLSphereHelper.getSphereDLists(jr);
        if (dlists == null) {
            JOGLConfiguration.getLogger().log(Level.WARNING, "Invalid sphere display lists");
            return 0;
        }
        return dlists[i];
    }

    public static int[] getSphereDLists(JOGLRenderer jr) {
        int[] dlists = !sharedDisplayLists ? sphereDListsTable.get(jr.globalGL) : globalSharedSphereDisplayLists;
        if (dlists == null) {
            JOGLSphereHelper.setupSphereDLists(jr);
            dlists = !sharedDisplayLists ? sphereDListsTable.get(jr.globalGL) : globalSharedSphereDisplayLists;
        }
        if (dlists == null) {
            throw new IllegalStateException("Can't make sphere display lists successfully");
        }
        return dlists;
    }

    public static void disposeSphereDLists(JOGLRenderer jr) {
        if (!sharedDisplayLists) {
            sphereDListsTable.remove(jr);
        }
    }

    public static int getResolutionLevel(double[] o2ndc, double lod) {
        double d = lod * CameraUtility.getNDCExtent(o2ndc);
        int i = 0;
        for (i = 0; i < 5 && !(d < lodLevels[i]); ++i) {
        }
        return i;
    }

    static {
        sphereDListsTable = new WeakHashMap();
        globalSharedSphereDisplayLists = null;
        lodLevels = new double[]{0.02, 0.08, 0.16, 0.32, 0.64};
    }
}

