/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl;

import de.jreality.jogl.JOGLConfiguration;
import de.jreality.jogl.JOGLRenderer;
import de.jreality.scene.DirectionalLight;
import de.jreality.scene.Light;
import de.jreality.scene.PointLight;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.SceneGraphPathObserver;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.SpotLight;
import de.jreality.scene.event.TransformationEvent;
import de.jreality.scene.event.TransformationListener;
import java.util.HashMap;
import java.util.List;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOGLLightHelper {
    private double[] mat = new double[16];
    private transient double[][] matlist;
    private int lightCount = 16384;
    private GL lightGL = null;
    private int maxLights = 8;
    protected JOGLRenderer jr;
    private SceneGraphVisitor ogllv = new SceneGraphVisitor(){

        public void visit(Light l) {
            JOGLLightHelper.this.wisit(l, JOGLLightHelper.this.lightGL, JOGLLightHelper.this.lightCount);
        }

        public void visit(DirectionalLight l) {
            JOGLLightHelper.this.wisit(l, JOGLLightHelper.this.lightGL, JOGLLightHelper.this.lightCount);
        }

        public void visit(PointLight l) {
            JOGLLightHelper.this.wisit(l, JOGLLightHelper.this.lightGL, JOGLLightHelper.this.lightCount);
        }

        public void visit(SpotLight l) {
            JOGLLightHelper.this.wisit(l, JOGLLightHelper.this.lightGL, JOGLLightHelper.this.lightCount);
        }
    };
    HashMap<SceneGraphPath, SceneGraphPathObserver> lightListeners = new HashMap();
    private float[] zDirection = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
    private float[] origin = new float[]{0.0f, 0.0f, 0.0f, 1.0f};

    protected JOGLLightHelper(JOGLRenderer r) {
        this.jr = r;
    }

    protected void resetLights(GL globalGL, List<SceneGraphPath> lights) {
        for (int i = 0; i < this.maxLights; ++i) {
            globalGL.glLightf(16384 + i, 4614, 0.0f);
            globalGL.glLightf(16384 + i, 4613, 0.0f);
            globalGL.glLightf(16384 + i, 4615, 1.0f);
            globalGL.glLightf(16384 + i, 4616, 0.0f);
            globalGL.glLightf(16384 + i, 4617, 0.0f);
            globalGL.glDisable(16384 + i);
        }
        int n = lights.size();
        for (int i = 8; i < n; ++i) {
            lights.remove(i);
        }
        for (SceneGraphPath sgp : lights) {
            SceneGraphPathObserver sgpo = new SceneGraphPathObserver(sgp);
            sgpo.addTransformationListener(new TransformationListener(){

                public void transformationMatrixChanged(TransformationEvent ev) {
                    JOGLLightHelper.this.jr.lightsChanged = true;
                }
            });
            this.lightListeners.put(sgp, sgpo);
        }
        this.cacheLightMatrices(lights);
    }

    protected void cacheLightMatrices(List<SceneGraphPath> lights) {
        int n = lights.size();
        this.matlist = new double[n][16];
        for (int i = 0; i < n; ++i) {
            SceneGraphPath lp = lights.get(i);
            SceneGraphNode light = lp.getLastElement();
            if (!(light instanceof Light)) {
                JOGLConfiguration.theLog.warning("Invalid light path: no light there");
                continue;
            }
            lp.getMatrix(this.matlist[i]);
        }
    }

    protected void disposeLights() {
        for (SceneGraphPathObserver obs : this.lightListeners.values()) {
            obs.dispose();
        }
        this.lightListeners.clear();
    }

    public void enableLights(GL globalGL, int num) {
        for (int i = 0; i < num; ++i) {
            globalGL.glEnable(16384 + i);
        }
    }

    public void processLights(GL globalGL, List<SceneGraphPath> lights) {
        this.lightCount = 16384;
        this.lightGL = globalGL;
        int n = lights.size();
        for (int i = 0; i < n; ++i) {
            SceneGraphNode light = lights.get(i).getLastElement();
            globalGL.glPushMatrix();
            globalGL.glMultTransposeMatrixd(this.matlist[i], 0);
            light.accept(this.ogllv);
            globalGL.glPopMatrix();
            ++this.lightCount;
        }
    }

    private void wisit(Light dl, GL globalGL, int lightCount) {
        globalGL.glLightf(lightCount, 4614, 180.0f);
        globalGL.glLightfv(lightCount, 4609, dl.getScaledColorAsFloat(), 0);
        float f = (float)dl.getIntensity();
        float[] specC = new float[]{f, f, f};
        globalGL.glLightfv(lightCount, 4610, specC, 0);
        globalGL.glLightfv(lightCount, 4608, dl.getScaledColorAsFloat(), 0);
    }

    private void wisit(DirectionalLight dl, GL globalGL, int lightCount) {
        this.wisit((Light)dl, globalGL, lightCount);
        globalGL.glLightfv(lightCount, 4611, this.zDirection, 0);
    }

    private void wisit(PointLight dl, GL globalGL, int lightCount) {
        this.wisit((Light)dl, globalGL, lightCount);
        globalGL.glLightfv(lightCount, 4611, this.origin, 0);
        globalGL.glLightf(lightCount, 4615, (float)dl.getFalloffA0());
        globalGL.glLightf(lightCount, 4616, (float)dl.getFalloffA1());
        globalGL.glLightf(lightCount, 4617, (float)dl.getFalloffA2());
    }

    private void wisit(SpotLight dl, GL globalGL, int lightCount) {
        this.wisit((PointLight)dl, globalGL, lightCount);
        globalGL.glLightf(lightCount, 4614, (float)(57.29577951308232 * dl.getConeAngle()));
        globalGL.glLightfv(lightCount, 4612, this.zDirection, 0);
        globalGL.glLightf(lightCount, 4613, (float)dl.getDistribution());
    }
}

