/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl;

import com.sun.opengl.util.Animator;
import de.jreality.math.Rn;
import java.awt.Component;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Random;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.swing.JFrame;

public class GpgpuUtility {
    private GpgpuUtility() {
    }

    static int texSize(int i) {
        double fl = Math.floor(Math.sqrt(i));
        return (int)(fl * fl < (double)i ? fl + 1.0 : fl);
    }

    public static void dumpData(float[] data) {
        for (int i = 0; i < data.length; ++i) {
            System.out.print(data[i] + ", ");
        }
        System.out.println();
    }

    public static void dumpData(IntBuffer data) {
        data.clear();
        for (int i = 0; i < data.capacity(); ++i) {
            System.out.print(data.get(i) + ", ");
        }
        System.out.println();
    }

    public static void dumpData(FloatBuffer data) {
        data.clear();
        for (int i = 0; i < data.capacity(); ++i) {
            System.out.print(data.get(i) + ", ");
        }
        System.out.println();
    }

    public static void dumpSelectedData(FloatBuffer data) {
        while (data.hasRemaining()) {
            System.out.print(data.get() + ", ");
        }
        System.out.println();
    }

    static void checkBuf(GL gl) {
        String res = GpgpuUtility.checkFrameBufferStatus(gl);
        if (!res.equals("OK")) {
            throw new RuntimeException(res);
        }
    }

    private static String checkFrameBufferStatus(GL gl) {
        int status = gl.glCheckFramebufferStatusEXT(36160);
        switch (status) {
            case 36056: {
                return "FrameBuffer incomplete duplicate";
            }
            case 36057: {
                return "FrameBuffer incomplete dimensions";
            }
            case 36058: {
                return "FrameBuffer incomplete formats";
            }
            case 36059: {
                return "FrameBuffer incomplete draw buffer";
            }
            case 36060: {
                return "FrameBuffer incomplete read buffer";
            }
            case 36053: {
                return "OK";
            }
            case 36061: {
                return "FrameBuffer unsupported";
            }
        }
        return "FrameBuffer unrecognized error";
    }

    public static void run(GLEventListener listener) {
        JFrame f = new JFrame("gpgpu runner");
        f.setDefaultCloseOperation(3);
        GLCapabilities capabilities = new GLCapabilities();
        GLCanvas canvas = new GLCanvas(capabilities);
        Animator animator = new Animator((GLAutoDrawable)canvas);
        canvas.setSize(256, 256);
        canvas.addGLEventListener(listener);
        f.getContentPane().add((Component)canvas, "Center");
        f.pack();
        f.show();
        animator.start();
    }

    static void atiHack(FloatBuffer fb) {
        int n = fb.remaining() / 4;
        for (int i = 0; i < n; ++i) {
            float tmp = fb.get(4 * i);
            fb.put(4 * i, fb.get(4 * i + 2));
            fb.put(4 * i + 2, tmp);
        }
    }

    public static float[] makeGradient(int sl) {
        float[] f = new float[sl * sl * 4];
        for (int i = 0; i < sl; ++i) {
            for (int j = 0; j < sl; ++j) {
                f[4 * (sl * i + j) + 0] = (float)i / (float)sl;
                f[4 * (sl * i + j) + 1] = (float)j / (float)sl;
                f[4 * (sl * i + j) + 2] = 0.0f;
                f[4 * (sl * i + j) + 3] = 1.0f;
            }
        }
        return f;
    }

    public static float[] makeGradient(int sl, int dismissCnt) {
        float[] f = new float[(sl * sl - dismissCnt) * 4];
        int remaining = sl * sl;
        for (int i = 0; i < sl; ++i) {
            for (int j = 0; j < sl; ++j) {
                if (--remaining < dismissCnt) {
                    return f;
                }
                f[4 * (sl * i + j) + 0] = (float)i / (float)sl;
                f[4 * (sl * i + j) + 1] = (float)j / (float)sl;
                f[4 * (sl * i + j) + 2] = 0.0f;
                f[4 * (sl * i + j) + 3] = 1.0f;
            }
        }
        return f;
    }

    public static float[] makeSphere(int numPoints, double[] origin, double radius1, double radius2) {
        float[] points = new float[numPoints * 4];
        Random r = new Random(System.currentTimeMillis());
        double[] tmp = new double[3];
        for (int i = 0; i < numPoints; ++i) {
            Rn.setToValue(tmp, -0.5 + r.nextDouble(), -0.5 + r.nextDouble(), -0.5 + r.nextDouble());
            Rn.normalize(tmp, tmp);
            Rn.times(tmp, radius1 + r.nextDouble() * (radius2 - radius1), tmp);
            if (origin != null) {
                Rn.add(tmp, origin, tmp);
            }
            points[4 * i + 0] = (float)tmp[0];
            points[4 * i + 1] = (float)tmp[1];
            points[4 * i + 2] = (float)tmp[2];
            points[4 * i + 3] = 1.0f;
        }
        return points;
    }
}

