/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl;

import de.jreality.jogl.JOGLConfiguration;
import de.jreality.jogl.JOGLPeerGeometry;
import de.jreality.jogl.JOGLRenderer;
import de.jreality.scene.Geometry;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphVisitor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.WeakHashMap;
import java.util.logging.Level;
import javax.swing.Timer;

public class GeometryGoBetween {
    JOGLRenderer jr;
    Timer followTimer;
    boolean geometryRemoved = false;
    boolean checkMemoryLeak = false;
    int geomDiff = 0;
    protected HashMap<Geometry, JOGLPeerGeometry> geometries = new HashMap();

    protected GeometryGoBetween(JOGLRenderer jr) {
        this.jr = jr;
        this.followTimer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GeometryGoBetween.this.updateGeometryHashtable();
            }
        });
        if (this.checkMemoryLeak) {
            this.followTimer.start();
        }
    }

    public void dispose() {
        this.followTimer.setRepeats(false);
        this.followTimer.stop();
        this.followTimer = null;
    }

    protected void updateGeometryHashtable() {
        if (!this.geometryRemoved) {
            return;
        }
        final WeakHashMap newG = new WeakHashMap();
        SceneGraphVisitor cleanup = new SceneGraphVisitor(){

            public void visit(SceneGraphComponent c) {
                if (c.getGeometry() != null) {
                    Geometry wawa = c.getGeometry();
                    JOGLPeerGeometry peer = GeometryGoBetween.this.geometries.get(wawa);
                    newG.put(wawa, peer);
                }
                c.childrenAccept(this);
            }
        };
        cleanup.visit(this.jr.theRoot);
        this.geometryRemoved = false;
        if (this.geometries.size() - newG.size() != this.geomDiff) {
            JOGLConfiguration.theLog.log(Level.WARNING, "Old, new hash size: " + this.geometries.size() + " " + newG.size());
            this.geomDiff = this.geometries.size() - newG.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JOGLPeerGeometry getJOGLPeerGeometryFor(Geometry g) {
        JOGLPeerGeometry pg;
        HashMap<Geometry, JOGLPeerGeometry> hashMap = this.geometries;
        synchronized (hashMap) {
            pg = this.geometries.get(g);
            if (pg != null) {
                return pg;
            }
            pg = new JOGLPeerGeometry(g, this.jr);
            this.geometries.put(g, pg);
        }
        return pg;
    }
}

