/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.io.jrs;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.StringTokenizer;

class IntArrayConverter
implements Converter {
    Mapper mapper;

    public IntArrayConverter(Mapper mapper) {
        this.mapper = mapper;
    }

    public boolean canConvert(Class type) {
        return type == int[].class;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        int[] data = (int[])source;
        StringBuffer sb = new StringBuffer();
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            sb.append(data[i]).append(' ');
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 1, sb.length());
        }
        writer.setValue(sb.toString());
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        StringTokenizer st = new StringTokenizer(reader.getValue());
        int[] data = new int[st.countTokens()];
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            data[i] = Integer.parseInt(st.nextToken());
        }
        return data;
    }
}

