/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.geometry;

import de.jreality.geometry.GeometryUtility;
import de.jreality.geometry.IndexedFaceSetUtility;
import de.jreality.geometry.QuadMeshFactory;
import java.awt.geom.Rectangle2D;

public class HeightFieldFactory
extends QuadMeshFactory {
    Rectangle2D theDomain = new Rectangle2D.Double(-1.0, -1.0, 2.0, 2.0);
    boolean domainHasChanged = true;

    public void setRegularDomain(Rectangle2D r) {
        this.theDomain = r;
    }

    public Rectangle2D getRegularDomain() {
        return this.theDomain;
    }

    protected void updateImpl() {
        super.updateImpl();
        if (this.domainHasChanged) {
            this.ifs.setGeometryAttributes(GeometryUtility.HEIGHT_FIELD_SHAPE, this.theDomain);
        }
        this.domainHasChanged = false;
    }

    double[][] generateFaceNormals() {
        int[][] fi = (int[][])this.faceIndices.getObject();
        double[][] vc = (double[][])this.vertexCoordinates.getObject();
        if (fi == null || vc == null) {
            return null;
        }
        return this.calculateFaceNormals(fi, vc, this.getMetric());
    }

    private double[][] calculateFaceNormals(int[][] is, double[][] ds, int metric) {
        double[][] fullcoords = new double[ds.length][3];
        double[] foo = new double[2];
        int maxu = this.getULineCount();
        int maxv = this.getVLineCount();
        for (int i = 0; i < maxv; ++i) {
            int k = i * maxu;
            for (int j = 0; j < maxu; ++j) {
                HeightFieldFactory.getCoordinatesForUV(foo, this.theDomain, j, i, maxu, maxv);
                fullcoords[k + j][0] = foo[0];
                fullcoords[k + j][1] = foo[1];
                fullcoords[k + j][2] = ds[k + j][0];
            }
        }
        return IndexedFaceSetUtility.calculateFaceNormals(is, fullcoords, metric);
    }

    public static double[] getCoordinatesForUV(double[] store, Rectangle2D d, int u, int v, int uc, int vc) {
        if (store == null) {
            store = new double[]{d.getMinX() + d.getWidth() * ((double)u / ((double)uc - 1.0)), d.getMinY() + d.getHeight() * ((double)v / ((double)vc - 1.0))};
        }
        return store;
    }
}

