/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.geometry;

import de.jreality.geometry.AbstractIndexedFaceSetFactory;
import de.jreality.geometry.AbstractPointSetFactory;
import de.jreality.geometry.GeometryUtility;
import de.jreality.geometry.OoNode;
import de.jreality.math.Rn;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataList;
import de.jreality.util.LoggingSystem;
import java.awt.Dimension;
import java.util.logging.Level;

public class AbstractQuadMeshFactory
extends AbstractIndexedFaceSetFactory {
    AbstractPointSetFactory.AttributeGenerator textureCoordinates;
    final OoNode closedInVDirection;
    final OoNode closedInUDirection;
    final OoNode vLineCount;
    final OoNode uLineCount;
    private int uLineCount_;
    double uTextureScale;
    double vTextureScale;
    double uTextureShift;
    double vTextureShift;
    final OoNode edgeFromQuadMesh;

    AbstractQuadMeshFactory() {
        this(0, 10, 10, false, false);
    }

    AbstractQuadMeshFactory(IndexedFaceSet existing) {
        this(existing, 0, 10, 10, false, false);
    }

    AbstractQuadMeshFactory(int mMaxU, int mMaxV, boolean closeU, boolean closeV) {
        this(0, mMaxU, mMaxV, closeU, closeV);
    }

    AbstractQuadMeshFactory(int metric, int mMaxU, int mMaxV, boolean closeU, boolean closeV) {
        this(new IndexedFaceSet(), metric, mMaxU, mMaxV, closeU, closeV);
    }

    AbstractQuadMeshFactory(IndexedFaceSet existing, int metric, int mMaxU, int mMaxV, boolean closeU, boolean closeV) {
        super(existing == null ? new IndexedFaceSet() : existing, metric);
        this.textureCoordinates = this.attributeGeneratorNode(this.vertex, double[][].class, Attribute.TEXTURE_COORDINATES);
        this.closedInVDirection = this.node(new Boolean(false), "closed in v");
        this.closedInUDirection = this.node(new Boolean(false), "closed in u");
        this.vLineCount = this.node(new Integer(-1), "v-line count");
        this.uLineCount = this.node(new Integer(-1), "u-line count");
        this.uTextureScale = 1.0;
        this.vTextureScale = 1.0;
        this.uTextureShift = 0.0;
        this.vTextureShift = 0.0;
        this.edgeFromQuadMesh = this.node(new Boolean(false), "one edge per parametric curve");
        this.vertexNormals.addIngr(this.closedInUDirection);
        this.vertexNormals.addIngr(this.closedInVDirection);
        this.setMeshSize(mMaxU, mMaxV);
        this.setClosedInUDirection(closeU);
        this.setClosedInVDirection(closeV);
        this.faceIndices.setGenerate(true);
        this.setGenerateTextureCoordinates(true);
        this.edgeIndices.addIngr(this.faceIndices);
        this.edgeIndices.addIngr(this.edgeFromQuadMesh);
        this.edgeIndices.setUpdateMethod(new OoNode.UpdateMethod(){

            public Object update(Object object) {
                return AbstractQuadMeshFactory.this.generateEdgeIndices();
            }
        });
        this.faceIndices.addIngr(this.uLineCount);
        this.faceIndices.addIngr(this.vLineCount);
        this.faceIndices.setUpdateMethod(new OoNode.UpdateMethod(){

            public Object update(Object object) {
                return AbstractQuadMeshFactory.this.generateFaceIndices((int[][])object);
            }
        });
        this.textureCoordinates.addIngr(this.uLineCount);
        this.textureCoordinates.addIngr(this.vLineCount);
        this.textureCoordinates.setUpdateMethod(new OoNode.UpdateMethod(){

            public Object update(Object object) {
                return AbstractQuadMeshFactory.this.generateTextureCoordinates((double[][])object);
            }
        });
    }

    void setMeshSize(int maxU2, int maxV2) {
        if (maxU2 < 2 || maxV2 < 2) {
            throw new IllegalArgumentException("line count must be bigger then 1");
        }
        if (maxU2 == this.getULineCount() && maxV2 == this.getVLineCount()) {
            return;
        }
        this.uLineCount.setObject(new Integer(maxU2));
        this.uLineCount_ = maxU2;
        this.vLineCount.setObject(new Integer(maxV2));
        super.setVertexCount(this.getULineCount() * this.getVLineCount());
        super.setFaceCount((this.getULineCount() - 1) * (this.getVLineCount() - 1));
    }

    public void setVertexCount(int count) {
        throw new UnsupportedOperationException();
    }

    public void setFaceCount(int count) {
        throw new UnsupportedOperationException();
    }

    public void setFaceAttribute(Attribute attr, DataList data) {
        if (attr == Attribute.INDICES) {
            throw new UnsupportedOperationException("cannot set indices of a quad mesh");
        }
        super.setFaceAttribute(attr, data);
    }

    int[][] generateEdgeIndices() {
        int j;
        int i;
        int vLineCount;
        if (!((Boolean)this.edgeFromQuadMesh.getObject()).booleanValue()) {
            return super.generateEdgeIndices();
        }
        int uLineCount = this.getULineCount();
        int sizeUCurve = vLineCount = this.getVLineCount();
        int sizeVCurve = uLineCount;
        int numVerts = this.getULineCount() * this.getVLineCount();
        int nbOfEdges = uLineCount + vLineCount;
        int[][] indices = new int[nbOfEdges][];
        for (i = 0; i < uLineCount; ++i) {
            indices[i] = new int[sizeUCurve];
            for (j = 0; j < sizeUCurve; ++j) {
                indices[i][j] = (j * uLineCount + i % uLineCount) % numVerts;
            }
        }
        for (i = 0; i < vLineCount; ++i) {
            indices[i + uLineCount] = new int[sizeVCurve];
            for (j = 0; j < sizeVCurve; ++j) {
                indices[i + uLineCount][j] = (i * uLineCount + j % uLineCount) % numVerts;
            }
        }
        return indices;
    }

    int[][] generateFaceIndices(int[][] faceIndices) {
        int uLineCount = this.getULineCount();
        int vLineCount = this.getVLineCount();
        this.log("compute", Attribute.INDICES, "face");
        if (faceIndices == null || this.nof() != faceIndices.length) {
            faceIndices = new int[this.nof()][4];
        }
        int numUFaces = uLineCount - 1;
        int numVFaces = vLineCount - 1;
        int numPoints = this.nov();
        int k = 0;
        for (int i = 0; i < numVFaces; ++i) {
            int j = 0;
            while (j < numUFaces) {
                int[] face = faceIndices[k];
                face[0] = i * uLineCount + j;
                face[1] = ((i + 1) * uLineCount + j) % numPoints;
                face[2] = ((i + 1) * uLineCount + (j + 1) % uLineCount) % numPoints;
                face[3] = (i * uLineCount + (j + 1) % uLineCount) % numPoints;
                ++j;
                ++k;
            }
        }
        return faceIndices;
    }

    public int getULineCount() {
        return (Integer)this.uLineCount.getObject();
    }

    public int getVLineCount() {
        return (Integer)this.vLineCount.getObject();
    }

    public void setULineCount(int newU) {
        this.setMeshSize(newU, this.getVLineCount());
    }

    public void setVLineCount(int newV) {
        this.setMeshSize(this.getULineCount(), newV);
    }

    public boolean isClosedInUDirection() {
        return (Boolean)this.closedInUDirection.getObject();
    }

    public boolean isClosedInVDirection() {
        return (Boolean)this.closedInVDirection.getObject();
    }

    public void setClosedInUDirection(boolean close) {
        this.closedInUDirection.setObject(new Boolean(close));
    }

    public void setClosedInVDirection(boolean close) {
        this.closedInVDirection.setObject(new Boolean(close));
    }

    double[][] generateTextureCoordinates(double[][] textureCoordinates) {
        if (this.vertex.DLS.containsAttribute(Attribute.TEXTURE_COORDINATES)) {
            return null;
        }
        if (textureCoordinates == null || textureCoordinates.length != this.nov()) {
            textureCoordinates = new double[this.nov()][2];
        }
        int vLineCount = this.getVLineCount();
        int uLineCount = this.getULineCount();
        double dv = 1.0 / (double)(vLineCount - 1) * this.vTextureScale;
        double du = 1.0 / (double)(uLineCount - 1) * this.uTextureScale;
        double v = 0.0;
        int iv = 0;
        int firstIndexInULine = 0;
        while (iv < vLineCount) {
            double u = 0.0;
            int iu = 0;
            while (iu < uLineCount) {
                double[] xy = textureCoordinates[firstIndexInULine + iu];
                xy[0] = u + this.uTextureShift;
                xy[1] = v + this.vTextureShift;
                ++iu;
                u += du;
            }
            ++iv;
            v += dv;
            firstIndexInULine += uLineCount;
        }
        return textureCoordinates;
    }

    void recompute() {
        super.recompute();
        this.faceIndices.update();
        this.textureCoordinates.update();
    }

    protected void updateImpl() {
        super.updateImpl();
        this.log("set", GeometryUtility.QUAD_MESH_SHAPE, "vertex");
        this.ifs.setGeometryAttributes(GeometryUtility.QUAD_MESH_SHAPE, new Dimension(this.getULineCount(), this.getVLineCount()));
        this.edgeIndices.updateArray();
        this.faceIndices.updateArray();
        this.textureCoordinates.updateArray();
    }

    public boolean isGenerateTextureCoordinates() {
        return this.textureCoordinates.isGenerate();
    }

    public void setGenerateTextureCoordinates(boolean generateTextureCoordinates) {
        this.textureCoordinates.setGenerate(generateTextureCoordinates);
    }

    private final int index(int u, int v) {
        return u + this.uLineCount_ * v;
    }

    void average(double[] x, double[] y) {
        Rn.add(x, x, y);
        Rn.times(x, 2.0, x);
        Rn.copy(y, x);
    }

    void normalize(double[] x) {
        Rn.normalize(x, x);
    }

    double[][] generateVertexNormals(double[][] vertexNormals) {
        int i;
        int last;
        vertexNormals = super.generateVertexNormals(vertexNormals);
        if (!this.isClosedInUDirection() && !this.isClosedInVDirection()) {
            return vertexNormals;
        }
        if (this.getMetric() != 0) {
            LoggingSystem.getLogger(this).log(Level.WARNING, "currently only eucledian normals used for smoothing");
        }
        if (this.isClosedInUDirection()) {
            last = this.getULineCount() - 1;
            for (i = 0; i < this.getVLineCount(); ++i) {
                this.average(vertexNormals[this.index(0, i)], vertexNormals[this.index(last, i)]);
            }
        }
        if (this.isClosedInVDirection()) {
            last = this.getVLineCount() - 1;
            for (i = 0; i < this.getULineCount(); ++i) {
                this.average(vertexNormals[this.index(i, 0)], vertexNormals[this.index(i, last)]);
                this.normalize(vertexNormals[this.index(i, 0)]);
                this.normalize(vertexNormals[this.index(i, last)]);
            }
        }
        if (this.isClosedInUDirection()) {
            last = this.getULineCount() - 1;
            for (i = 0; i < this.getVLineCount(); ++i) {
                this.normalize(vertexNormals[this.index(0, i)]);
                this.normalize(vertexNormals[this.index(last, i)]);
            }
        }
        return vertexNormals;
    }

    public double getUTextureScale() {
        return this.uTextureScale;
    }

    public void setUTextureScale(double textureScale) {
        if (this.uTextureScale == textureScale) {
            return;
        }
        this.uTextureScale = textureScale;
        this.textureCoordinates.outdate();
    }

    public double getVTextureScale() {
        return this.vTextureScale;
    }

    public void setVTextureScale(double textureScale) {
        if (this.vTextureScale == textureScale) {
            return;
        }
        this.vTextureScale = textureScale;
        this.textureCoordinates.outdate();
    }

    public double getUTextureShift() {
        return this.uTextureShift;
    }

    public void setUTextureShift(double textureShift) {
        if (this.uTextureShift == textureShift) {
            return;
        }
        this.uTextureShift = textureShift;
        this.textureCoordinates.outdate();
    }

    public double getVTextureShift() {
        return this.vTextureShift;
    }

    public void setVTextureShift(double textureShift) {
        if (this.vTextureShift == textureShift) {
            return;
        }
        this.vTextureShift = textureShift;
        this.textureCoordinates.outdate();
    }

    public boolean isEdgeFromQuadMesh() {
        return (Boolean)this.edgeFromQuadMesh.getObject();
    }

    public void setEdgeFromQuadMesh(boolean b) {
        this.edgeFromQuadMesh.setObject(new Boolean(b));
    }
}

